/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.crypto.macs;

import com.aspose.cad.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.cad.internal.bouncycastle.crypto.Digest;
import com.aspose.cad.internal.bouncycastle.crypto.ExtendedDigest;
import com.aspose.cad.internal.bouncycastle.crypto.Mac;
import com.aspose.cad.internal.bouncycastle.crypto.params.KeyParameter;
import com.aspose.cad.internal.bouncycastle.util.Integers;
import com.aspose.cad.internal.bouncycastle.util.Memoable;
import java.util.Hashtable;

public class HMac
implements Mac {
    private static final byte a = 54;
    private static final byte b = 92;
    private Digest c;
    private int d;
    private int e;
    private Memoable f;
    private Memoable g;
    private byte[] h;
    private byte[] i;
    private static Hashtable j = new Hashtable();

    private static int a(Digest digest) {
        if (digest instanceof ExtendedDigest) {
            return ((ExtendedDigest)digest).getByteLength();
        }
        Integer n2 = (Integer)j.get(digest.getAlgorithmName());
        if (n2 == null) {
            throw new IllegalArgumentException("unknown digest passed: " + digest.getAlgorithmName());
        }
        return n2;
    }

    public HMac(Digest digest) {
        this(digest, HMac.a(digest));
    }

    private HMac(Digest digest, int n2) {
        this.c = digest;
        this.d = digest.getDigestSize();
        this.e = n2;
        this.h = new byte[this.e];
        this.i = new byte[this.e + this.d];
    }

    @Override
    public String getAlgorithmName() {
        return this.c.getAlgorithmName() + "/HMAC";
    }

    public Digest getUnderlyingDigest() {
        return this.c;
    }

    @Override
    public void init(CipherParameters cipherParameters) {
        this.c.reset();
        byte[] byArray = ((KeyParameter)cipherParameters).getKey();
        int n2 = byArray.length;
        if (n2 > this.e) {
            this.c.update(byArray, 0, n2);
            this.c.doFinal(this.h, 0);
            n2 = this.d;
        } else {
            System.arraycopy(byArray, 0, this.h, 0, n2);
        }
        for (int i2 = n2; i2 < this.h.length; ++i2) {
            this.h[i2] = 0;
        }
        System.arraycopy(this.h, 0, this.i, 0, this.e);
        HMac.a(this.h, this.e, (byte)54);
        HMac.a(this.i, this.e, (byte)92);
        if (this.c instanceof Memoable) {
            this.g = ((Memoable)((Object)this.c)).copy();
            ((Digest)((Object)this.g)).update(this.i, 0, this.e);
        }
        this.c.update(this.h, 0, this.h.length);
        if (this.c instanceof Memoable) {
            this.f = ((Memoable)((Object)this.c)).copy();
        }
    }

    @Override
    public int getMacSize() {
        return this.d;
    }

    @Override
    public void update(byte by2) {
        this.c.update(by2);
    }

    @Override
    public void update(byte[] byArray, int n2, int n3) {
        this.c.update(byArray, n2, n3);
    }

    @Override
    public int doFinal(byte[] byArray, int n2) {
        this.c.doFinal(this.i, this.e);
        if (this.g != null) {
            ((Memoable)((Object)this.c)).reset(this.g);
            this.c.update(this.i, this.e, this.c.getDigestSize());
        } else {
            this.c.update(this.i, 0, this.i.length);
        }
        int n3 = this.c.doFinal(byArray, n2);
        for (int i2 = this.e; i2 < this.i.length; ++i2) {
            this.i[i2] = 0;
        }
        if (this.f != null) {
            ((Memoable)((Object)this.c)).reset(this.f);
        } else {
            this.c.update(this.h, 0, this.h.length);
        }
        return n3;
    }

    @Override
    public void reset() {
        this.c.reset();
        this.c.update(this.h, 0, this.h.length);
    }

    private static void a(byte[] byArray, int n2, byte by2) {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n3++;
            byArray[n4] = (byte)(byArray[n4] ^ by2);
        }
    }

    static {
        j.put("GOST3411", Integers.valueOf(32));
        j.put("MD2", Integers.valueOf(16));
        j.put("MD4", Integers.valueOf(64));
        j.put("MD5", Integers.valueOf(64));
        j.put("RIPEMD128", Integers.valueOf(64));
        j.put("RIPEMD160", Integers.valueOf(64));
        j.put("SHA-1", Integers.valueOf(64));
        j.put("SHA-224", Integers.valueOf(64));
        j.put("SHA-256", Integers.valueOf(64));
        j.put("SHA-384", Integers.valueOf(128));
        j.put("SHA-512", Integers.valueOf(128));
        j.put("Tiger", Integers.valueOf(64));
        j.put("Whirlpool", Integers.valueOf(64));
    }
}

