/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.asn1.x9;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.cad.internal.bouncycastle.asn1.DERSequence;
import com.aspose.cad.internal.bouncycastle.asn1.x9.DHValidationParms;
import java.math.BigInteger;
import java.util.Enumeration;

public class DHDomainParameters
extends ASN1Object {
    private ASN1Integer a;
    private ASN1Integer b;
    private ASN1Integer c;
    private ASN1Integer d;
    private DHValidationParms e;

    public static DHDomainParameters getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        return DHDomainParameters.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl2));
    }

    public static DHDomainParameters getInstance(Object object) {
        if (object == null || object instanceof DHDomainParameters) {
            return (DHDomainParameters)object;
        }
        if (object instanceof ASN1Sequence) {
            return new DHDomainParameters((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("Invalid DHDomainParameters: " + object.getClass().getName());
    }

    public DHDomainParameters(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, DHValidationParms dHValidationParms) {
        if (bigInteger == null) {
            throw new IllegalArgumentException("'p' cannot be null");
        }
        if (bigInteger2 == null) {
            throw new IllegalArgumentException("'g' cannot be null");
        }
        if (bigInteger3 == null) {
            throw new IllegalArgumentException("'q' cannot be null");
        }
        this.a = new ASN1Integer(bigInteger);
        this.b = new ASN1Integer(bigInteger2);
        this.c = new ASN1Integer(bigInteger3);
        this.d = new ASN1Integer(bigInteger4);
        this.e = dHValidationParms;
    }

    public DHDomainParameters(ASN1Integer aSN1Integer, ASN1Integer aSN1Integer2, ASN1Integer aSN1Integer3, ASN1Integer aSN1Integer4, DHValidationParms dHValidationParms) {
        if (aSN1Integer == null) {
            throw new IllegalArgumentException("'p' cannot be null");
        }
        if (aSN1Integer2 == null) {
            throw new IllegalArgumentException("'g' cannot be null");
        }
        if (aSN1Integer3 == null) {
            throw new IllegalArgumentException("'q' cannot be null");
        }
        this.a = aSN1Integer;
        this.b = aSN1Integer2;
        this.c = aSN1Integer3;
        this.d = aSN1Integer4;
        this.e = dHValidationParms;
    }

    private DHDomainParameters(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() < 3 || aSN1Sequence.size() > 5) {
            throw new IllegalArgumentException("Bad sequence size: " + aSN1Sequence.size());
        }
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.a = ASN1Integer.getInstance(enumeration.nextElement());
        this.b = ASN1Integer.getInstance(enumeration.nextElement());
        this.c = ASN1Integer.getInstance(enumeration.nextElement());
        ASN1Encodable aSN1Encodable = DHDomainParameters.a(enumeration);
        if (aSN1Encodable != null && aSN1Encodable instanceof ASN1Integer) {
            this.d = ASN1Integer.getInstance(aSN1Encodable);
            aSN1Encodable = DHDomainParameters.a(enumeration);
        }
        if (aSN1Encodable != null) {
            this.e = DHValidationParms.getInstance(aSN1Encodable.toASN1Primitive());
        }
    }

    private static ASN1Encodable a(Enumeration enumeration) {
        return enumeration.hasMoreElements() ? (ASN1Encodable)enumeration.nextElement() : null;
    }

    public ASN1Integer getP() {
        return this.a;
    }

    public ASN1Integer getG() {
        return this.b;
    }

    public ASN1Integer getQ() {
        return this.c;
    }

    public ASN1Integer getJ() {
        return this.d;
    }

    public DHValidationParms getValidationParms() {
        return this.e;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.c);
        if (this.d != null) {
            aSN1EncodableVector.add(this.d);
        }
        if (this.e != null) {
            aSN1EncodableVector.add(this.e);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

