/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.asn1.pkcs;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.cad.internal.bouncycastle.asn1.DERNull;
import com.aspose.cad.internal.bouncycastle.asn1.DEROctetString;
import com.aspose.cad.internal.bouncycastle.asn1.DERSequence;
import com.aspose.cad.internal.bouncycastle.asn1.DERTaggedObject;
import com.aspose.cad.internal.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.aspose.cad.internal.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.cad.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class RSAESOAEPparams
extends ASN1Object {
    private AlgorithmIdentifier a;
    private AlgorithmIdentifier b;
    private AlgorithmIdentifier c;
    public static final AlgorithmIdentifier DEFAULT_HASH_ALGORITHM = new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1, DERNull.INSTANCE);
    public static final AlgorithmIdentifier DEFAULT_MASK_GEN_FUNCTION = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_mgf1, DEFAULT_HASH_ALGORITHM);
    public static final AlgorithmIdentifier DEFAULT_P_SOURCE_ALGORITHM = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_pSpecified, new DEROctetString(new byte[0]));

    public static RSAESOAEPparams getInstance(Object object) {
        if (object instanceof RSAESOAEPparams) {
            return (RSAESOAEPparams)object;
        }
        if (object != null) {
            return new RSAESOAEPparams(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public RSAESOAEPparams() {
        this.a = DEFAULT_HASH_ALGORITHM;
        this.b = DEFAULT_MASK_GEN_FUNCTION;
        this.c = DEFAULT_P_SOURCE_ALGORITHM;
    }

    public RSAESOAEPparams(AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2, AlgorithmIdentifier algorithmIdentifier3) {
        this.a = algorithmIdentifier;
        this.b = algorithmIdentifier2;
        this.c = algorithmIdentifier3;
    }

    public RSAESOAEPparams(ASN1Sequence aSN1Sequence) {
        this.a = DEFAULT_HASH_ALGORITHM;
        this.b = DEFAULT_MASK_GEN_FUNCTION;
        this.c = DEFAULT_P_SOURCE_ALGORITHM;
        block5: for (int i2 = 0; i2 != aSN1Sequence.size(); ++i2) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)aSN1Sequence.getObjectAt(i2);
            switch (aSN1TaggedObject.getTagNo()) {
                case 0: {
                    this.a = AlgorithmIdentifier.getInstance(aSN1TaggedObject, true);
                    continue block5;
                }
                case 1: {
                    this.b = AlgorithmIdentifier.getInstance(aSN1TaggedObject, true);
                    continue block5;
                }
                case 2: {
                    this.c = AlgorithmIdentifier.getInstance(aSN1TaggedObject, true);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("unknown tag");
                }
            }
        }
    }

    public AlgorithmIdentifier getHashAlgorithm() {
        return this.a;
    }

    public AlgorithmIdentifier getMaskGenAlgorithm() {
        return this.b;
    }

    public AlgorithmIdentifier getPSourceAlgorithm() {
        return this.c;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (!this.a.equals(DEFAULT_HASH_ALGORITHM)) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 0, this.a));
        }
        if (!this.b.equals(DEFAULT_MASK_GEN_FUNCTION)) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 1, this.b));
        }
        if (!this.c.equals(DEFAULT_P_SOURCE_ALGORITHM)) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 2, this.c));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

