/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.pqc.math.linearalgebra;

import com.aspose.cad.internal.bouncycastle.pqc.math.linearalgebra.GF2mField;
import com.aspose.cad.internal.bouncycastle.pqc.math.linearalgebra.IntUtils;
import com.aspose.cad.internal.bouncycastle.pqc.math.linearalgebra.Permutation;
import com.aspose.cad.internal.bouncycastle.pqc.math.linearalgebra.Vector;

public class GF2mVector
extends Vector {
    private GF2mField a;
    private int[] b;

    public GF2mVector(GF2mField gF2mField, byte[] byArray) {
        int n2;
        this.a = new GF2mField(gF2mField);
        int n3 = 1;
        for (n2 = 8; gF2mField.getDegree() > n2; n2 += 8) {
            ++n3;
        }
        if (byArray.length % n3 != 0) {
            throw new IllegalArgumentException("Byte array is not an encoded vector over the given finite field.");
        }
        this.length = byArray.length / n3;
        this.b = new int[this.length];
        n3 = 0;
        for (int i2 = 0; i2 < this.b.length; ++i2) {
            for (int i3 = 0; i3 < n2; i3 += 8) {
                int n4 = i2;
                this.b[n4] = this.b[n4] | (byArray[n3++] & 0xFF) << i3;
            }
            if (gF2mField.isElementOfThisField(this.b[i2])) continue;
            throw new IllegalArgumentException("Byte array is not an encoded vector over the given finite field.");
        }
    }

    public GF2mVector(GF2mField gF2mField, int[] nArray) {
        this.a = gF2mField;
        this.length = nArray.length;
        for (int i2 = nArray.length - 1; i2 >= 0; --i2) {
            if (gF2mField.isElementOfThisField(nArray[i2])) continue;
            throw new ArithmeticException("Element array is not specified over the given finite field.");
        }
        this.b = IntUtils.clone(nArray);
    }

    public GF2mVector(GF2mVector gF2mVector) {
        this.a = new GF2mField(gF2mVector.a);
        this.length = gF2mVector.length;
        this.b = IntUtils.clone(gF2mVector.b);
    }

    public GF2mField getField() {
        return this.a;
    }

    public int[] getIntArrayForm() {
        return IntUtils.clone(this.b);
    }

    @Override
    public byte[] getEncoded() {
        int n2;
        int n3 = 1;
        for (n2 = 8; this.a.getDegree() > n2; n2 += 8) {
            ++n3;
        }
        byte[] byArray = new byte[this.b.length * n3];
        n3 = 0;
        for (int i2 = 0; i2 < this.b.length; ++i2) {
            for (int i3 = 0; i3 < n2; i3 += 8) {
                byArray[n3++] = (byte)(this.b[i2] >>> i3);
            }
        }
        return byArray;
    }

    @Override
    public boolean isZero() {
        for (int i2 = this.b.length - 1; i2 >= 0; --i2) {
            if (this.b[i2] == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public Vector add(Vector vector) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public Vector multiply(Permutation permutation) {
        int[] nArray = permutation.getVector();
        if (this.length != nArray.length) {
            throw new ArithmeticException("permutation size and vector size mismatch");
        }
        int[] nArray2 = new int[this.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray2[i2] = this.b[nArray[i2]];
        }
        return new GF2mVector(this.a, nArray2);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof GF2mVector)) {
            return false;
        }
        GF2mVector gF2mVector = (GF2mVector)object;
        if (!this.a.equals(gF2mVector.a)) {
            return false;
        }
        return IntUtils.equals(this.b, gF2mVector.b);
    }

    @Override
    public int hashCode() {
        int n2 = this.a.hashCode();
        n2 = n2 * 31 + this.b.hashCode();
        return n2;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.b.length; ++i2) {
            for (int i3 = 0; i3 < this.a.getDegree(); ++i3) {
                int n2 = i3 & 0x1F;
                int n3 = 1 << n2;
                int n4 = this.b[i2] & n3;
                if (n4 != 0) {
                    stringBuffer.append('1');
                    continue;
                }
                stringBuffer.append('0');
            }
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }
}

