/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.pqc.crypto.mceliece;

import com.aspose.cad.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.cad.internal.bouncycastle.crypto.Digest;
import com.aspose.cad.internal.bouncycastle.pqc.math.linearalgebra.PolynomialRingGF2;

public class McElieceParameters
implements CipherParameters {
    public static final int DEFAULT_M = 11;
    public static final int DEFAULT_T = 50;
    private int a;
    private int b;
    private int c;
    private int d;
    private Digest e;

    public McElieceParameters() {
        this(11, 50);
    }

    public McElieceParameters(Digest digest) {
        this(11, 50, digest);
    }

    public McElieceParameters(int n2) {
        this(n2, null);
    }

    public McElieceParameters(int n2, Digest digest) {
        if (n2 < 1) {
            throw new IllegalArgumentException("key size must be positive");
        }
        this.a = 0;
        this.c = 1;
        while (this.c < n2) {
            this.c <<= 1;
            ++this.a;
        }
        this.b = this.c >>> 1;
        this.b /= this.a;
        this.d = PolynomialRingGF2.getIrreduciblePolynomial(this.a);
        this.e = digest;
    }

    public McElieceParameters(int n2, int n3) {
        this(n2, n3, null);
    }

    public McElieceParameters(int n2, int n3, Digest digest) {
        if (n2 < 1) {
            throw new IllegalArgumentException("m must be positive");
        }
        if (n2 > 32) {
            throw new IllegalArgumentException("m is too large");
        }
        this.a = n2;
        this.c = 1 << n2;
        if (n3 < 0) {
            throw new IllegalArgumentException("t must be positive");
        }
        if (n3 > this.c) {
            throw new IllegalArgumentException("t must be less than n = 2^m");
        }
        this.b = n3;
        this.d = PolynomialRingGF2.getIrreduciblePolynomial(n2);
        this.e = digest;
    }

    public McElieceParameters(int n2, int n3, int n4) {
        this(n2, n3, n4, null);
    }

    public McElieceParameters(int n2, int n3, int n4, Digest digest) {
        this.a = n2;
        if (n2 < 1) {
            throw new IllegalArgumentException("m must be positive");
        }
        if (n2 > 32) {
            throw new IllegalArgumentException(" m is too large");
        }
        this.c = 1 << n2;
        this.b = n3;
        if (n3 < 0) {
            throw new IllegalArgumentException("t must be positive");
        }
        if (n3 > this.c) {
            throw new IllegalArgumentException("t must be less than n = 2^m");
        }
        if (PolynomialRingGF2.degree(n4) != n2 || !PolynomialRingGF2.isIrreducible(n4)) {
            throw new IllegalArgumentException("polynomial is not a field polynomial for GF(2^m)");
        }
        this.d = n4;
        this.e = digest;
    }

    public int getM() {
        return this.a;
    }

    public int getN() {
        return this.c;
    }

    public int getT() {
        return this.b;
    }

    public int getFieldPoly() {
        return this.d;
    }
}

