/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.cert.ocsp;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1GeneralizedTime;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.cad.internal.bouncycastle.asn1.DERBitString;
import com.aspose.cad.internal.bouncycastle.asn1.DERGeneralizedTime;
import com.aspose.cad.internal.bouncycastle.asn1.DERNull;
import com.aspose.cad.internal.bouncycastle.asn1.DERSequence;
import com.aspose.cad.internal.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import com.aspose.cad.internal.bouncycastle.asn1.ocsp.CertStatus;
import com.aspose.cad.internal.bouncycastle.asn1.ocsp.ResponseData;
import com.aspose.cad.internal.bouncycastle.asn1.ocsp.RevokedInfo;
import com.aspose.cad.internal.bouncycastle.asn1.ocsp.SingleResponse;
import com.aspose.cad.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.cad.internal.bouncycastle.asn1.x509.CRLReason;
import com.aspose.cad.internal.bouncycastle.asn1.x509.Extensions;
import com.aspose.cad.internal.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.cad.internal.bouncycastle.cert.X509CertificateHolder;
import com.aspose.cad.internal.bouncycastle.cert.ocsp.BasicOCSPResp;
import com.aspose.cad.internal.bouncycastle.cert.ocsp.CertificateID;
import com.aspose.cad.internal.bouncycastle.cert.ocsp.CertificateStatus;
import com.aspose.cad.internal.bouncycastle.cert.ocsp.OCSPException;
import com.aspose.cad.internal.bouncycastle.cert.ocsp.RespID;
import com.aspose.cad.internal.bouncycastle.cert.ocsp.RevokedStatus;
import com.aspose.cad.internal.bouncycastle.cert.ocsp.UnknownStatus;
import com.aspose.cad.internal.bouncycastle.operator.ContentSigner;
import com.aspose.cad.internal.bouncycastle.operator.DigestCalculator;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class BasicOCSPRespBuilder {
    private List a = new ArrayList();
    private Extensions b = null;
    private RespID c;

    public BasicOCSPRespBuilder(RespID respID) {
        this.c = respID;
    }

    public BasicOCSPRespBuilder(SubjectPublicKeyInfo subjectPublicKeyInfo, DigestCalculator digestCalculator) throws OCSPException {
        this.c = new RespID(subjectPublicKeyInfo, digestCalculator);
    }

    public BasicOCSPRespBuilder addResponse(CertificateID certificateID, CertificateStatus certificateStatus) {
        this.addResponse(certificateID, certificateStatus, new Date(), null, null);
        return this;
    }

    public BasicOCSPRespBuilder addResponse(CertificateID certificateID, CertificateStatus certificateStatus, Extensions extensions) {
        this.addResponse(certificateID, certificateStatus, new Date(), null, extensions);
        return this;
    }

    public BasicOCSPRespBuilder addResponse(CertificateID certificateID, CertificateStatus certificateStatus, Date date, Extensions extensions) {
        this.addResponse(certificateID, certificateStatus, new Date(), date, extensions);
        return this;
    }

    public BasicOCSPRespBuilder addResponse(CertificateID certificateID, CertificateStatus certificateStatus, Date date, Date date2) {
        this.addResponse(certificateID, certificateStatus, date, date2, null);
        return this;
    }

    public BasicOCSPRespBuilder addResponse(CertificateID certificateID, CertificateStatus certificateStatus, Date date, Date date2, Extensions extensions) {
        this.a.add(new a(certificateID, certificateStatus, date, date2, extensions));
        return this;
    }

    public BasicOCSPRespBuilder setResponseExtensions(Extensions extensions) {
        this.b = extensions;
        return this;
    }

    public BasicOCSPResp build(ContentSigner contentSigner, X509CertificateHolder[] x509CertificateHolderArray, Date date) throws OCSPException {
        DERBitString dERBitString;
        Object object;
        Iterator iterator = this.a.iterator();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        while (iterator.hasNext()) {
            try {
                aSN1EncodableVector.add(((a)iterator.next()).a());
            }
            catch (Exception exception) {
                throw new OCSPException("exception creating Request", exception);
            }
        }
        ResponseData responseData = new ResponseData(this.c.toASN1Primitive(), new ASN1GeneralizedTime(date), (ASN1Sequence)new DERSequence(aSN1EncodableVector), this.b);
        try {
            object = contentSigner.getOutputStream();
            ((OutputStream)object).write(responseData.getEncoded("DER"));
            ((OutputStream)object).close();
            dERBitString = new DERBitString(contentSigner.getSignature());
        }
        catch (Exception exception) {
            throw new OCSPException("exception processing TBSRequest: " + exception.getMessage(), exception);
        }
        object = contentSigner.getAlgorithmIdentifier();
        DERSequence dERSequence = null;
        if (x509CertificateHolderArray != null && x509CertificateHolderArray.length > 0) {
            ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
            for (int i2 = 0; i2 != x509CertificateHolderArray.length; ++i2) {
                aSN1EncodableVector2.add(x509CertificateHolderArray[i2].toASN1Structure());
            }
            dERSequence = new DERSequence(aSN1EncodableVector2);
        }
        return new BasicOCSPResp(new BasicOCSPResponse(responseData, (AlgorithmIdentifier)object, dERBitString, dERSequence));
    }

    private class a {
        CertificateID a;
        CertStatus b;
        ASN1GeneralizedTime c;
        ASN1GeneralizedTime d;
        Extensions e;

        public a(CertificateID certificateID, CertificateStatus certificateStatus, Date date, Date date2, Extensions extensions) {
            RevokedStatus revokedStatus;
            this.a = certificateID;
            this.b = certificateStatus == null ? new CertStatus() : (certificateStatus instanceof UnknownStatus ? new CertStatus(2, DERNull.INSTANCE) : ((revokedStatus = (RevokedStatus)certificateStatus).hasRevocationReason() ? new CertStatus(new RevokedInfo(new ASN1GeneralizedTime(revokedStatus.getRevocationTime()), CRLReason.lookup(revokedStatus.getRevocationReason()))) : new CertStatus(new RevokedInfo(new ASN1GeneralizedTime(revokedStatus.getRevocationTime()), null))));
            this.c = new DERGeneralizedTime(date);
            this.d = date2 != null ? new DERGeneralizedTime(date2) : null;
            this.e = extensions;
        }

        public SingleResponse a() throws Exception {
            return new SingleResponse(this.a.toASN1Primitive(), this.b, this.c, this.d, this.e);
        }
    }
}

