/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.asn1.ocsp;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Enumerated;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1GeneralizedTime;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.cad.internal.bouncycastle.asn1.DERSequence;
import com.aspose.cad.internal.bouncycastle.asn1.DERTaggedObject;
import com.aspose.cad.internal.bouncycastle.asn1.x509.CRLReason;

public class RevokedInfo
extends ASN1Object {
    private ASN1GeneralizedTime a;
    private CRLReason b;

    public RevokedInfo(ASN1GeneralizedTime aSN1GeneralizedTime, CRLReason cRLReason) {
        this.a = aSN1GeneralizedTime;
        this.b = cRLReason;
    }

    private RevokedInfo(ASN1Sequence aSN1Sequence) {
        this.a = ASN1GeneralizedTime.getInstance(aSN1Sequence.getObjectAt(0));
        if (aSN1Sequence.size() > 1) {
            this.b = CRLReason.getInstance(ASN1Enumerated.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(1), true));
        }
    }

    public static RevokedInfo getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        return RevokedInfo.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl2));
    }

    public static RevokedInfo getInstance(Object object) {
        if (object instanceof RevokedInfo) {
            return (RevokedInfo)object;
        }
        if (object != null) {
            return new RevokedInfo(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public ASN1GeneralizedTime getRevocationTime() {
        return this.a;
    }

    public CRLReason getRevocationReason() {
        return this.b;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        if (this.b != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 0, this.b));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

