/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.pqc.crypto.xmss;

import com.aspose.cad.internal.bouncycastle.pqc.crypto.xmss.XMSSMTParameters;
import com.aspose.cad.internal.bouncycastle.pqc.crypto.xmss.XMSSReducedSignature;
import com.aspose.cad.internal.bouncycastle.pqc.crypto.xmss.XMSSStoreableObjectInterface;
import com.aspose.cad.internal.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import com.aspose.cad.internal.bouncycastle.pqc.crypto.xmss.n;
import java.util.ArrayList;
import java.util.List;

public final class XMSSMTSignature
implements XMSSStoreableObjectInterface {
    private final XMSSMTParameters a;
    private final long b;
    private final byte[] c;
    private final List<XMSSReducedSignature> d;

    private XMSSMTSignature(Builder builder) {
        this.a = builder.a;
        if (this.a == null) {
            throw new NullPointerException("params == null");
        }
        int n2 = this.a.getDigestSize();
        byte[] byArray = builder.e;
        if (byArray != null) {
            int n3;
            int n4;
            int n5;
            int n6 = this.a.getWOTSPlus().a().e();
            int n7 = (int)Math.ceil((double)this.a.getHeight() / 8.0);
            int n8 = n7 + (n5 = n2) + (n4 = (n3 = (this.a.getHeight() / this.a.getLayers() + n6) * n2) * this.a.getLayers());
            if (byArray.length != n8) {
                throw new IllegalArgumentException("signature has wrong size");
            }
            int n9 = 0;
            this.b = XMSSUtil.bytesToXBigEndian(byArray, n9, n7);
            if (!XMSSUtil.isIndexValid(this.a.getHeight(), this.b)) {
                throw new IllegalArgumentException("index out of bounds");
            }
            this.c = XMSSUtil.extractBytesAtOffset(byArray, n9 += n7, n5);
            n9 += n5;
            this.d = new ArrayList<XMSSReducedSignature>();
            while (n9 < byArray.length) {
                XMSSReducedSignature xMSSReducedSignature = new XMSSReducedSignature.Builder(this.a.getXMSSParameters()).withReducedSignature(XMSSUtil.extractBytesAtOffset(byArray, n9, n3)).build();
                this.d.add(xMSSReducedSignature);
                n9 += n3;
            }
        } else {
            this.b = builder.b;
            byte[] byArray2 = builder.c;
            if (byArray2 != null) {
                if (byArray2.length != n2) {
                    throw new IllegalArgumentException("size of random needs to be equal to size of digest");
                }
                this.c = byArray2;
            } else {
                this.c = new byte[n2];
            }
            List<Object> list = builder.d;
            this.d = list != null ? list : new ArrayList<XMSSReducedSignature>();
        }
    }

    @Override
    public byte[] toByteArray() {
        int n2 = this.a.getDigestSize();
        int n3 = this.a.getWOTSPlus().a().e();
        int n4 = (int)Math.ceil((double)this.a.getHeight() / 8.0);
        int n5 = n2;
        int n6 = (this.a.getHeight() / this.a.getLayers() + n3) * n2;
        int n7 = n6 * this.a.getLayers();
        int n8 = n4 + n5 + n7;
        byte[] byArray = new byte[n8];
        int n9 = 0;
        byte[] byArray2 = XMSSUtil.toBytesBigEndian(this.b, n4);
        XMSSUtil.copyBytesAtOffset(byArray, byArray2, n9);
        XMSSUtil.copyBytesAtOffset(byArray, this.c, n9 += n4);
        n9 += n5;
        for (XMSSReducedSignature xMSSReducedSignature : this.d) {
            byte[] byArray3 = xMSSReducedSignature.toByteArray();
            XMSSUtil.copyBytesAtOffset(byArray, byArray3, n9);
            n9 += n6;
        }
        return byArray;
    }

    public long getIndex() {
        return this.b;
    }

    public byte[] getRandom() {
        return XMSSUtil.cloneArray(this.c);
    }

    public List<XMSSReducedSignature> getReducedSignatures() {
        return this.d;
    }

    /* synthetic */ XMSSMTSignature(Builder builder, n n2) {
        this(builder);
    }

    public static class Builder {
        private final XMSSMTParameters a;
        private long b = 0L;
        private byte[] c = null;
        private List<XMSSReducedSignature> d = null;
        private byte[] e = null;

        public Builder(XMSSMTParameters xMSSMTParameters) {
            this.a = xMSSMTParameters;
        }

        public Builder withIndex(long l2) {
            this.b = l2;
            return this;
        }

        public Builder withRandom(byte[] byArray) {
            this.c = XMSSUtil.cloneArray(byArray);
            return this;
        }

        public Builder withReducedSignatures(List<XMSSReducedSignature> list) {
            this.d = list;
            return this;
        }

        public Builder withSignature(byte[] byArray) {
            this.e = byArray;
            return this;
        }

        public XMSSMTSignature build() {
            return new XMSSMTSignature(this, null);
        }
    }
}

