/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.jce.provider;

import com.aspose.cad.internal.bouncycastle.crypto.DataLengthException;
import com.aspose.cad.internal.bouncycastle.crypto.DerivationFunction;
import com.aspose.cad.internal.bouncycastle.crypto.DerivationParameters;
import com.aspose.cad.internal.bouncycastle.crypto.Digest;
import com.aspose.cad.internal.bouncycastle.crypto.OutputLengthException;
import com.aspose.cad.internal.bouncycastle.crypto.params.KDFParameters;

public class BrokenKDF2BytesGenerator
implements DerivationFunction {
    private Digest a;
    private byte[] b;
    private byte[] c;

    public BrokenKDF2BytesGenerator(Digest digest) {
        this.a = digest;
    }

    @Override
    public void init(DerivationParameters derivationParameters) {
        if (!(derivationParameters instanceof KDFParameters)) {
            throw new IllegalArgumentException("KDF parameters required for generator");
        }
        KDFParameters kDFParameters = (KDFParameters)derivationParameters;
        this.b = kDFParameters.getSharedSecret();
        this.c = kDFParameters.getIV();
    }

    public Digest getDigest() {
        return this.a;
    }

    @Override
    public int generateBytes(byte[] byArray, int n2, int n3) throws DataLengthException, IllegalArgumentException {
        if (byArray.length - n3 < n2) {
            throw new OutputLengthException("output buffer too small");
        }
        long l2 = (long)n3 * 8L;
        if (l2 > (long)this.a.getDigestSize() * 8L * 0x80000000L) {
            new IllegalArgumentException("Output length to large");
        }
        int n4 = (int)(l2 / (long)this.a.getDigestSize());
        byte[] byArray2 = null;
        byArray2 = new byte[this.a.getDigestSize()];
        for (int i2 = 1; i2 <= n4; ++i2) {
            this.a.update(this.b, 0, this.b.length);
            this.a.update((byte)(i2 & 0xFF));
            this.a.update((byte)(i2 >> 8 & 0xFF));
            this.a.update((byte)(i2 >> 16 & 0xFF));
            this.a.update((byte)(i2 >> 24 & 0xFF));
            this.a.update(this.c, 0, this.c.length);
            this.a.doFinal(byArray2, 0);
            if (n3 - n2 > byArray2.length) {
                System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
                n2 += byArray2.length;
                continue;
            }
            System.arraycopy(byArray2, 0, byArray, n2, n3 - n2);
        }
        this.a.reset();
        return n3;
    }
}

