/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.crypto.digests;

import com.aspose.cad.internal.bouncycastle.crypto.OutputLengthException;
import com.aspose.cad.internal.bouncycastle.crypto.engines.ThreefishEngine;
import com.aspose.cad.internal.bouncycastle.crypto.params.SkeinParameters;
import com.aspose.cad.internal.bouncycastle.util.Arrays;
import com.aspose.cad.internal.bouncycastle.util.Memoable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SkeinEngine
implements Memoable {
    public static final int SKEIN_256 = 256;
    public static final int SKEIN_512 = 512;
    public static final int SKEIN_1024 = 1024;
    private static final int a = 0;
    private static final int b = 4;
    private static final int c = 48;
    private static final int d = 63;
    private static final Hashtable e = new Hashtable();
    final ThreefishEngine threefish;
    private final int f;
    long[] chain;
    private long[] g;
    private byte[] h;
    private Parameter[] i;
    private Parameter[] j;
    private final b k;
    private final byte[] l = new byte[1];

    private static void a(int n2, int n3, long[] lArray) {
        e.put(SkeinEngine.a(n2 / 8, n3 / 8), lArray);
    }

    private static Integer a(int n2, int n3) {
        return new Integer(n3 << 16 | n2);
    }

    public SkeinEngine(int n2, int n3) {
        if (n3 % 8 != 0) {
            throw new IllegalArgumentException("Output size must be a multiple of 8 bits. :" + n3);
        }
        this.f = n3 / 8;
        this.threefish = new ThreefishEngine(n2);
        this.k = new b(this.threefish.getBlockSize());
    }

    public SkeinEngine(SkeinEngine skeinEngine) {
        this(skeinEngine.getBlockSize() * 8, skeinEngine.getOutputSize() * 8);
        this.a(skeinEngine);
    }

    private void a(SkeinEngine skeinEngine) {
        this.k.a(skeinEngine.k);
        this.chain = Arrays.clone(skeinEngine.chain, this.chain);
        this.g = Arrays.clone(skeinEngine.g, this.g);
        this.h = Arrays.clone(skeinEngine.h, this.h);
        this.i = SkeinEngine.a(skeinEngine.i, this.i);
        this.j = SkeinEngine.a(skeinEngine.j, this.j);
    }

    private static Parameter[] a(Parameter[] parameterArray, Parameter[] parameterArray2) {
        if (parameterArray == null) {
            return null;
        }
        if (parameterArray2 == null || parameterArray2.length != parameterArray.length) {
            parameterArray2 = new Parameter[parameterArray.length];
        }
        System.arraycopy(parameterArray, 0, parameterArray2, 0, parameterArray2.length);
        return parameterArray2;
    }

    @Override
    public Memoable copy() {
        return new SkeinEngine(this);
    }

    @Override
    public void reset(Memoable memoable) {
        SkeinEngine skeinEngine = (SkeinEngine)memoable;
        if (this.getBlockSize() != skeinEngine.getBlockSize() || this.f != skeinEngine.f) {
            throw new IllegalArgumentException("Incompatible parameters in provided SkeinEngine.");
        }
        this.a(skeinEngine);
    }

    public int getOutputSize() {
        return this.f;
    }

    public int getBlockSize() {
        return this.threefish.getBlockSize();
    }

    public void init(SkeinParameters skeinParameters) {
        this.chain = null;
        this.h = null;
        this.i = null;
        this.j = null;
        if (skeinParameters != null) {
            byte[] byArray = skeinParameters.getKey();
            if (byArray.length < 16) {
                throw new IllegalArgumentException("Skein key must be at least 128 bits.");
            }
            this.a(skeinParameters.getParameters());
        }
        this.a();
        this.a(48);
    }

    private void a(Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        Vector<Parameter> vector = new Vector<Parameter>();
        Vector<Parameter> vector2 = new Vector<Parameter>();
        while (enumeration.hasMoreElements()) {
            Integer n2 = (Integer)enumeration.nextElement();
            byte[] byArray = (byte[])hashtable.get(n2);
            if (n2 == 0) {
                this.h = byArray;
                continue;
            }
            if (n2 < 48) {
                vector.addElement(new Parameter(n2, byArray));
                continue;
            }
            vector2.addElement(new Parameter(n2, byArray));
        }
        this.i = new Parameter[vector.size()];
        vector.copyInto(this.i);
        SkeinEngine.a(this.i);
        this.j = new Parameter[vector2.size()];
        vector2.copyInto(this.j);
        SkeinEngine.a(this.j);
    }

    private static void a(Parameter[] parameterArray) {
        if (parameterArray == null) {
            return;
        }
        for (int i2 = 1; i2 < parameterArray.length; ++i2) {
            Parameter parameter = parameterArray[i2];
            for (int i3 = i2; i3 > 0 && parameter.getType() < parameterArray[i3 - 1].getType(); --i3) {
                parameterArray[i3] = parameterArray[i3 - 1];
            }
            parameterArray[i3] = parameter;
        }
    }

    private void a() {
        long[] lArray = (long[])e.get(SkeinEngine.a(this.getBlockSize(), this.getOutputSize()));
        if (this.h == null && lArray != null) {
            this.chain = Arrays.clone(lArray);
        } else {
            this.chain = new long[this.getBlockSize() / 8];
            if (this.h != null) {
                this.a(0, this.h);
            }
            this.a(4, new a(this.f * 8).a());
        }
        if (this.i != null) {
            for (int i2 = 0; i2 < this.i.length; ++i2) {
                Parameter parameter = this.i[i2];
                this.a(parameter.getType(), parameter.getValue());
            }
        }
        this.g = Arrays.clone(this.chain);
    }

    public void reset() {
        System.arraycopy(this.g, 0, this.chain, 0, this.chain.length);
        this.a(48);
    }

    private void a(int n2, byte[] byArray) {
        this.a(n2);
        this.k.a(byArray, 0, byArray.length, this.chain);
        this.b();
    }

    private void a(int n2) {
        this.k.a(n2);
    }

    private void b() {
        this.k.a(this.chain);
    }

    private void c() {
        if (this.k == null) {
            throw new IllegalArgumentException("Skein engine is not initialised.");
        }
    }

    public void update(byte by2) {
        this.l[0] = by2;
        this.update(this.l, 0, 1);
    }

    public void update(byte[] byArray, int n2, int n3) {
        this.c();
        this.k.a(byArray, n2, n3, this.chain);
    }

    public int doFinal(byte[] byArray, int n2) {
        int n3;
        this.c();
        if (byArray.length < n2 + this.f) {
            throw new OutputLengthException("Output buffer is too short to hold output");
        }
        this.b();
        if (this.j != null) {
            for (n3 = 0; n3 < this.j.length; ++n3) {
                Parameter parameter = this.j[n3];
                this.a(parameter.getType(), parameter.getValue());
            }
        }
        n3 = this.getBlockSize();
        int n4 = (this.f + n3 - 1) / n3;
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = Math.min(n3, this.f - i2 * n3);
            this.a(i2, byArray, n2 + i2 * n3, n5);
        }
        this.reset();
        return this.f;
    }

    private void a(long l2, byte[] byArray, int n2, int n3) {
        byte[] byArray2 = new byte[8];
        ThreefishEngine.wordToBytes(l2, byArray2, 0);
        long[] lArray = new long[this.chain.length];
        this.a(63);
        this.k.a(byArray2, 0, byArray2.length, lArray);
        this.k.a(lArray);
        int n4 = (n3 + 8 - 1) / 8;
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = Math.min(8, n3 - i2 * 8);
            if (n5 == 8) {
                ThreefishEngine.wordToBytes(lArray[i2], byArray, n2 + i2 * 8);
                continue;
            }
            ThreefishEngine.wordToBytes(lArray[i2], byArray2, 0);
            System.arraycopy(byArray2, 0, byArray, n2 + i2 * 8, n5);
        }
    }

    static {
        SkeinEngine.a(256, 128, new long[]{-2228972824489528736L, -8629553674646093540L, 1155188648486244218L, -3677226592081559102L});
        SkeinEngine.a(256, 160, new long[]{1450197650740764312L, 3081844928540042640L, -3136097061834271170L, 3301952811952417661L});
        SkeinEngine.a(256, 224, new long[]{-4176654842910610933L, -8688192972455077604L, -7364642305011795836L, 4056579644589979102L});
        SkeinEngine.a(256, 256, new long[]{-243853671043386295L, 3443677322885453875L, -5531612722399640561L, 7662005193972177513L});
        SkeinEngine.a(512, 128, new long[]{-6288014694233956526L, 2204638249859346602L, 3502419045458743507L, -4829063503441264548L, 983504137758028059L, 1880512238245786339L, -6715892782214108542L, 7602827311880509485L});
        SkeinEngine.a(512, 160, new long[]{2934123928682216849L, -4399710721982728305L, 1684584802963255058L, 5744138295201861711L, 2444857010922934358L, -2807833639722848072L, -5121587834665610502L, 118355523173251694L});
        SkeinEngine.a(512, 224, new long[]{-3688341020067007964L, -3772225436291745297L, -8300862168937575580L, 4146387520469897396L, 1106145742801415120L, 7455425944880474941L, -7351063101234211863L, -7048981346965512457L});
        SkeinEngine.a(512, 384, new long[]{-6631894876634615969L, -5692838220127733084L, -7099962856338682626L, -2911352911530754598L, 2000907093792408677L, 9140007292425499655L, 6093301768906360022L, 2769176472213098488L});
        SkeinEngine.a(512, 512, new long[]{5261240102383538638L, 978932832955457283L, -8083517948103779378L, -7339365279355032399L, 6752626034097301424L, -1531723821829733388L, -7417126464950782685L, -5901786942805128141L});
    }

    private static class a {
        private byte[] a = new byte[32];

        public a(long l2) {
            this.a[0] = 83;
            this.a[1] = 72;
            this.a[2] = 65;
            this.a[3] = 51;
            this.a[4] = 1;
            this.a[5] = 0;
            ThreefishEngine.wordToBytes(l2, this.a, 8);
        }

        public byte[] a() {
            return this.a;
        }
    }

    public static class Parameter {
        private int a;
        private byte[] b;

        public Parameter(int n2, byte[] byArray) {
            this.a = n2;
            this.b = byArray;
        }

        public int getType() {
            return this.a;
        }

        public byte[] getValue() {
            return this.b;
        }
    }

    private class b {
        private final c b = new c();
        private byte[] c;
        private int d;
        private long[] e;

        public b(int n2) {
            this.c = new byte[n2];
            this.e = new long[this.c.length / 8];
        }

        public void a(b b2) {
            this.c = Arrays.clone(b2.c, this.c);
            this.d = b2.d;
            this.e = Arrays.clone(b2.e, this.e);
            this.b.a(b2.b);
        }

        public void a(int n2) {
            this.b.a();
            this.b.a(n2);
            this.d = 0;
        }

        public void a(byte[] byArray, int n2, int n3, long[] lArray) {
            int n4 = 0;
            while (n3 > n4) {
                if (this.d == this.c.length) {
                    this.b(lArray);
                    this.b.a(false);
                    this.d = 0;
                }
                int n5 = Math.min(n3 - n4, this.c.length - this.d);
                System.arraycopy(byArray, n2 + n4, this.c, this.d, n5);
                n4 += n5;
                this.d += n5;
                this.b.b(n5);
            }
        }

        private void b(long[] lArray) {
            int n2;
            SkeinEngine.this.threefish.init(true, SkeinEngine.this.chain, this.b.e());
            for (n2 = 0; n2 < this.e.length; ++n2) {
                this.e[n2] = ThreefishEngine.bytesToWord(this.c, n2 * 8);
            }
            SkeinEngine.this.threefish.processBlock(this.e, lArray);
            for (n2 = 0; n2 < lArray.length; ++n2) {
                int n3 = n2;
                lArray[n3] = lArray[n3] ^ this.e[n2];
            }
        }

        public void a(long[] lArray) {
            for (int i2 = this.d; i2 < this.c.length; ++i2) {
                this.c[i2] = 0;
            }
            this.b.b(true);
            this.b(lArray);
        }
    }

    private static class c {
        private static final long a = 9223372034707292160L;
        private static final long b = Long.MIN_VALUE;
        private static final long c = 0x4000000000000000L;
        private long[] d = new long[2];
        private boolean e;

        public c() {
            this.a();
        }

        public void a(c c2) {
            this.d = Arrays.clone(c2.d, this.d);
            this.e = c2.e;
        }

        public void a() {
            this.d[0] = 0L;
            this.d[1] = 0L;
            this.e = false;
            this.a(true);
        }

        public void a(int n2) {
            this.d[1] = this.d[1] & 0xFFFFFFC000000000L | ((long)n2 & 0x3FL) << 56;
        }

        public int b() {
            return (int)(this.d[1] >>> 56 & 0x3FL);
        }

        public void a(boolean bl2) {
            this.d[1] = bl2 ? this.d[1] | 0x4000000000000000L : this.d[1] & 0xBFFFFFFFFFFFFFFFL;
        }

        public boolean c() {
            return (this.d[1] & 0x4000000000000000L) != 0L;
        }

        public void b(boolean bl2) {
            this.d[1] = bl2 ? this.d[1] | Long.MIN_VALUE : this.d[1] & Long.MAX_VALUE;
        }

        public boolean d() {
            return (this.d[1] & Long.MIN_VALUE) != 0L;
        }

        public void b(int n2) {
            if (this.e) {
                long[] lArray = new long[]{this.d[0] & 0xFFFFFFFFL, this.d[0] >>> 32 & 0xFFFFFFFFL, this.d[1] & 0xFFFFFFFFL};
                long l2 = n2;
                for (int i2 = 0; i2 < lArray.length; ++i2) {
                    lArray[i2] = l2 += lArray[i2];
                    l2 >>>= 32;
                }
                this.d[0] = (lArray[1] & 0xFFFFFFFFL) << 32 | lArray[0] & 0xFFFFFFFFL;
                this.d[1] = this.d[1] & 0xFFFFFFFF00000000L | lArray[2] & 0xFFFFFFFFL;
            } else {
                long l3 = this.d[0];
                this.d[0] = l3 += (long)n2;
                if (l3 > 9223372034707292160L) {
                    this.e = true;
                }
            }
        }

        public long[] e() {
            return this.d;
        }

        public String toString() {
            return this.b() + " first: " + this.c() + ", final: " + this.d();
        }
    }
}

