/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.asn1.ocsp;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.cad.internal.bouncycastle.asn1.DERBitString;
import com.aspose.cad.internal.bouncycastle.asn1.DERSequence;
import com.aspose.cad.internal.bouncycastle.asn1.DERTaggedObject;
import com.aspose.cad.internal.bouncycastle.asn1.ocsp.ResponseData;
import com.aspose.cad.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class BasicOCSPResponse
extends ASN1Object {
    private ResponseData a;
    private AlgorithmIdentifier b;
    private DERBitString c;
    private ASN1Sequence d;

    public BasicOCSPResponse(ResponseData responseData, AlgorithmIdentifier algorithmIdentifier, DERBitString dERBitString, ASN1Sequence aSN1Sequence) {
        this.a = responseData;
        this.b = algorithmIdentifier;
        this.c = dERBitString;
        this.d = aSN1Sequence;
    }

    private BasicOCSPResponse(ASN1Sequence aSN1Sequence) {
        this.a = ResponseData.getInstance(aSN1Sequence.getObjectAt(0));
        this.b = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(1));
        this.c = (DERBitString)aSN1Sequence.getObjectAt(2);
        if (aSN1Sequence.size() > 3) {
            this.d = ASN1Sequence.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(3), true);
        }
    }

    public static BasicOCSPResponse getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        return BasicOCSPResponse.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl2));
    }

    public static BasicOCSPResponse getInstance(Object object) {
        if (object instanceof BasicOCSPResponse) {
            return (BasicOCSPResponse)object;
        }
        if (object != null) {
            return new BasicOCSPResponse(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public ResponseData getTbsResponseData() {
        return this.a;
    }

    public AlgorithmIdentifier getSignatureAlgorithm() {
        return this.b;
    }

    public DERBitString getSignature() {
        return this.c;
    }

    public ASN1Sequence getCerts() {
        return this.d;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.c);
        if (this.d != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 0, this.d));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

