/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.asn1.cmc;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.cad.internal.bouncycastle.asn1.DERSequence;
import com.aspose.cad.internal.bouncycastle.asn1.cmc.OtherMsg;
import com.aspose.cad.internal.bouncycastle.asn1.cmc.TaggedAttribute;
import com.aspose.cad.internal.bouncycastle.asn1.cmc.TaggedContentInfo;
import com.aspose.cad.internal.bouncycastle.asn1.cmc.TaggedRequest;

public class PKIData
extends ASN1Object {
    private final TaggedAttribute[] a;
    private final TaggedRequest[] b;
    private final TaggedContentInfo[] c;
    private final OtherMsg[] d;

    public PKIData(TaggedAttribute[] taggedAttributeArray, TaggedRequest[] taggedRequestArray, TaggedContentInfo[] taggedContentInfoArray, OtherMsg[] otherMsgArray) {
        this.a = taggedAttributeArray;
        this.b = taggedRequestArray;
        this.c = taggedContentInfoArray;
        this.d = otherMsgArray;
    }

    private PKIData(ASN1Sequence aSN1Sequence) {
        int n2;
        if (aSN1Sequence.size() != 4) {
            throw new IllegalArgumentException("Sequence not 4 elements.");
        }
        ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1Sequence.getObjectAt(0);
        this.a = new TaggedAttribute[aSN1Sequence2.size()];
        for (n2 = 0; n2 < this.a.length; ++n2) {
            this.a[n2] = TaggedAttribute.getInstance(aSN1Sequence2.getObjectAt(n2));
        }
        aSN1Sequence2 = (ASN1Sequence)aSN1Sequence.getObjectAt(1);
        this.b = new TaggedRequest[aSN1Sequence2.size()];
        for (n2 = 0; n2 < this.b.length; ++n2) {
            this.b[n2] = TaggedRequest.getInstance(aSN1Sequence2.getObjectAt(n2));
        }
        aSN1Sequence2 = (ASN1Sequence)aSN1Sequence.getObjectAt(2);
        this.c = new TaggedContentInfo[aSN1Sequence2.size()];
        for (n2 = 0; n2 < this.c.length; ++n2) {
            this.c[n2] = TaggedContentInfo.getInstance(aSN1Sequence2.getObjectAt(n2));
        }
        aSN1Sequence2 = (ASN1Sequence)aSN1Sequence.getObjectAt(3);
        this.d = new OtherMsg[aSN1Sequence2.size()];
        for (n2 = 0; n2 < this.d.length; ++n2) {
            this.d[n2] = OtherMsg.getInstance(aSN1Sequence2.getObjectAt(n2));
        }
    }

    public static PKIData getInstance(Object object) {
        if (object instanceof PKIData) {
            return (PKIData)object;
        }
        if (object != null) {
            return new PKIData(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return new DERSequence(new ASN1Encodable[]{new DERSequence(this.a), new DERSequence(this.b), new DERSequence(this.c), new DERSequence(this.d)});
    }

    public TaggedAttribute[] getControlSequence() {
        return this.a;
    }

    public TaggedRequest[] getReqSequence() {
        return this.b;
    }

    public TaggedContentInfo[] getCmsSequence() {
        return this.c;
    }

    public OtherMsg[] getOtherMsgSequence() {
        return this.d;
    }
}

