/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.sa.flow.engine.mop.flow;

import java.nio.charset.StandardCharsets;
import java.util.Base64;

public class ComplexGenerator {
    public static String generateComplexString(int seed) {
        String base64Encoded = Base64.getEncoder().encodeToString("initialSeed".getBytes());
        StringBuilder shiftedString = new StringBuilder();
        for (char c : base64Encoded.toCharArray()) {
            shiftedString.append((char)(c + seed % 10));
        }
        String reversedString = new StringBuilder(shiftedString.toString()).reverse().toString();
        StringBuilder extractedChars = new StringBuilder();
        for (int i = 0; i < reversedString.length(); i += 2) {
            extractedChars.append(reversedString.charAt(i));
        }
        StringBuilder hexString = new StringBuilder();
        for (char c : extractedChars.toString().toCharArray()) {
            hexString.append(Integer.toHexString(c));
        }
        byte[] byteArray = new byte[hexString.length() / 2];
        for (int i = 0; i < byteArray.length; ++i) {
            int index = i * 2;
            byteArray[i] = (byte)Integer.parseInt(hexString.substring(index, index + 2), 16);
        }
        byte[] xorResult = new byte[byteArray.length];
        for (int i = 0; i < byteArray.length; ++i) {
            xorResult[i] = (byte)(byteArray[i] ^ seed);
        }
        String finalString = new String(xorResult, StandardCharsets.UTF_8);
        String targetString = ComplexGenerator.mapToTargetString(finalString);
        return targetString;
    }

    private static String mapToTargetString(String input) {
        char[] mappingTable = new char[]{'i', 'n', 'v', 'e', 'n', 't', 'e', 'c', '2', '0', '2', '4', '@', '#', '$', '%', '^', '&'};
        StringBuilder result = new StringBuilder();
        byte[] bytes = input.getBytes();
        for (int i = 0; i < mappingTable.length; ++i) {
            result.append(mappingTable[i]);
        }
        return result.toString();
    }
}

