/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.sa.flow.engine.engine.utils;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.cloud.sa.flow.commom.common.system.StUserInfo;
import com.cloud.sa.flow.commom.domain.entity.StLogs;
import com.cloud.sa.flow.commom.domain.entity.StTaskitem;
import com.cloud.sa.flow.commom.domain.mapper.StLogsMapper;
import com.cloud.sa.flow.commom.domain.virentity.StUser;
import com.cloud.sa.flow.commom.service.StOrganizeService;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LogsUtils {
    @Autowired
    StLogsMapper logsMapper;
    @Autowired
    StOrganizeService organizeService;

    public void addLogs(String instanceId, StTaskitem taskitem, String type) {
        StLogs logs = new StLogs();
        logs.setCreateTime(LocalDateTime.now());
        logs.setType(type);
        logs.setUserCode(StUserInfo.getUserCode());
        logs.setIp(StUserInfo.getUserIp());
        logs.setPlatform(StUserInfo.getUserOs());
        if (taskitem != null) {
            logs.setInstanceId(taskitem.getInstanceid());
            logs.setTaskId(taskitem.getObjectid());
            logs.setTaskName(taskitem.getActivityName());
        } else if (instanceId != null) {
            logs.setInstanceId(instanceId);
        }
        this.logsMapper.insert((Object)logs);
    }

    public List<StLogs> getUserLogs(String instanceId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(StLogs::getInstanceId, (Object)instanceId);
        wrapper.orderByAsc(StLogs::getCreateTime);
        List stLogs = this.logsMapper.selectList((Wrapper)wrapper);
        stLogs.forEach(log -> {
            StUser user = this.organizeService.GetUserByCode(log.getUserCode());
            log.setUserName(String.join((CharSequence)"", user.getUserName(), "(", user.getUserDept(), ")"));
        });
        return stLogs;
    }
}

