/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.sa.flow.engine.engine.utils;

import com.alibaba.fastjson.JSONObject;
import com.cloud.sa.flow.commom.common.redis.StRedisCache;
import com.cloud.sa.flow.commom.common.system.StUserInfo;
import com.cloud.sa.flow.commom.common.utils.StConvert;
import com.cloud.sa.flow.commom.common.utils.StString;
import com.cloud.sa.flow.commom.domain.common.RedisKeys;
import com.cloud.sa.flow.commom.domain.entity.StAddParticipant;
import com.cloud.sa.flow.commom.domain.entity.StFlowMenu;
import com.cloud.sa.flow.commom.domain.entity.StInstance;
import com.cloud.sa.flow.commom.domain.entity.StInstanceBase;
import com.cloud.sa.flow.commom.domain.entity.setting.StSequence;
import com.cloud.sa.flow.commom.domain.virentity.ActivityNode;
import com.cloud.sa.flow.commom.domain.virentity.FlowEnteredParam;
import com.cloud.sa.flow.commom.domain.virentity.StDept;
import com.cloud.sa.flow.commom.domain.virentity.StInstanceEvent;
import com.cloud.sa.flow.commom.domain.virentity.StPost;
import com.cloud.sa.flow.commom.domain.virentity.StUser;
import com.cloud.sa.flow.commom.service.StOrganizeService;
import com.cloud.sa.flow.commom.service.genSql.SqlGeneratorService;
import com.cloud.sa.flow.commom.service.setting.StSettingService;
import com.cloud.sa.flow.engine.engine.coreface.CoreBpmFlowAnalysisInterface;
import com.cloud.sa.flow.engine.mop.flow.NodeLogic;
import com.cloud.sa.flow.engine.service.form.StFormService;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class EngineUtils {
    @Autowired
    private StRedisCache rd;
    @Autowired
    StFormService formService;
    @Autowired
    StOrganizeService organizeService;
    @Autowired
    StSettingService settingService;
    @Autowired
    SqlGeneratorService sqlGenerator;
    private final ConcurrentHashMap<String, Object> locks = new ConcurrentHashMap();
    @Autowired
    private ApplicationContext context;
    @Autowired
    private CoreBpmFlowAnalysisInterface coreBpmFlowAnalysisInterface;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String GetSequenceNo(String flowCode, StFlowMenu flowMenu) {
        Object lock;
        StSequence globalSequenceSetting = this.settingService.getGlobalSequenceSetting();
        Object object = lock = this.locks.computeIfAbsent(flowCode, k -> new Object());
        synchronized (object) {
            Integer curSequenceCode = this.settingService.getCurSequenceCode(flowCode);
            if (curSequenceCode == null) {
                curSequenceCode = globalSequenceSetting.getCodeBegin();
                this.settingService.getSqlValue(this.sqlGenerator.getIstSequenceSql(flowCode, StConvert.toStr((Object)(curSequenceCode + 1))));
            } else {
                this.settingService.getSqlValue(this.sqlGenerator.getIncrementalSequenceSql(flowCode));
            }
            LocalDate currentDate = LocalDate.now();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(globalSequenceSetting.getDataFormat());
            String formattedDate = currentDate.format(formatter);
            String incrementalCode = "00000000000000000000000" + StConvert.toStr((Object)curSequenceCode);
            String sequenceNo = formattedDate + incrementalCode.substring(incrementalCode.length() - globalSequenceSetting.getCodeLength());
            if (!StString.isEmpty((String)flowMenu.getFlowNamePrefix())) {
                sequenceNo = flowMenu.getFlowNamePrefix() + sequenceNo;
            }
            return sequenceNo;
        }
    }

    public String GetSequenceName(StInstance instance, StFlowMenu flowMenu, FlowEnteredParam flowEnteredParam) {
        String flowFormName = "";
        if (StString.isEmpty((String)flowMenu.getFlowNameSetting())) {
            flowFormName = flowMenu.getFlowName() + "-" + instance.getSequenceNo() + "-" + StUserInfo.getUserName();
        } else {
            try {
                flowFormName = flowMenu.getFlowNameSetting();
                flowFormName = flowFormName.replace("[SySSequence]", instance.getSequenceNo()).replace("[SySOriginator]", StUserInfo.getUserName());
                ArrayList<String> fields = new ArrayList<String>();
                String[] split = flowFormName.split("\\{");
                if (split.length > 1) {
                    for (String s : split) {
                        String[] split1 = s.split("\\}");
                        if (split1.length <= 0) continue;
                        fields.add(split1[0]);
                    }
                }
                for (String field : fields) {
                    StUser stUser;
                    JSONObject formTableData = null;
                    formTableData = flowEnteredParam == null ? this.formService.getMainFormTableData(instance.getFlowCode(), instance.getBizObjectid()) : JSONObject.parseObject((String)flowEnteredParam.getTableData());
                    String content = formTableData.getString(field);
                    if (StString.isEmpty((String)content)) continue;
                    if (content.startsWith("post_")) {
                        StPost stPost = this.organizeService.GetPostByCode(content);
                        if (stPost != null) {
                            content = stPost.getPostName();
                        }
                    } else if (content.startsWith("dept_")) {
                        StDept stDept = this.organizeService.GetDeptByCode(content);
                        if (stDept != null) {
                            content = stDept.getDeptName();
                        }
                    } else if (!content.startsWith("group_") && (stUser = this.organizeService.GetUserByCode(content)) != null) {
                        content = stUser.getUserName();
                    }
                    flowFormName = flowFormName.replace("{" + field + "}", content);
                }
            }
            catch (Exception e) {
                flowFormName = flowMenu.getFlowName() + "-" + instance.getSequenceNo() + "-" + StUserInfo.getUserName();
                this.settingService.FlowCommonExceptionRecord(e, instance.getObjectid(), "\u6d41\u7a0b\u540d\u79f0\u8d4b\u503c");
            }
        }
        flowFormName = flowFormName.replaceAll("\\{.*?\\}", "");
        flowFormName = flowFormName.replaceAll("--", "-");
        flowFormName = flowFormName.replaceAll("--", "-");
        flowFormName = flowFormName.replaceAll("--", "-");
        flowFormName = flowFormName.replaceAll("--", "-");
        flowFormName = flowFormName.replaceAll("--", "-");
        if (flowFormName.startsWith("-")) {
            flowFormName = flowFormName.substring(1);
        }
        return flowFormName;
    }

    public List<String> anaPStr(StInstance instance, List<String> participantsListString) {
        String[] participantsList;
        List<String> participants = new ArrayList<String>();
        if (participantsListString == null || participantsListString.size() == 0) {
            return participants;
        }
        String participantsStr = participantsListString.get(0);
        for (String p : participantsList = StString.split((String)participantsStr, (String)";")) {
            if ((p = p.replaceAll("\\s+", "")).startsWith("IF(") && p.length() > 3) {
                String[] split = p.substring(3, p.length() - 1).split(",");
                if (split.length != 3) continue;
                ArrayList<String> a = new ArrayList<String>();
                if (this.checkLineCondition((StInstanceBase)instance, split[0]).booleanValue()) {
                    a.add(split[1].replace("|", ";"));
                } else {
                    a.add(split[2].replace("|", ";"));
                }
                participants.addAll(this.anaPStr(instance, a));
                continue;
            }
            try {
                this.organizationalStaff(p, instance, participants);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        participants = participants.stream().distinct().collect(Collectors.toList());
        return participants;
    }

    public List<String> anaP(StInstance instance, ActivityNode activityNode) {
        List participantsListString = activityNode.getParticipants();
        List<String> participants = this.anaPStr(instance, participantsListString);
        List<StAddParticipant> appendParticipants = this.formService.getAddParticipantByInstanceIdAndTaskCode(instance.getObjectid(), activityNode.getCode());
        for (StAddParticipant appendParticipant : appendParticipants) {
            participants.add(appendParticipant.getUserCode());
        }
        return participants;
    }

    private void dealFormField(String p, StInstance instance, List<String> participants, Function<String, StUser> getUserFunction) {
        String userField = NodeLogic.extractBrace(p);
        if (!StString.isEmpty((String)userField)) {
            JSONObject formTableData = this.formService.getMainFormTableData(instance.getFlowCode(), instance.getBizObjectid());
            String userCode = formTableData.getString(userField);
            ArrayList<String> users = new ArrayList<String>();
            if (userCode.startsWith("[") && userCode.contains("]") && userCode.contains("\"")) {
                String[] split;
                userCode = userCode.replace("[", "").replace("]", "").replace("\"", "");
                for (String s : split = userCode.split(",")) {
                    users.add(s);
                }
            } else {
                users.add(userCode);
            }
            for (String user : users) {
                StUser u = getUserFunction.apply(user);
                if (u == null) continue;
                participants.add(u.getUserCode());
            }
        }
    }

    private void deal$Org(String p, StInstance instance, List<String> participants, Function<String, StUser> getUserFunction) {
        StUser userDeptManager = null;
        if ("[SySOriginator]".equals(p)) {
            userDeptManager = getUserFunction.apply(instance.getOriginator());
        } else if ("[SySOriginatorManager]".equals(p)) {
            userDeptManager = this.organizeService.getDeptManagerByUserCode(instance.getOriginator());
            if (userDeptManager != null) {
                userDeptManager = getUserFunction.apply(userDeptManager.getUserCode());
            }
        } else {
            if (p.startsWith("[")) {
                p = NodeLogic.extractSquareBrace(p);
            }
            userDeptManager = getUserFunction.apply(p);
        }
        if (userDeptManager != null) {
            participants.add(userDeptManager.getUserCode());
        }
    }

    private String get$Content(String str1, String str2) {
        return str2.substring(str1.length() + 1, str2.length() - 1);
    }

    private String get$Method(String str1) {
        return str1.replace("$GetByMethod", "").replace(" ", "").replace("'", "").replace("\"", "").replace("(", "").replace(")", "");
    }

    private void dealMethod(String fillMethodName, StInstance instance, List<String> participants) {
        int lastDot = fillMethodName.lastIndexOf(46);
        String className = fillMethodName.substring(0, lastDot);
        String methodName = fillMethodName.substring(lastDot + 1);
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
            Object[] names = this.context.getBeanDefinitionNames();
            System.out.println(Arrays.toString(names));
            Object bean = this.context.getBean(clazz);
            Method method = clazz.getMethod(methodName, StInstanceEvent.class);
            List result = (List)method.invoke(bean, this.coreBpmFlowAnalysisInterface.eventParamClass(instance));
            participants.addAll(result);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private void organizationalStaff(String p, StInstance instance, List<String> participants) {
        if (p.startsWith("$")) {
            if (p.startsWith("$GetByMethod")) {
                p = this.get$Method(p);
                this.dealMethod(p, instance, participants);
            } else if (p.startsWith("$UserDeptManager")) {
                if ((p = this.get$Content("$UserDeptManager", p)).startsWith("[")) {
                    this.deal$Org(p, instance, participants, arg_0 -> ((StOrganizeService)this.organizeService).getDeptManagerByUserCode(arg_0));
                } else if (p.startsWith("{")) {
                    this.dealFormField(p, instance, participants, arg_0 -> ((StOrganizeService)this.organizeService).getDeptManagerByUserCode(arg_0));
                }
            } else if (p.startsWith("$DeptManager")) {
                if ((p = this.get$Content("$DeptManager", p)).startsWith("[")) {
                    this.deal$Org(p, instance, participants, arg_0 -> ((StOrganizeService)this.organizeService).getDeptManagerByDeptCode(arg_0));
                } else if (p.startsWith("{")) {
                    this.dealFormField(p, instance, participants, arg_0 -> ((StOrganizeService)this.organizeService).getDeptManagerByDeptCode(arg_0));
                }
            } else if (p.startsWith("$GetPostByCode")) {
                p = this.get$Content("$GetPostByCode", p);
                int splitIndex = p.indexOf(",");
                String org = p.substring(0, splitIndex);
                String postName = p.substring(splitIndex + 1).replace("\"", "").replace("'", "");
                if (org.contains("[SySOriginator]")) {
                    org = instance.getOriginator();
                } else if (org.contains("[SySOriginatorManager]")) {
                    StUser userDeptManager = this.organizeService.getDeptManagerByUserCode(instance.getOriginator());
                    if (userDeptManager != null) {
                        org = userDeptManager.getUserCode();
                    }
                } else if (org.contains("[")) {
                    org = NodeLogic.extractSquareBrace(org);
                } else if (org.contains("{")) {
                    JSONObject formTableData = this.formService.getMainFormTableData(instance.getFlowCode(), instance.getBizObjectid());
                    org = formTableData.getString(NodeLogic.extractBrace(org));
                }
                if (org.startsWith("dept_")) {
                    StDept deptByDeptCode = this.organizeService.getDeptByDeptCode(org);
                    if (deptByDeptCode != null) {
                        this.findNearestPosition(deptByDeptCode.getParentIds() + "/" + deptByDeptCode.getDeptId(), postName, participants);
                    }
                } else {
                    StUser stUser = this.organizeService.GetUserByCode(org);
                    if (stUser != null) {
                        this.findNearestPosition(stUser.getParentIds() + "/" + stUser.getDeptId(), postName, participants);
                    }
                }
            }
        } else if (p.startsWith("{")) {
            this.dealFormField(p, instance, participants, arg_0 -> ((StOrganizeService)this.organizeService).GetUserByCode(arg_0));
        } else if (p.startsWith("[")) {
            if ("[SySOriginator]".equals(p)) {
                participants.add(instance.getOriginator());
            } else if ("[SySOriginatorManager]".equals(p)) {
                StUser userDeptManager = this.organizeService.getDeptManagerByUserCode(instance.getOriginator());
                if (userDeptManager != null) {
                    participants.add(userDeptManager.getUserCode());
                }
            } else {
                String organizeParam = NodeLogic.extractSquareBrace(p);
                this.dealParticipantUserAndPostAndDept(organizeParam, participants);
            }
        }
    }

    public void findNearestPosition(String deptIds, String postName, List<String> participants) {
        List allPost = this.organizeService.getAllPost();
        String[] split = deptIds.split("/");
        List<String> itemList = Arrays.asList(split);
        Collections.reverse(itemList);
        for (String item : itemList) {
            StPost post = allPost.stream().filter(f -> f.getPostDept().equals(item) && f.getPostName().startsWith(postName)).findFirst().orElse(null);
            if (post == null) continue;
            List usersByPost = this.organizeService.getUsersByPost(post.getPostCode());
            participants.addAll(usersByPost);
            break;
        }
    }

    public void dealParticipantUserAndPostAndDept(String organizeParam, List<String> participants) {
        if (!StString.isEmpty((String)organizeParam)) {
            StUser stUser;
            if (organizeParam.startsWith("post_")) {
                List usersByPost = this.organizeService.getUsersByPost(organizeParam);
                if (usersByPost != null && usersByPost.size() > 0) {
                    participants.addAll(usersByPost);
                }
            } else if (organizeParam.startsWith("dept_")) {
                List usersByDep = this.organizeService.getUsersByDep(organizeParam);
                if (usersByDep != null && usersByDep.size() > 0) {
                    participants.addAll(usersByDep);
                }
            } else if (!organizeParam.startsWith("group_") && (stUser = this.organizeService.GetUserByCode(organizeParam)) != null) {
                participants.add(organizeParam);
            }
        }
    }

    public Boolean checkLineCondition(StInstanceBase instance, String condition) {
        condition = condition.replaceAll("\\s+", "");
        this.formService.IstFormDataCache(instance.getFlowCode(), instance.getBizObjectid());
        String formDataKey = RedisKeys.getMainFormData((String)instance.getBizObjectid(), (String[])new String[0]);
        Map<String, Object> fieldMap = NodeLogic.extractVariableNames(condition);
        for (Map.Entry<String, Object> entry : fieldMap.entrySet()) {
            Object value = this.rd.getCacheMapValue(formDataKey, entry.getKey());
            condition = condition.replace("{" + entry.getKey() + "}", "'" + StString.toString((Object)value) + "'");
        }
        return NodeLogic.evaluateExpression(condition);
    }

    public String getParticipantName(String participantsStr) {
        String[] participantsList = StString.split((String)participantsStr, (String)";");
        ArrayList<String> participants = new ArrayList<String>();
        for (String p : participantsList) {
            try {
                p = p.replaceAll("\\s+", "");
                if (p.startsWith("IF(") && p.length() > 3) {
                    String[] split = p.substring(3, p.length() - 1).split(",");
                    if (split.length == 3) {
                        String[] split2;
                        String[] split1;
                        String ifStr = "IF(" + split[0] + ",";
                        ArrayList<String> a1 = new ArrayList<String>();
                        for (String q : split1 = split[1].split("\\|")) {
                            String s = this.singleParticipantName(q);
                            if (s == null) continue;
                            a1.add(s);
                        }
                        ifStr = ifStr + String.join((CharSequence)"|", a1) + ",";
                        ArrayList<String> a2 = new ArrayList<String>();
                        for (String q : split2 = split[2].split("\\|")) {
                            String s = this.singleParticipantName(q);
                            if (s == null) continue;
                            a2.add(s);
                        }
                        ifStr = ifStr + String.join((CharSequence)"|", a2) + ")";
                        participants.add(ifStr);
                        continue;
                    }
                    participants.add("IF(???)");
                    continue;
                }
                if (p.startsWith("$UserDeptManager")) {
                    String s = this.singleParticipantName(p = this.get$Content("$UserDeptManager", p));
                    if (s == null) continue;
                    participants.add("$UserDeptManager(" + s + ")");
                    continue;
                }
                if (p.startsWith("$DeptManager")) {
                    String s = this.singleParticipantName(p = this.get$Content("$DeptManager", p));
                    if (s == null) continue;
                    participants.add("$UserDeptManager(" + s + ")");
                    continue;
                }
                if (p.startsWith("$GetPostByCode")) {
                    p = this.get$Content("$GetPostByCode", p);
                    int splitIndex = p.indexOf(",");
                    String org = p.substring(0, splitIndex);
                    String postName = p.substring(splitIndex + 1);
                    String s = this.singleParticipantName(org);
                    if (s == null) continue;
                    participants.add("$GetPostByCode(" + s + "," + postName + ")");
                    continue;
                }
                String s = this.singleParticipantName(p);
                if (s == null) continue;
                participants.add(s);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
        return String.join((CharSequence)";", participants);
    }

    private String singleParticipantName(String p) {
        if (p.contains("{")) {
            return p;
        }
        if (p.contains("[")) {
            if ("[SySOriginator]".equals(p)) {
                return "[\u53d1\u8d77\u4eba]";
            }
            if ("[SySOriginatorManager]".equals(p)) {
                return "[\u53d1\u8d77\u4eba\u90e8\u95e8\u8d1f\u8d23\u4eba]";
            }
            String organizeParam = NodeLogic.extractSquareBrace(p);
            if (!StString.isEmpty((String)organizeParam)) {
                StUser stUser;
                if (organizeParam.startsWith("post_")) {
                    StPost stPost = this.organizeService.GetPostByCode(organizeParam);
                    if (stPost != null) {
                        return "[" + stPost.getPostName() + "]";
                    }
                } else if (organizeParam.startsWith("dept_")) {
                    StDept stDept = this.organizeService.GetDeptByCode(organizeParam);
                    if (stDept != null) {
                        return "[" + stDept.getDeptName() + "]";
                    }
                } else if (!organizeParam.startsWith("group_") && (stUser = this.organizeService.GetUserByCode(organizeParam)) != null) {
                    return "[" + stUser.getUserName() + "]";
                }
            }
        } else {
            return p;
        }
        return null;
    }

    public String getUUName(String str) {
        String[] participantsList = StString.split((String)str, (String)";");
        ArrayList<String> participants = new ArrayList<String>();
        for (String p : participantsList) {
            try {
                p = p.replaceAll("\\s+", "");
                if (p.startsWith("IF(") && p.length() > 3) {
                    String[] split = p.substring(3, p.length() - 1).split(",");
                    if (split.length == 3) {
                        String[] split2;
                        String[] split1;
                        String ifStr = "IF(" + split[0] + ",";
                        ArrayList<String> a1 = new ArrayList<String>();
                        for (String q : split1 = split[1].split("\\|")) {
                            String s = this.singleParticipantName(q);
                            if (s == null) continue;
                            a1.add(s);
                        }
                        ifStr = ifStr + String.join((CharSequence)"|", a1) + ",";
                        ArrayList<String> a2 = new ArrayList<String>();
                        for (String q : split2 = split[2].split("\\|")) {
                            String s = this.singleParticipantName(q);
                            if (s == null) continue;
                            a2.add(s);
                        }
                        ifStr = ifStr + String.join((CharSequence)"|", a2) + ")";
                        participants.add(ifStr);
                        continue;
                    }
                    participants.add("IF(???)");
                    continue;
                }
                if (p.startsWith("$UserDeptManager")) {
                    String s = this.singleParticipantName(p = this.get$Content("$UserDeptManager", p));
                    if (s == null) continue;
                    participants.add("$UserDeptManager(" + s + ")");
                    continue;
                }
                if (p.startsWith("$DeptManager")) {
                    String s = this.singleParticipantName(p = this.get$Content("$DeptManager", p));
                    if (s == null) continue;
                    participants.add("$UserDeptManager(" + s + ")");
                    continue;
                }
                if (p.startsWith("$GetPostByCode")) {
                    p = this.get$Content("$GetPostByCode", p);
                    int splitIndex = p.indexOf(",");
                    String org = p.substring(0, splitIndex);
                    String postName = p.substring(splitIndex + 1);
                    String s = this.singleParticipantName(org);
                    if (s == null) continue;
                    participants.add("$GetPostByCode(" + s + "," + postName + ")");
                    continue;
                }
                String s = this.singleParticipantName(p);
                if (s == null) continue;
                participants.add(s);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
        return String.join((CharSequence)";", participants);
    }
}

