/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.sa.flow.engine.engine.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.cloud.sa.flow.commom.common.redis.StRedisCache;
import com.cloud.sa.flow.commom.common.system.StUserInfo;
import com.cloud.sa.flow.commom.common.utils.StConvert;
import com.cloud.sa.flow.commom.common.utils.StString;
import com.cloud.sa.flow.commom.domain.common.RedisKeys;
import com.cloud.sa.flow.commom.domain.entity.StTaskitem;
import com.cloud.sa.flow.commom.domain.virentity.ActivityNode;
import com.cloud.sa.flow.commom.domain.virentity.DataPower;
import com.cloud.sa.flow.commom.domain.virentity.FlowEnteredParam;
import com.cloud.sa.flow.commom.domain.virentity.FormLoadTemplate;
import com.cloud.sa.flow.commom.domain.virenum.NodeType;
import com.cloud.sa.flow.commom.domain.virenum.TaskitemState;
import com.cloud.sa.flow.commom.service.flow.StTaskItemService;
import com.cloud.sa.flow.engine.service.form.StFormService;
import com.cloud.sa.flow.engine.subs.Exceptions.SubmitCheckException;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CheckUtils {
    @Autowired
    StTaskItemService taskItemService;
    @Autowired
    StFormService formService;
    @Autowired
    StRedisCache rd;

    public String IsCanSubmit(FlowEnteredParam flowEnteredParam, StTaskitem taskitem) {
        String errorMsg = "";
        if (taskitem == null) {
            throw new SubmitCheckException("\u672a\u83b7\u53d6\u5230\u5f53\u524d\u4efb\u52a1\u3002");
        }
        if (!StUserInfo.getUserCode().equals(taskitem.getParticipant())) {
            // empty if block
        }
        if (!(taskitem.getItemType().equals(NodeType.AUDIT.getCode()) || taskitem.getItemType().equals(NodeType.WRITE.getCode()) || taskitem.getItemType().equals(NodeType.CIRCULATE.getCode()))) {
            errorMsg = errorMsg + "\u53ea\u6709\u586b\u5199\u548c\u5ba1\u6838\u8282\u70b9\u9700\u8981\u63d0\u4ea4\uff0c\u5f53\u524d\u8282\u70b9\u4e3a\uff1a" + NodeType.values()[Integer.parseInt(taskitem.getItemType())];
        }
        if (!taskitem.getState().equals(TaskitemState.CREATE.getCode()) && !taskitem.getState().equals(TaskitemState.VIEWED.getCode())) {
            errorMsg = errorMsg + "\u4efb\u52a1\u5df2\u63d0\u4ea4\u8fc7\uff0c\u5f53\u524d\u4efb\u52a1\u72b6\u6001\u4e3a\uff1a" + taskitem.getState();
        }
        if (!StString.isEmpty((String)errorMsg)) {
            throw new SubmitCheckException(errorMsg);
        }
        if (flowEnteredParam.getIsBatches().booleanValue() && (NodeType.AUDIT.getCode().equals(taskitem.getItemType()) || NodeType.WRITE.getCode().equals(taskitem.getItemType()))) {
            if ("Task2".equals(taskitem.getActivityCode())) {
                return "\u586b\u5199\u8282\u70b9\u65e0\u6cd5\u6279\u91cf\u540c\u610f\uff0c\u8bf7\u6253\u5f00\u8868\u5355\u63d0\u4ea4\u3002";
            }
            FormLoadTemplate formLoadTemplate = this.taskItemService.getFormLoadTemplate(taskitem.getObjectid());
            ActivityNode activityNode = (ActivityNode)this.rd.getCacheMapValue(RedisKeys.getTempNodeEntity((String)formLoadTemplate.getFlowCode(), (Integer)formLoadTemplate.getFlowVersion(), (String[])new String[0]), formLoadTemplate.getNodeId());
            List dataPowerData = activityNode.getDataPowerData();
            JSONObject allFormTableData = this.formService.getAllFormTableData(taskitem.getFlowCode(), taskitem.getBizObjectid(), taskitem.getObjectid());
            for (DataPower dataPowerDatum : dataPowerData) {
                if (dataPowerDatum.getRequire().booleanValue() && dataPowerDatum.getChildren() == null && (!allFormTableData.containsKey((Object)dataPowerDatum.getFieldCode()) || StString.isEmpty((String)StConvert.toStr((Object)allFormTableData.get((Object)dataPowerDatum.getFieldCode()))))) {
                    return "\u8868\u5355\u4e2d\u6709\u5fc5\u586b\u9879\uff0c\u65e0\u6cd5\u6279\u91cf\u5ba1\u6279\u3002";
                }
                if (dataPowerDatum.getChildren() == null || !dataPowerDatum.getRequire().booleanValue()) continue;
                if (!allFormTableData.containsKey((Object)dataPowerDatum.getFieldCode()) || allFormTableData.getJSONArray(dataPowerDatum.getFieldCode()).size() == 0) {
                    return "\u8868\u5355\u4e2d\u6709\u5fc5\u586b\u9879\uff0c\u65e0\u6cd5\u6279\u91cf\u5ba1\u6279\u3002";
                }
                JSONArray childDatas = allFormTableData.getJSONArray(dataPowerDatum.getFieldCode());
                List children = dataPowerDatum.getChildren();
                for (DataPower child : children) {
                    if (!child.getRequire().booleanValue()) continue;
                    for (Object childDatum : childDatas) {
                        Map childData = (Map)childDatum;
                        if (childData.containsKey(child.getFieldCode()) && !StString.isEmpty((String)StConvert.toStr(childData.get(child.getFieldCode())))) continue;
                        return "\u8868\u5355\u4e2d\u6709\u5fc5\u586b\u9879\uff0c\u65e0\u6cd5\u6279\u91cf\u5ba1\u6279\u3002";
                    }
                }
            }
        }
        return errorMsg;
    }

    public String IsCanReject(StTaskitem ti) {
        String errorMsg = "";
        if (!StUserInfo.getUserCode().equals(ti.getParticipant())) {
            errorMsg = errorMsg + "\u5ba1\u6279\u4eba\u4e0e\u53c2\u4e0e\u8005\u4e0d\u4e00\u81f4\uff01";
        }
        if (!ti.getItemType().equals(NodeType.AUDIT.getCode()) && !ti.getItemType().equals(NodeType.WRITE.getCode())) {
            errorMsg = errorMsg + "\u53ea\u6709\u586b\u5199\u548c\u5ba1\u6838\u8282\u70b9\u9700\u8981\u63d0\u4ea4\uff0c\u5f53\u524d\u8282\u70b9\u4e3a\uff1a" + NodeType.values()[Integer.parseInt(ti.getItemType())];
        }
        return errorMsg;
    }
}

