/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.sa.flow.engine.engine.action;

import com.cloud.sa.flow.commom.aspect.CacheProgram;
import com.cloud.sa.flow.commom.common.utils.StSpringUtils;
import com.cloud.sa.flow.commom.domain.virenum.ActionType;
import com.cloud.sa.flow.engine.core.ActionStrategyDeal;
import com.cloud.sa.flow.engine.core.IActionStrategy;
import com.cloud.sa.flow.engine.service.StFlowService;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class CacheProgramAspect {
    protected Logger logger = LoggerFactory.getLogger(CacheProgramAspect.class);
    @Autowired
    StFlowService service;

    @Pointcut(value="@annotation(com.cloud.sa.flow.commom.aspect.CacheProgram)|| @within(com.cloud.sa.flow.commom.aspect.CacheProgram)")
    public void dsPointCut() {
    }

    @Before(value="dsPointCut()")
    public void logBefore(JoinPoint proJoinPoint) throws Throwable {
        Object[] args = proJoinPoint.getArgs();
        CacheProgram executionTimeMsg = this.getExecutionTimeMsg(proJoinPoint);
        ActionStrategyDeal actionStrategy = (ActionStrategyDeal)StSpringUtils.getBean(ActionStrategyDeal.class);
        Map<ActionType, IActionStrategy> actionStrategyMap = actionStrategy.getActionStrategyMap();
        actionStrategyMap.get(executionTimeMsg.action()).applyBefore(args);
    }

    @After(value="dsPointCut()")
    public void logAfter(JoinPoint proJoinPoint) throws Throwable {
        Object[] args = proJoinPoint.getArgs();
        CacheProgram executionTimeMsg = this.getExecutionTimeMsg(proJoinPoint);
        ActionStrategyDeal actionStrategy = (ActionStrategyDeal)StSpringUtils.getBean(ActionStrategyDeal.class);
        Map<ActionType, IActionStrategy> actionStrategyMap = actionStrategy.getActionStrategyMap();
        actionStrategyMap.get(executionTimeMsg.action()).applyAfter(args);
    }

    @AfterThrowing(throwing="ex", pointcut="dsPointCut()")
    public void afterThrowingFun(JoinPoint point, Throwable ex) {
        Object[] args = point.getArgs();
        CacheProgram executionTimeMsg = this.getExecutionTimeMsg(point);
        ActionStrategyDeal actionStrategy = (ActionStrategyDeal)StSpringUtils.getBean(ActionStrategyDeal.class);
        Map<ActionType, IActionStrategy> actionStrategyMap = actionStrategy.getActionStrategyMap();
        actionStrategyMap.get(executionTimeMsg.action()).applyThrowing(args);
    }

    public CacheProgram getExecutionTimeMsg(JoinPoint point) {
        MethodSignature signature = (MethodSignature)point.getSignature();
        CacheProgram executionTime = (CacheProgram)AnnotationUtils.findAnnotation((Method)signature.getMethod(), CacheProgram.class);
        if (Objects.nonNull(executionTime)) {
            return executionTime;
        }
        return (CacheProgram)AnnotationUtils.findAnnotation((Class)signature.getDeclaringType(), CacheProgram.class);
    }
}

