/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.sa.flow.engine.engine.action;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.cloud.sa.flow.commom.common.redis.StRedisCache;
import com.cloud.sa.flow.commom.common.utils.StSpringUtils;
import com.cloud.sa.flow.commom.common.utils.StString;
import com.cloud.sa.flow.commom.domain.common.RedisKeys;
import com.cloud.sa.flow.commom.domain.entity.StInstanceBase;
import com.cloud.sa.flow.commom.domain.entity.StStep;
import com.cloud.sa.flow.commom.domain.virentity.ActivityLine;
import com.cloud.sa.flow.commom.domain.virentity.ActivityNode;
import com.cloud.sa.flow.commom.domain.virenum.InstanceState;
import com.cloud.sa.flow.commom.domain.virenum.NodeType;
import com.cloud.sa.flow.engine.core.IActionStrategy;
import com.cloud.sa.flow.engine.core.INodeStrategy;
import com.cloud.sa.flow.engine.core.NodeStrategyDeal;
import com.cloud.sa.flow.engine.mop.flow.NodeLogic;
import com.cloud.sa.flow.engine.service.StFlowService;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public abstract class ActionStrategy
implements IActionStrategy {
    @Autowired
    StRedisCache rd;
    @Autowired
    StFlowService service;

    @Override
    public abstract void applyBefore(Object[] var1);

    @Override
    public abstract void applyAfter(Object[] var1);

    @Override
    public abstract void applyThrowing(Object[] var1);

    public void initTemplateFlow(StInstanceBase instance) {
        Integer flowVersion;
        String flowCode = instance.getFlowCode();
        if (!(this.rd.hasKey(RedisKeys.getFlowTempContent((String)flowCode, (Integer)(flowVersion = instance.getFlowVersion()), (String[])new String[]{"initTemplateFlow:if"})) && this.rd.hasKey(RedisKeys.getTempLineEntity((String)flowCode, (Integer)flowVersion, (String[])new String[]{"initTemplateFlow:if"})) && this.rd.hasKey(RedisKeys.getTempNodeEntity((String)flowCode, (Integer)flowVersion, (String[])new String[]{"initTemplateFlow:if"})) && this.rd.hasKey(RedisKeys.getTempBeginNodeEntity((String)flowCode, (Integer)flowVersion, (String[])new String[]{"initTemplateFlow:if"})))) {
            this.rd.deleteObject(RedisKeys.getTempNodeEntity((String)flowCode, (Integer)flowVersion, (String[])new String[0]));
            String jsonStr = this.service.getStFlowTemplate(flowCode, flowVersion).getContent();
            JSONObject jo = JSON.parseObject((String)jsonStr);
            this.rd.set(RedisKeys.getFlowTempContent((String)flowCode, (Integer)flowVersion, (String[])new String[]{"initTemplateFlow:set"}), (Object)jo);
            JSONArray cells = jo.getJSONArray("cells");
            this.ParseFlowTemplateAndPrefabricateIntoCache(cells, flowCode, flowVersion);
        }
    }

    public void ParseFlowTemplateAndPrefabricateIntoCache(JSONArray cells, String flowCode, Integer flowVersion) {
        for (int i = 0; i < cells.size(); ++i) {
            JSONObject oneJo = (JSONObject)cells.get(i);
            String id = NodeLogic.getID(oneJo);
            if (!"1".equals(System.getProperty("initData"))) continue;
            String nodeType = NodeLogic.getNT(oneJo);
            if (nodeType.equals(NodeType.LINE.getCode())) {
                ActivityLine al = new ActivityLine(flowCode, id, nodeType, NodeLogic.getData(oneJo), NodeLogic.getCS(oneJo), NodeLogic.getCT(oneJo));
                this.rd.setCacheMapValue(RedisKeys.getTempLineEntity((String)flowCode, (Integer)flowVersion, (String[])new String[0]), id, (Object)al);
                continue;
            }
            ActivityNode an = new ActivityNode(flowCode, id, nodeType, NodeLogic.getData(oneJo), NodeLogic.getTXT(oneJo));
            this.rd.setCacheMapValue(RedisKeys.getTempNodeEntity((String)flowCode, (Integer)flowVersion, (String[])new String[0]), id, (Object)an);
            if (!nodeType.equals(NodeType.BEGIN.getCode())) continue;
            this.rd.set(RedisKeys.getTempBeginNodeEntity((String)flowCode, (Integer)flowVersion, (String[])new String[0]), (Object)id);
        }
    }

    public void initInstanceCacheData(StInstanceBase stInstance) {
        String instanceId = stInstance.getObjectid();
        this.removeInstanceCacheData(instanceId);
        List<StStep> stSteps = this.service.getStepByInstanceid(instanceId);
        for (StStep step : stSteps) {
            if (!"1".equals(System.getProperty("initData"))) continue;
            this.rd.setCacheMapValue(RedisKeys.getInstanceStepMap((String)instanceId, (String[])new String[0]), step.getNodeid(), (Object)step);
        }
        if (InstanceState.CANCEL.getCode().equals(stInstance.getState()) || InstanceState.FINISHED.getCode().equals(stInstance.getState())) {
            return;
        }
        StStep stepLast = stSteps.stream().max(Comparator.comparing(StStep::getStepid)).get();
        this.futureMaybeInThis(stepLast.getNodeid(), stInstance, stepLast.getStepid());
    }

    public void removeInstanceCacheData(String instanceId) {
        this.rd.deleteObject(RedisKeys.getEstStep((String)instanceId, (String[])new String[0]));
        this.rd.deleteObject(RedisKeys.getEstParticipants((String)instanceId, (String[])new String[0]));
        this.rd.deleteObject(RedisKeys.getInstanceStepMap((String)instanceId, (String[])new String[0]));
        this.rd.deleteObject(RedisKeys.getCurStepId((String)instanceId, (String[])new String[0]));
    }

    public void futureMaybeInThis(String nodeId, StInstanceBase instance, Integer estStep) {
        if (estStep > 180) {
            System.out.println("futureMaybeInThis\u53ef\u80fd\u51fa\u73b0\u6b7b\u5faa\u73af");
            return;
        }
        ActivityNode curNode = (ActivityNode)this.rd.getCacheMapValue(RedisKeys.getTempNodeEntity((String)instance.getFlowCode(), (Integer)instance.getFlowVersion(), (String[])new String[]{"\u6a21\u62df", "curNode"}), nodeId);
        if (curNode == null) {
            throw new RuntimeException("\u6d41\u7a0b\u7248\u672c\u3010" + instance.getFlowVersion() + "\u3011\u4e0d\u5b58\u5728nodeId\uff1a" + nodeId);
        }
        List targets = curNode.getCellTargets();
        Map<String, INodeStrategy> strategyMap = ((NodeStrategyDeal)StSpringUtils.getBean(NodeStrategyDeal.class)).getStrategyMap();
        for (String lineId : targets) {
            ActivityLine al = (ActivityLine)this.rd.getCacheMapValue(RedisKeys.getTempLineEntity((String)instance.getFlowCode(), (Integer)instance.getFlowVersion(), (String[])new String[]{"\u6a21\u62df", "al"}), lineId);
            if (!StString.isEmpty((String)al.getCondition()) && !this.service.getEngineTools().checkLineCondition(instance, al.getCondition()).booleanValue()) continue;
            Integer n = estStep;
            Integer n2 = estStep = Integer.valueOf(estStep + 1);
            String targetNodeId = al.getTargetId();
            ActivityNode an = (ActivityNode)this.rd.getCacheMapValue(RedisKeys.getTempNodeEntity((String)instance.getFlowCode(), (Integer)instance.getFlowVersion(), (String[])new String[]{"\u6a21\u62df", "an"}), targetNodeId);
            INodeStrategy strategy = strategyMap.get(an.getNodeType());
            if (strategy == null) continue;
            strategy.cache(an, instance, estStep);
        }
    }
}

