/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.sa.flow.engine.engine;

import cn.dev33.satoken.stp.StpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.cloud.sa.flow.commom.aspect.CacheProgram;
import com.cloud.sa.flow.commom.common.Request.StHttpRequest;
import com.cloud.sa.flow.commom.common.redis.StRedisCache;
import com.cloud.sa.flow.commom.common.system.StUserInfo;
import com.cloud.sa.flow.commom.common.utils.StSpringUtils;
import com.cloud.sa.flow.commom.common.utils.StString;
import com.cloud.sa.flow.commom.domain.common.RedisKeys;
import com.cloud.sa.flow.commom.domain.entity.StInstance;
import com.cloud.sa.flow.commom.domain.entity.StInstanceBase;
import com.cloud.sa.flow.commom.domain.entity.StStep;
import com.cloud.sa.flow.commom.domain.entity.StTaskitem;
import com.cloud.sa.flow.commom.domain.virentity.ActivityLine;
import com.cloud.sa.flow.commom.domain.virentity.ActivityNode;
import com.cloud.sa.flow.commom.domain.virentity.StInstanceEvent;
import com.cloud.sa.flow.commom.domain.virenum.ActionType;
import com.cloud.sa.flow.commom.domain.virenum.NodeType;
import com.cloud.sa.flow.commom.domain.virenum.StepApproval;
import com.cloud.sa.flow.commom.domain.virenum.StepState;
import com.cloud.sa.flow.commom.domain.virenum.TaskitemState;
import com.cloud.sa.flow.commom.service.StOrganizeService;
import com.cloud.sa.flow.commom.service.flow.StStepService;
import com.cloud.sa.flow.commom.service.flow.StTaskItemService;
import com.cloud.sa.flow.commom.service.setting.StSettingService;
import com.cloud.sa.flow.engine.core.INodeStrategy;
import com.cloud.sa.flow.engine.core.NodeStrategyDeal;
import com.cloud.sa.flow.engine.core.StExceptionUtil;
import com.cloud.sa.flow.engine.core.builders.StStepBuilder;
import com.cloud.sa.flow.engine.core.builders.StTaskitemBuilder;
import com.cloud.sa.flow.engine.engine.coreface.CoreBpmFlowAnalysisInterface;
import com.cloud.sa.flow.engine.engine.utils.EngineUtils;
import com.cloud.sa.flow.engine.mop.flow.NodeLogic;
import com.cloud.sa.flow.engine.service.StFlowService;
import com.cloud.sa.flow.engine.service.form.StFormService;
import com.cloud.sa.flow.engine.subs.CacheDeal;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CoreBpmFlowAnalysis
implements CoreBpmFlowAnalysisInterface {
    private static final Logger log = LoggerFactory.getLogger(CoreBpmFlowAnalysis.class);
    @Autowired
    CacheDeal cacheDeal;
    @Autowired
    StFlowService flowService;
    @Autowired
    StOrganizeService organizeService;
    @Autowired
    EngineUtils engineUtils;
    @Autowired
    StTaskItemService taskItemService;
    @Autowired
    StStepService stepService;
    @Autowired
    private StRedisCache rd;
    @Autowired
    StSettingService settingService;
    @Autowired
    StFormService formService;

    @Override
    public String InitWriteNode(StInstance instance, Integer lastStepId, String originator) {
        String flowCode = instance.getFlowCode();
        Integer flowVersion = instance.getFlowVersion();
        String instanceId = instance.getObjectid();
        String bizObjectId = instance.getBizObjectid();
        String userId = StUserInfo.getUserCode();
        String beginNodeId = this.cacheDeal.getTempBeginNodeEntity(flowCode, flowVersion);
        ActivityNode beginNode = this.cacheDeal.getTempNodeEntity(flowCode, flowVersion, beginNodeId);
        String taskid = "";
        List targets = beginNode.getCellTargets();
        for (String lineId : targets) {
            ActivityLine al = this.cacheDeal.getTempLineEntity(flowCode, flowVersion, lineId);
            if (!StString.isEmpty((String)al.getCondition()) && !this.engineUtils.checkLineCondition((StInstanceBase)instance, al.getCondition()).booleanValue()) continue;
            String targetNodeId = al.getTargetId();
            ActivityNode activityNode = this.cacheDeal.getTempNodeEntity(flowCode, flowVersion, targetNodeId);
            taskid = StString.getUUID();
            StTaskitem taskItem = StTaskitemBuilder.newBuilder().withObjectid(taskid).withFlowCode(flowCode).withFlowVersion(flowVersion).withActivityCode(activityNode.getCode()).withActivityName(activityNode.getName()).withInstanceid(instanceId).withBizObjectid(bizObjectId).withStepid(lastStepId + 1).withItemType(activityNode.getNodeType()).build();
            if (lastStepId.equals(0)) {
                taskItem.setState(TaskitemState.VIEWED.getCode());
                taskItem.setParticipant(userId);
            } else {
                taskItem.setState(TaskitemState.CREATE.getCode());
                taskItem.setParticipant(originator);
                taskItem.setOriginator(originator);
            }
            this.flowService.istStTaskitem(taskItem);
            StStep step = StStepBuilder.newBuilder().withStepId(lastStepId + 1).withNodeId(activityNode.getId()).withInstanceId(instanceId).withBizObjectId(bizObjectId).withActivityCode(activityNode.getCode()).withActivityName(activityNode.getName()).build();
            this.flowService.istStStep(step);
        }
        return taskid;
    }

    @Override
    @CacheProgram(action=ActionType.VIEW_FLOW)
    public JSONObject SimulateFlowTemplate(String instanceid) {
        StInstance stInstance = this.flowService.getStInstance(instanceid);
        JSONObject jo = this.cacheDeal.getFlowTempContent(stInstance.getFlowCode(), stInstance.getFlowVersion());
        JSONArray cells = jo.getJSONArray("cells");
        NodeStrategyDeal nodeStrategyDeal = (NodeStrategyDeal)StSpringUtils.getBean(NodeStrategyDeal.class);
        Map<String, INodeStrategy> strategyMap = nodeStrategyDeal.getStrategyMap();
        for (int i = 0; i < cells.size(); ++i) {
            JSONObject oneJo = (JSONObject)cells.get(i);
            String nodeId = oneJo.getString("id");
            JSONObject joData = oneJo.getJSONObject("data");
            String nodeType = NodeLogic.getNT(oneJo);
            StStep step = this.cacheDeal.getInstanceStepMap(instanceid, nodeId);
            INodeStrategy strategy = strategyMap.get(nodeType);
            if (strategy == null) continue;
            strategy.cacheColor(joData, step, stInstance, nodeId);
        }
        return jo;
    }

    @Override
    public void analyzeThePathAndStartTheSteps(String nodeId, StInstance instance) {
        Integer flowVersion = instance.getFlowVersion();
        ActivityNode cureNode = this.cacheDeal.getTempNodeEntity(instance.getFlowCode(), flowVersion, nodeId);
        String rejectNodeId = this.submitTurnToReject(cureNode, instance);
        if (!"".equals(rejectNodeId)) {
            this.toTheNextStop(instance, flowVersion, rejectNodeId);
        } else {
            List targets = cureNode.getCellTargets();
            for (String lineId : targets) {
                ActivityLine al = this.cacheDeal.getTempLineEntity(cureNode.getFlowCode(), flowVersion, lineId);
                if (!StString.isEmpty((String)al.getCondition()) && !this.engineUtils.checkLineCondition((StInstanceBase)instance, al.getCondition()).booleanValue()) continue;
                String targetNodeId = al.getTargetId();
                this.toTheNextStop(instance, flowVersion, targetNodeId);
            }
        }
    }

    private void toTheNextStop(StInstance instance, Integer flowVersion, String targetNodeId) {
        AtomicInteger stepState = new AtomicInteger(StepState.LEAVE.getCode());
        ActivityNode activityNode = this.cacheDeal.getTempNodeEntity(instance.getFlowCode(), flowVersion, targetNodeId);
        List<String> participants = this.engineUtils.anaP(instance, activityNode);
        this.InstanceProcessFlow(activityNode, instance, participants, this.getMaxStepId(instance.getObjectid(), true), stepState, false);
    }

    public String submitTurnToReject(ActivityNode cureNode, StInstance instance) {
        if (!"Task2".equals(cureNode.getCode())) {
            return "";
        }
        if (instance.getCurStepid().equals(1)) {
            return "";
        }
        Map lastOperation = this.taskItemService.getLastOperation(instance.getObjectid());
        if (lastOperation == null) {
            return "";
        }
        if (lastOperation.get("nodeid") == null || lastOperation.get("state") == null) {
            return "";
        }
        if (!lastOperation.get("state").equals(3)) {
            return "";
        }
        String nodeId = lastOperation.get("nodeid").toString();
        ActivityNode activityNode = this.cacheDeal.getTempNodeEntity(instance.getFlowCode(), instance.getFlowVersion(), nodeId);
        if (activityNode == null) {
            return "";
        }
        if (activityNode.getOperatePower() == null) {
            return "";
        }
        if (!activityNode.getOperatePower().isSubmitToReject()) {
            return "";
        }
        return nodeId;
    }

    @Override
    public void adjustStepCurrent(ActivityNode activityNode, StInstance instance, List<String> participants) {
        AtomicInteger stepState = new AtomicInteger(StepState.LEAVE.getCode());
        this.InstanceProcessFlow(activityNode, instance, participants, this.getMaxStepId(instance.getObjectid(), true), stepState, true);
        this.flowService.updateStInstance(instance);
    }

    private void InstanceProcessFlow(ActivityNode activityNode, StInstance instance, List<String> participants, Integer stepIdNum, AtomicInteger stepState, boolean adjust) {
        INodeStrategy nodeStrategy = ((NodeStrategyDeal)StSpringUtils.getBean(NodeStrategyDeal.class)).getStrategyMap().get(activityNode.getNodeType());
        nodeStrategy.cacheStep(participants, instance, activityNode, stepIdNum, stepState, adjust);
        NodeLogic.logicDeal(nodeStrategy, participants, instance, activityNode, stepIdNum, stepState, adjust);
        this.insertTheStepsInTheProcedure(stepIdNum, activityNode, instance, stepState);
    }

    @Override
    public void insertTheStepsInTheProcedure(Integer stepIdNum, ActivityNode activityNode, StInstance instance, AtomicInteger stepState) {
        StStep step = StStepBuilder.newBuilder().withStepId(stepIdNum).withNodeId(activityNode.getId()).withInstanceId(instance.getObjectid()).withBizObjectId(instance.getBizObjectid()).withState(stepState.get()).withApproval(StepApproval.PASS.getCode()).withActivityCode(activityNode.getCode()).withActivityName(activityNode.getName()).build();
        if (instance.getCurStepid() == null || instance.getCurStepid() < stepIdNum) {
            instance.setCurStepid(stepIdNum);
        }
        this.flowService.istStStep(step);
    }

    @Override
    public void overTargetTask(String instanceId, boolean finish) {
        HashSet stepIds = new HashSet();
        List taskItemByInstanceId = this.taskItemService.getTaskItemByInstanceId(instanceId);
        taskItemByInstanceId.stream().forEach(taskitem -> {
            if ((taskitem.getState().equals(TaskitemState.CREATE.getCode()) || taskitem.getState().equals(TaskitemState.VIEWED.getCode())) && (!finish || finish && (taskitem.getItemType().equals(NodeType.AUDIT.getCode()) || taskitem.getItemType().equals(NodeType.WRITE.getCode())))) {
                taskitem.setState(TaskitemState.CANCEL.getCode());
                taskitem.setUpdateTime(LocalDateTime.now());
                this.taskItemService.updateStTaskitem(taskitem);
                stepIds.add(taskitem.getStepid());
            }
        });
        List stepByInstanceid = this.stepService.getStepByInstanceid(instanceId);
        stepByInstanceid.stream().forEach(step -> {
            if (step.getState().equals(StepState.STAY.getCode()) && stepIds.contains(step.getStepid())) {
                step.setState(StepState.LEAVE.getCode());
                step.setApproval(StepApproval.REJECT.getCode());
                step.setUpdateTime(LocalDateTime.now());
                this.stepService.updateStStep(step);
            }
        });
    }

    @Override
    public synchronized Integer getMaxStepId(String instanceid, boolean add) {
        String key = RedisKeys.getCurStepId((String)instanceid, (String[])new String[0]);
        Integer maxStepId = (Integer)this.rd.getCacheObject(key);
        if (maxStepId == null) {
            maxStepId = this.stepService.getMaxStepId(instanceid);
            this.rd.set(key, (Object)maxStepId, 30L, TimeUnit.DAYS);
        }
        if (add) {
            this.rd.set(key, (Object)(maxStepId + 1), 30L, TimeUnit.DAYS);
            return maxStepId + 1;
        }
        return maxStepId;
    }

    @Override
    public String eventParam(StInstance instance) {
        String instanceJson = JSON.toJSONString((Object)this.eventParamClass(instance), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat});
        return instanceJson;
    }

    @Override
    public StInstanceEvent eventParamClass(StInstance instance) {
        StInstanceEvent stInstanceEvent = new StInstanceEvent();
        stInstanceEvent.setObjectid(instance.getObjectid());
        stInstanceEvent.setBizObjectid(instance.getBizObjectid());
        stInstanceEvent.setState(instance.getState());
        stInstanceEvent.setOriginator(instance.getOriginator());
        stInstanceEvent.setSequenceNo(instance.getSequenceNo());
        stInstanceEvent.setFlowCode(instance.getFlowCode());
        stInstanceEvent.setFlowVersion(instance.getFlowVersion());
        JSONObject jsonObject = this.formService.getMainFormTableData(stInstanceEvent.getFlowCode(), stInstanceEvent.getBizObjectid());
        stInstanceEvent.setMainFormData(jsonObject);
        return stInstanceEvent;
    }

    @Override
    public Boolean triggerEvent(StInstance instance, String eventParam, Integer eventId, String nodeId) {
        Boolean result = true;
        Map eventMap = this.settingService.selectEventUrl(eventId);
        String exceptionEvent = (String)eventMap.get("eventName");
        try {
            String response = StHttpRequest.postHttpClient((String)((String)eventMap.get("url")), (String)eventParam, (String)StpUtil.getTokenValue());
            if (response.contains("ok\":false")) {
                this.settingService.insertException(instance.getObjectid(), nodeId, exceptionEvent, response, "");
                result = false;
            }
        }
        catch (Exception e) {
            String rootErrorMessage = StExceptionUtil.getRootErrorMessage(e);
            String exceptionMessage = StExceptionUtil.getExceptionMessage(e);
            this.settingService.insertException(instance.getObjectid(), nodeId, exceptionEvent, rootErrorMessage, exceptionMessage);
            result = false;
        }
        if (!result.booleanValue()) {
            instance.setExceptional(Integer.valueOf(1));
            this.flowService.updateStInstance(instance);
        }
        return result;
    }
}

