/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.sa.flow.engine.core.builders;

import com.cloud.sa.flow.commom.common.system.StUserInfo;
import com.cloud.sa.flow.commom.common.utils.StString;
import com.cloud.sa.flow.commom.domain.entity.StStep;
import com.cloud.sa.flow.commom.domain.virenum.StepApproval;
import com.cloud.sa.flow.commom.domain.virenum.StepState;
import com.cloud.sa.flow.engine.mop.flow.NodeLogic;
import java.time.LocalDateTime;

public class StStepBuilder {
    private StStep step = new StStep();

    public StStepBuilder withStepId(Integer stepId) {
        this.step.setStepid(stepId);
        return this;
    }

    public StStepBuilder withNodeId(String nodeId) {
        this.step.setNodeid(nodeId);
        return this;
    }

    public StStepBuilder withInstanceId(String instanceId) {
        this.step.setInstanceid(instanceId);
        return this;
    }

    public StStepBuilder withBizObjectId(String bizObjectId) {
        this.step.setBizObjectid(bizObjectId);
        return this;
    }

    public StStepBuilder withState(Integer state) {
        this.step.setState(state);
        return this;
    }

    public StStepBuilder withApproval(Integer approval) {
        this.step.setApproval(approval);
        return this;
    }

    public StStepBuilder withActivityCode(String activityCode) {
        this.step.setActivityCode(activityCode);
        return this;
    }

    public StStepBuilder withActivityName(String activityName) {
        this.step.setActivityName(activityName);
        return this;
    }

    public StStepBuilder withFinishTime(LocalDateTime finishTime) {
        this.step.setFinishTime(finishTime);
        return this;
    }

    public StStepBuilder withObjectid(String objectid) {
        this.step.setObjectid(objectid);
        return this;
    }

    public StStepBuilder withCreateBy(String createBy) {
        this.step.setCreateBy(createBy);
        return this;
    }

    public StStepBuilder withCreateTime(LocalDateTime createTime) {
        this.step.setCreateTime(createTime);
        return this;
    }

    public StStepBuilder withUpdateBy(String updateBy) {
        this.step.setUpdateBy(updateBy);
        return this;
    }

    public StStepBuilder withUpdateTime(LocalDateTime updateTime) {
        this.step.setUpdateTime(updateTime);
        return this;
    }

    public StStep build() {
        if (StString.isEmpty((String)this.step.getObjectid())) {
            this.step.setObjectid(StString.getUUID());
        }
        if (this.step.getCreateTime() == null) {
            this.step.setCreateTime(LocalDateTime.now());
        }
        if (StString.isEmpty((String)this.step.getCreateBy())) {
            this.step.setCreateBy(StUserInfo.getUserCode());
        }
        if (this.step.getState() == null) {
            this.step.setState(StepState.STAY.getCode());
        }
        if (this.step.getApproval() == null) {
            this.step.setApproval(StepApproval.UN_DEAL.getCode());
        }
        NodeLogic.stepOff(this.step.getInstanceid());
        return this.step;
    }

    public static StStepBuilder newBuilder() {
        return new StStepBuilder();
    }
}

