/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.sa.flow.engine.service.form;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.cloud.sa.flow.commom.aspect.CacheProgram;
import com.cloud.sa.flow.commom.common.model.StResult;
import com.cloud.sa.flow.commom.common.redis.StRedisCache;
import com.cloud.sa.flow.commom.common.system.StUserInfo;
import com.cloud.sa.flow.commom.common.utils.FlowUtils;
import com.cloud.sa.flow.commom.common.utils.StString;
import com.cloud.sa.flow.commom.domain.common.RedisKeys;
import com.cloud.sa.flow.commom.domain.entity.StAddParticipant;
import com.cloud.sa.flow.commom.domain.entity.StFlowMenu;
import com.cloud.sa.flow.commom.domain.entity.StFormTemplate;
import com.cloud.sa.flow.commom.domain.entity.StFormTemplateHistory;
import com.cloud.sa.flow.commom.domain.entity.StInstance;
import com.cloud.sa.flow.commom.domain.entity.StScript;
import com.cloud.sa.flow.commom.domain.entity.StScriptHistory;
import com.cloud.sa.flow.commom.domain.entity.StTaskitem;
import com.cloud.sa.flow.commom.domain.entity.setting.StQueryMain;
import com.cloud.sa.flow.commom.domain.mapper.StAddParticipantMapper;
import com.cloud.sa.flow.commom.domain.mapper.StCommentMapper;
import com.cloud.sa.flow.commom.domain.mapper.StCommonMapper;
import com.cloud.sa.flow.commom.domain.mapper.StFlowTemplateMapper;
import com.cloud.sa.flow.commom.domain.mapper.StFormTemplateMapper;
import com.cloud.sa.flow.commom.domain.mapper.StSettingMapper;
import com.cloud.sa.flow.commom.domain.virentity.ActivityNode;
import com.cloud.sa.flow.commom.domain.virentity.AddParticipantDTO;
import com.cloud.sa.flow.commom.domain.virentity.Column;
import com.cloud.sa.flow.commom.domain.virentity.DictionaryMain;
import com.cloud.sa.flow.commom.domain.virentity.DictionaryParam;
import com.cloud.sa.flow.commom.domain.virentity.DynamicDataParam;
import com.cloud.sa.flow.commom.domain.virentity.FormLoadTemplate;
import com.cloud.sa.flow.commom.domain.virentity.OperatePower;
import com.cloud.sa.flow.commom.domain.virentity.StCommentVo;
import com.cloud.sa.flow.commom.domain.virentity.StDept;
import com.cloud.sa.flow.commom.domain.virentity.StFormModule;
import com.cloud.sa.flow.commom.domain.virentity.StPost;
import com.cloud.sa.flow.commom.domain.virentity.StUser;
import com.cloud.sa.flow.commom.domain.virentity.SuperStInstance;
import com.cloud.sa.flow.commom.domain.virenum.ActionType;
import com.cloud.sa.flow.commom.domain.virenum.AdmitContentType;
import com.cloud.sa.flow.commom.domain.virenum.ControlType;
import com.cloud.sa.flow.commom.domain.virenum.DataType;
import com.cloud.sa.flow.commom.domain.virenum.FlowTag;
import com.cloud.sa.flow.commom.domain.virenum.NodeType;
import com.cloud.sa.flow.commom.exception.FlowTemplateNotFoundException;
import com.cloud.sa.flow.commom.exception.FormSaveException;
import com.cloud.sa.flow.commom.exception.UnauthorizedException;
import com.cloud.sa.flow.commom.service.StMenuService;
import com.cloud.sa.flow.commom.service.StOrganizeService;
import com.cloud.sa.flow.commom.service.data.StDataService;
import com.cloud.sa.flow.commom.service.flow.StInstanceService;
import com.cloud.sa.flow.commom.service.flow.StTaskItemService;
import com.cloud.sa.flow.commom.service.genSql.SqlGeneratorService;
import com.cloud.sa.flow.commom.service.setting.StAdmitService;
import com.cloud.sa.flow.engine.mop.data.FileUploadInfo;
import com.cloud.sa.flow.engine.service.form.strategy.FormLoadAudit;
import com.cloud.sa.flow.engine.service.form.strategy.FormLoadCirculate;
import com.cloud.sa.flow.engine.service.form.strategy.FormLoadEdit;
import com.cloud.sa.flow.engine.service.form.strategy.FormLoadView;
import com.cloud.sa.flow.engine.service.form.strategy.FormLoadWrite;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class StFormService {
    @Autowired
    private StRedisCache rd;
    @Autowired
    StFormTemplateMapper formTemplateMapper;
    @Autowired
    StFlowTemplateMapper flowTemplateMapper;
    @Autowired
    StCommentMapper stCommentMapper;
    @Autowired
    StTaskItemService taskService;
    @Autowired
    StInstanceService instanceService;
    @Autowired
    SqlGeneratorService sqlGenerator;
    @Autowired
    StSettingMapper settingMapper;
    @Autowired
    StOrganizeService organizeService;
    @Autowired
    StDataService dataService;
    @Autowired
    StAdmitService admitService;
    @Autowired
    StFormService formService;
    @Autowired
    StMenuService menuService;
    @Autowired
    StAddParticipantMapper addParticipantMapper;
    @Autowired
    StCommonMapper commonMapper;
    @Value(value="${flow.fileBaseUrl}")
    private String fileBaseUrl;
    @Value(value="${file.storage.local.url-prefix}")
    private String urlPrefix;

    public void IstFormDataCache(String flowCode, String bizObjectID) {
        String formDataKey = RedisKeys.getMainFormData((String)bizObjectID, (String[])new String[0]);
        if (!this.rd.hasKey(formDataKey)) {
            this.rd.setCacheMap(formDataKey, this.getMainFormTableMap(flowCode, bizObjectID));
        }
    }

    public StFormTemplate getStFormTemplate(String flowCode, String type) {
        String formTemplateKey = RedisKeys.getFormTemplate((String)flowCode, (String)"", (String[])new String[0]);
        String formTemplateMobileKey = RedisKeys.getFormTemplate((String)flowCode, (String)"isMobile", (String[])new String[0]);
        if (!this.rd.hasKey(formTemplateKey) || !this.rd.hasKey(formTemplateMobileKey)) {
            StFormTemplate stFormTemplate = this.formTemplateMapper.getStFormTemplate(flowCode, "");
            this.rd.setCacheObject(formTemplateKey, (Object)stFormTemplate);
            StFormTemplate stFormTemplateMobile = this.formTemplateMapper.getStFormTemplate(flowCode, "isMobile");
            if (stFormTemplateMobile != null) {
                this.rd.setCacheObject(formTemplateMobileKey, (Object)stFormTemplateMobile);
            } else {
                this.rd.setCacheObject(formTemplateMobileKey, (Object)stFormTemplate);
            }
        }
        return (StFormTemplate)this.rd.getCacheObject(RedisKeys.getFormTemplate((String)flowCode, (String)type, (String[])new String[0]));
    }

    @CacheProgram(action=ActionType.FORM_TEMPLATE_LOAD)
    public StFormModule getFormLoadTemplate(String flowCode, String bizObjectID, String taskid, String type, String tag) {
        StFormModule stFormModule = new StFormModule();
        stFormModule.setFlowCode(flowCode);
        StFormTemplate stFormTemplate = this.getStFormTemplate(flowCode, type);
        stFormModule.setContent(Optional.ofNullable(stFormTemplate).map(StFormTemplate::getContent).orElseThrow(() -> new FlowTemplateNotFoundException(flowCode)));
        List<StScript> scriptByFlowCode = this.getScriptsByFlowCode(flowCode);
        stFormModule.setScriptList(scriptByFlowCode);
        String templateFieldKey = RedisKeys.getTemplateFieldData((String)flowCode, (String[])new String[0]);
        Map cacheMap = this.rd.getCacheMap(templateFieldKey);
        stFormModule.setFieldMap(cacheMap);
        StFlowMenu flowMenu = this.menuService.getStFlowMenuByFlowCode(flowCode);
        stFormModule.setFlowName(flowMenu.getFlowName());
        if (StString.isEmpty((String)bizObjectID) && StString.isEmpty((String)taskid)) {
            stFormModule.setTag(FlowTag.START.name());
            Boolean userInitAdmit = this.admitService.getUserInitAdmit(flowCode, StUserInfo.getUserCode());
            if (!userInitAdmit.booleanValue()) {
                throw new UnauthorizedException("\u65e0\u53d1\u8d77\u6d41\u7a0b\u6743\u9650\uff01");
            }
            Integer flowVersion = this.flowTemplateMapper.getLastFlowVersion(flowCode);
            stFormModule.setFlowVersion(flowVersion);
            return stFormModule;
        }
        if (StString.isEmpty((String)taskid)) {
            taskid = this.taskService.getLastTaskId(bizObjectID);
        }
        if (StString.isNotEmpty((String)bizObjectID) && StString.isNotEmpty((String)tag) && FlowTag.EDIT.name().equals(tag)) {
            Boolean userEditAdmit = this.admitService.getUserEditAdmit(flowCode, StUserInfo.getUserCode());
            if (!userEditAdmit.booleanValue()) {
                throw new UnauthorizedException("\u65e0\u6d41\u7a0b\u7f16\u8f91\u6743\u9650\uff01");
            }
            stFormModule.setTag(FlowTag.EDIT.name());
        } else {
            stFormModule.setTag(FlowTag.VIEW.name());
        }
        StTaskitem taskitem = this.taskService.getStTaskitem(taskid);
        stFormModule.setTaskItem(taskitem);
        stFormModule.setOperatePower(new OperatePower());
        StInstance instance = this.instanceService.getStInstance(taskitem.getInstanceid());
        Boolean userInitAdmit = this.admitService.getUserOpenAdmit(flowCode, StUserInfo.getUserCode(), instance.getObjectid());
        if (!userInitAdmit.booleanValue()) {
            throw new UnauthorizedException("\u65e0\u67e5\u770b\u6d41\u7a0b\u6743\u9650\uff01");
        }
        JSONObject allFormTableData = this.formService.getAllFormTableData(flowCode, bizObjectID, taskid);
        stFormModule.setFormTableData(allFormTableData);
        SuperStInstance superStInstance = new SuperStInstance();
        StUser stUser = this.organizeService.GetUserByCode(instance.getOriginator());
        superStInstance.setOriginatorName(stUser.getUserName());
        superStInstance.setOriginatorDepName(stUser.getUserDept());
        superStInstance.setObjectid(instance.getObjectid());
        superStInstance.setOriginator(instance.getOriginator());
        superStInstance.setFlowCode(instance.getFlowCode());
        superStInstance.setFlowVersion(instance.getFlowVersion());
        superStInstance.setStartTime(instance.getStartTime());
        superStInstance.setSequenceNo(instance.getSequenceNo());
        superStInstance.setBizObjectid(instance.getBizObjectid());
        superStInstance.setState(instance.getState());
        superStInstance.setExceptional(instance.getExceptional());
        stFormModule.setInstance(superStInstance);
        FormLoadTemplate formLoadTemplate = this.taskService.getFormLoadTemplate(taskid);
        if (StUserInfo.getUserCode().equals(taskitem.getParticipant()) && (taskitem.getState().equals(0) || taskitem.getState().equals(1))) {
            ActivityNode activityNode = (ActivityNode)this.rd.getCacheMapValue(RedisKeys.getTempNodeEntity((String)formLoadTemplate.getFlowCode(), (Integer)formLoadTemplate.getFlowVersion(), (String[])new String[0]), formLoadTemplate.getNodeId());
            List dataPowerData = activityNode.getDataPowerData();
            if (taskitem.getItemType().equals(NodeType.AUDIT.getCode())) {
                stFormModule.setTag(FlowTag.AUDIT.name());
                FormLoadAudit.logicDeal(dataPowerData, stFormModule, activityNode);
            } else if (taskitem.getItemType().equals(NodeType.WRITE.getCode())) {
                stFormModule.setTag(FlowTag.WRITE.name());
                FormLoadWrite.logicDeal(null, stFormModule, taskitem, activityNode);
            } else if (taskitem.getItemType().equals(NodeType.CIRCULATE.getCode())) {
                stFormModule.setTag(FlowTag.CIRCULATE.name());
                FormLoadCirculate.logicDeal(dataPowerData, stFormModule, activityNode);
            }
        } else if (FlowTag.EDIT.name().equals(tag)) {
            FormLoadEdit.logicDeal(stFormModule);
        } else {
            stFormModule.setTag(FlowTag.VIEW.name());
            FormLoadView.logicDeal(stFormModule);
        }
        return stFormModule;
    }

    public void resetFormDataCache(String flowCode, String bizObjectID) {
        String formDataKey = RedisKeys.getMainFormData((String)bizObjectID, (String[])new String[0]);
        this.rd.deleteObject(formDataKey);
        this.rd.setCacheMap(formDataKey, this.getMainFormTableMap(flowCode, bizObjectID));
    }

    public void removeFormTemplateCache(String flowCode, String mobile) {
        String formTemplateKey = RedisKeys.getFormTemplate((String)flowCode, (String)mobile, (String[])new String[0]);
        this.rd.deleteObject(formTemplateKey);
    }

    public JSONObject getMainFormTableData(String flowCode, String bizObjectID) {
        JSONObject jsonObject = new JSONObject();
        this.IstFormDataCache(flowCode, bizObjectID);
        String formDataKey = RedisKeys.getMainFormData((String)bizObjectID, (String[])new String[0]);
        Map map = this.rd.getCacheMap(formDataKey);
        String templateFieldKey = RedisKeys.getTemplateFieldData((String)flowCode, (String[])new String[0]);
        Map cacheMap = this.rd.getCacheMap(templateFieldKey);
        for (Map.Entry entry : map.entrySet()) {
            try {
                if (cacheMap.containsKey(entry.getKey()) && DataType.DATETIME.name().equals(((Column)cacheMap.get(entry.getKey())).getType())) {
                    Date date = (Date)entry.getValue();
                    SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    jsonObject.put((String)entry.getKey(), (Object)formatter.format(date));
                    continue;
                }
                jsonObject.put((String)entry.getKey(), entry.getValue());
            }
            catch (Exception e) {
                jsonObject.put((String)entry.getKey(), entry.getValue());
            }
        }
        return jsonObject;
    }

    @CacheProgram(action=ActionType.FORM_LOAD)
    public JSONObject getAllFormTableData(String flowCode, String bizObjectID, String taskId) {
        if (!StString.isEmpty((String)taskId)) {
            StTaskitem taskitem = this.taskService.getStTaskitem(taskId);
            bizObjectID = taskitem.getBizObjectid();
        }
        JSONObject jsonObject = this.getMainFormTableData(flowCode, bizObjectID);
        String templateFieldKey = RedisKeys.getTemplateFieldData((String)flowCode, (String[])new String[0]);
        Map cacheMap = this.rd.getCacheMap(templateFieldKey);
        for (Map.Entry entry : cacheMap.entrySet()) {
            String obj;
            Object o;
            if (((Column)entry.getValue()).getType().equals(DataType.CHILDREN.name())) {
                List<Map<String, Object>> childFormTableMap = this.getChildFormTableMap((String)entry.getKey(), bizObjectID);
                if (childFormTableMap.size() <= 0) continue;
                List<Column> children = ((Column)entry.getValue()).getChildren().stream().filter(f -> f.getType().equals(DataType.MULTI.name())).collect(Collectors.toList());
                children.forEach(f -> {
                    for (Map childFormTableMap1 : childFormTableMap) {
                        Object o = childFormTableMap1.get(f.getCode());
                        if (o == null) continue;
                        String value = StString.toString(o);
                        if (value.contains("[") && value.contains("]")) {
                            childFormTableMap1.put(f.getCode(), JSONArray.parse((String)StString.toString(o)));
                            continue;
                        }
                        if (!"".equals(value)) {
                            childFormTableMap1.put(f.getCode(), value);
                            continue;
                        }
                        if (!childFormTableMap1.containsKey(f.getCode())) continue;
                        childFormTableMap1.remove(f.getCode());
                    }
                });
                for (Map<String, Object> childFormTableMap1 : childFormTableMap) {
                    childFormTableMap1.put("key", childFormTableMap1.get("flow_id"));
                }
                JSONArray jsonArray = new JSONArray(Collections.singletonList(childFormTableMap));
                jsonObject.put((String)entry.getKey(), jsonArray.get(0));
                continue;
            }
            if (((Column)entry.getValue()).getType().equals(DataType.MULTI.name())) {
                o = jsonObject.get(entry.getKey());
                if (o == null || !JSON.isValidArray((String)StString.toString((Object)o))) continue;
                jsonObject.put((String)entry.getKey(), JSONArray.parse((String)StString.toString((Object)o)));
                continue;
            }
            if (!((Column)entry.getValue()).getType().equals(DataType.IMAGE.name()) || (o = jsonObject.get(entry.getKey())) == null || !(obj = o.toString()).contains("uid") || !obj.startsWith("[")) continue;
            List fileUploadInfos = JSON.parseArray((String)obj, FileUploadInfo.class);
            FileUploadInfo.fileBaseUrl = this.fileBaseUrl;
            jsonObject.put((String)entry.getKey(), JSON.toJSON((Object)fileUploadInfos));
        }
        return jsonObject;
    }

    public JSONObject getDynamicData(DynamicDataParam dynamicDataParam) {
        Set<Object> dynamicDataTypeList = new HashSet<String>();
        JSONObject jsonObject = new JSONObject();
        if (!StString.isEmpty((String)dynamicDataParam.getFlowCode())) {
            StFormTemplate stFormTemplate = this.getStFormTemplate(dynamicDataParam.getFlowCode(), dynamicDataParam.getIsMobile());
            String formTemplate = stFormTemplate.getContent();
            String regex = "\"dynamicKey\"\\s*:\\s*(\".*?\"|\\d+)";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(formTemplate);
            while (matcher.find()) {
                String value = matcher.group(1);
                dynamicDataTypeList.add(value.replace("\"", ""));
            }
            if (FlowUtils.dicStoredFlag.equals(dynamicDataParam.getDicStoredFlag()) && dynamicDataParam.getStoredIds() != null && dynamicDataParam.getStoredIds().size() > 0) {
                for (int i = 0; i < dynamicDataParam.getStoredIds().size(); ++i) {
                    jsonObject.put((String)dynamicDataParam.getStoredIds().get(i), (Object)"STORED");
                }
            } else {
                dynamicDataParam.setStoredIds(new ArrayList());
            }
            dynamicDataTypeList = dynamicDataTypeList.stream().filter(item -> !dynamicDataParam.getStoredIds().contains(item)).collect(Collectors.toSet());
            for (String string : dynamicDataTypeList) {
                if ("deptAndPersonOptions".equals(string)) {
                    jsonObject.put("deptAndPersonOptions", (Object)this.buildParticipantTree());
                    continue;
                }
                DictionaryMain dictionaryMain = this.formTemplateMapper.getDictMainByType(string);
                if (dictionaryMain == null) continue;
                if ("0".equals(dictionaryMain.getSourceType())) {
                    List dictByType = this.formTemplateMapper.getDictByType(string);
                    jsonObject.put(string, (Object)dictByType);
                    continue;
                }
                try {
                    List mapList = this.commonMapper.getChildSqlFieldValues(dictionaryMain.getSourceSql());
                    ArrayList dictByType = new ArrayList();
                    jsonObject.put(string, dictByType);
                    mapList.forEach(map -> {
                        DictionaryParam dictionaryParam = new DictionaryParam();
                        dictionaryParam.setLabel(StString.toString(map.get("key")));
                        dictionaryParam.setValue(StString.toString(map.get("value")));
                        dictByType.add(dictionaryParam);
                    });
                }
                catch (RuntimeException runtimeException) {}
            }
        } else {
            jsonObject.put("deptAndPersonOptions", (Object)this.buildParticipantTree());
        }
        jsonObject.put("dicStoredFlag", (Object)FlowUtils.dicStoredFlag);
        return jsonObject;
    }

    public List<Map<String, String>> getAllDict() {
        return this.formTemplateMapper.getAllDict();
    }

    public Map<String, Object> getMainFormTableMap(String flowCode, String bizObjectID) {
        String sql = this.sqlGenerator.getMainFormTableSql(flowCode, bizObjectID);
        return this.commonMapper.getSqlFieldValues(sql);
    }

    public List<Map<String, Object>> getChildFormTableMap(String flowCode, String bizObjectID) {
        String sql = this.sqlGenerator.getChildFormTableSql(flowCode, bizObjectID);
        return this.commonMapper.getChildSqlFieldValues(sql);
    }

    public JSONArray buildParticipantTree() {
        JSONObject jsonObject;
        JSONArray jsonObjectP;
        String fjm;
        String key = RedisKeys.getPrefixOrganize((String[])new String[0]);
        if (this.rd.hasKey(key)) {
            return (JSONArray)this.rd.getCacheObject(key);
        }
        List departments = this.organizeService.getAllDept();
        List employees = this.organizeService.getAllUser();
        List allPost = this.organizeService.getAllPost();
        HashMap<String, JSONArray> map = new HashMap<String, JSONArray>();
        map.put("0", new JSONArray());
        for (StDept department : departments) {
            fjm = department.getFjm();
            JSONArray ja = (JSONArray)map.get(fjm.substring(0, fjm.length() - 6));
            if (ja == null) {
                ja = (JSONArray)map.get("0");
            }
            JSONObject jo2 = new JSONObject();
            jo2.put("value", (Object)department.getDeptCode());
            jo2.put("label", (Object)department.getDeptName());
            jo2.put("fjm", (Object)fjm);
            jo2.put("type", (Object)AdmitContentType.DEPT.getCode());
            jo2.put("sort", (Object)department.getSort());
            ja.add((Object)jo2);
            JSONArray jazi = new JSONArray();
            jo2.put("children", (Object)jazi);
            map.put(fjm, jazi);
        }
        for (StUser employee : employees) {
            fjm = employee.getFjm();
            if (!map.containsKey(fjm)) continue;
            jsonObjectP = (JSONArray)map.get(fjm);
            jsonObject = new JSONObject();
            jsonObject.put("value", (Object)employee.getUserCode());
            jsonObject.put("label", (Object)employee.getUserName());
            jsonObject.put("type", (Object)AdmitContentType.EMP.getCode());
            jsonObjectP.add((Object)jsonObject);
        }
        for (StPost post : allPost) {
            fjm = post.getFjm();
            if (!map.containsKey(fjm)) continue;
            jsonObjectP = (JSONArray)map.get(fjm);
            jsonObject = new JSONObject();
            jsonObject.put("value", (Object)post.getPostCode());
            jsonObject.put("label", (Object)post.getPostName());
            jsonObject.put("type", (Object)AdmitContentType.POST.getCode());
            jsonObjectP.add((Object)jsonObject);
        }
        JSONArray result = (JSONArray)map.get("0");
        result.forEach(jo -> {
            JSONObject jsonObject = (JSONObject)jo;
            if (jsonObject != null) {
                JSONArray jsonArray = jsonObject.getJSONArray("children");
                jsonArray = jsonArray.stream().sorted(Comparator.comparingInt(o -> {
                    Integer sort = ((JSONObject)o).getInteger("sort");
                    if (sort == null) {
                        sort = 0;
                    }
                    return sort;
                }).reversed()).collect(Collectors.toCollection(JSONArray::new));
                jsonObject.put("children", (Object)jsonArray);
            }
        });
        this.rd.setCacheObject(key, (Object)result, Integer.valueOf(1), TimeUnit.DAYS);
        return result;
    }

    private void checkFormModel(String model) {
        String text;
        String[] split = model.split("_");
        List allType = ControlType.getAllType();
        if (split.length == 2 && split[1].length() == 13 && allType.contains(text = split[0])) {
            throw new FormSaveException(model);
        }
    }

    private void checkColumn(Column column, JSONObject rootJson) {
        JSONObject parentByModel = FlowUtils.findParentByModel((JSONObject)rootJson, (String)column.getCode());
        if (parentByModel != null) {
            if (ControlType.UPLOAD_IMG.getType().equals(parentByModel.get((Object)"type")) && !DataType.IMAGE.name().equals(column.getType())) {
                throw new FormSaveException(column.getName());
            }
            if (ControlType.UPLOAD_FILE.getType().equals(parentByModel.get((Object)"type")) && !DataType.ATTACH.name().equals(column.getType())) {
                throw new FormSaveException(column.getName());
            }
            if (ControlType.DATE.getType().equals(parentByModel.get((Object)"type")) && !DataType.DATETIME.name().equals(column.getType())) {
                throw new FormSaveException(column.getName());
            }
            if (ControlType.TIME.getType().equals(parentByModel.get((Object)"type")) && !DataType.DATETIME.name().equals(column.getType())) {
                throw new FormSaveException(column.getName());
            }
            if (DataType.DECIMAL.name().equals(column.getType()) && !ControlType.NUMBER.getType().equals(parentByModel.get((Object)"type"))) {
                throw new FormSaveException(column.getName());
            }
        }
    }

    @Transactional
    @CacheProgram(action=ActionType.PUBLISH_FORM)
    public void istStFormTemplate(StFormTemplate stFormTemplate) {
        List columns = this.dataService.getStDataColumn(stFormTemplate.getFlowCode());
        Pattern pattern = Pattern.compile("\"model\":\"([^\"]*)\"");
        Matcher matcher = pattern.matcher(stFormTemplate.getContent());
        while (matcher.find()) {
            this.checkFormModel(matcher.group(1));
        }
        JSONObject rootJson = JSONObject.parseObject((String)stFormTemplate.getContent());
        columns.forEach(column -> this.checkColumn((Column)column, rootJson));
        Integer exist = this.formTemplateMapper.existStFormTemplate(stFormTemplate.getFlowCode(), stFormTemplate.getType());
        StFormTemplateHistory formTemplateHistory = new StFormTemplateHistory();
        formTemplateHistory.setContent(stFormTemplate.getContent());
        formTemplateHistory.setFlowCode(stFormTemplate.getFlowCode());
        if ("isMobile".equals(stFormTemplate.getType())) {
            formTemplateHistory.setType("mobile");
        } else {
            formTemplateHistory.setType("pc");
        }
        Integer formTemplateNum = this.formTemplateMapper.getFormTemplateNum(formTemplateHistory);
        formTemplateHistory.setVersion(Integer.valueOf(formTemplateNum + 1));
        formTemplateHistory.setCreateBy(StUserInfo.getUserCode());
        formTemplateHistory.setCreateTime(LocalDateTime.now());
        this.formTemplateMapper.istStFormTemplateHistory(formTemplateHistory);
        if (exist == 0) {
            stFormTemplate.setCreateBy(StUserInfo.getUserCode());
            stFormTemplate.setCreateTime(LocalDateTime.now());
            this.formTemplateMapper.istStFormTemplate(stFormTemplate);
        } else if (((JSONArray)rootJson.get((Object)"list")).size() == 0 && "isMobile".equals(stFormTemplate.getType())) {
            this.formTemplateMapper.deleteStFormTemplate(stFormTemplate);
        } else {
            stFormTemplate.setUpdateBy(StUserInfo.getUserCode());
            stFormTemplate.setUpdateTime(LocalDateTime.now());
            this.formTemplateMapper.updateStFormTemplate(stFormTemplate);
        }
    }

    public List<StCommentVo> getStCommentByInstanceid(String instanceid) {
        List comments = this.stCommentMapper.getStCommentByInstanceid(instanceid);
        String target = "public";
        for (StCommentVo comment : comments) {
            int position;
            if (comment.getImageUrl() == null || (position = comment.getImageUrl().indexOf(target)) == -1) continue;
            comment.setImageUrl(this.urlPrefix + comment.getImageUrl().substring(position));
        }
        return comments;
    }

    public String getScript(String objectid) {
        return this.formTemplateMapper.getScript(objectid);
    }

    public void deleteScript(String objectid) {
        this.formTemplateMapper.deleteScript(objectid);
    }

    public JSONObject getPopUpData(String queryCode) {
        StQueryMain singleQueryMainByCode = this.settingMapper.getSingleQueryMainByCode(queryCode);
        singleQueryMainByCode.initList();
        List queryColumnList = singleQueryMainByCode.getQueryColumnList();
        JSONObject jsonObject = new JSONObject();
        JSONArray jaColumn = new JSONArray();
        JSONArray jaQuery = new JSONArray();
        jsonObject.put("headerQuery", (Object)jaQuery);
        jsonObject.put("columns", (Object)jaColumn);
        queryColumnList.forEach(f -> {
            JSONObject jo;
            if (f.getSearch().booleanValue()) {
                jo = new JSONObject();
                jo.put("field", (Object)f.getField());
                jo.put("fieldName", (Object)f.getFieldName());
                jaQuery.add((Object)jo);
            }
            if (f.getVisible().booleanValue()) {
                jo = new JSONObject();
                jo.put("key", (Object)f.getField());
                jo.put("dataIndex", (Object)f.getField());
                jo.put("title", (Object)f.getFieldName());
                jaColumn.add((Object)jo);
            }
        });
        return jsonObject;
    }

    public void updateScript(StScriptHistory script) {
        script.setUpdateBy(StUserInfo.getUserCode());
        script.setCreateBy(StUserInfo.getUserCode());
        this.formTemplateMapper.deleteAndInsertScript((StScript)script);
        Integer historyScriptNum = this.formTemplateMapper.getHistoryScriptNum((StScript)script);
        script.setVersion(Integer.valueOf(historyScriptNum + 1));
        script.setObjectid(StString.getUUID());
        this.formTemplateMapper.historyScript(script);
        String redisKey = RedisKeys.getFormScript((String)script.getFlowCode(), (String[])new String[0]);
        this.rd.deleteObject(redisKey);
    }

    public List<StScriptHistory> getScriptHistory(String flowCode, String key) {
        return this.formTemplateMapper.getScriptHistory(flowCode, key);
    }

    public List<StFormTemplateHistory> getFormTemplateHistory(String flowCode, String type) {
        return this.formTemplateMapper.getFormTemplateHistory(flowCode, type);
    }

    public String getFormTemplateContentHistory(Long id) {
        return this.formTemplateMapper.getFormTemplateContentHistory(id);
    }

    public List<StScript> getScriptsByFlowCode(String flowCode) {
        String redisKey = RedisKeys.getFormScript((String)flowCode, (String[])new String[0]);
        if (!this.rd.hasKey(redisKey)) {
            this.rd.setCacheObject(redisKey, (Object)this.formTemplateMapper.getScriptByFlowCode(flowCode));
        }
        return (List)this.rd.getCacheObject(redisKey);
    }

    public List<Map> getTraceData(String bizObjectId) {
        String sql = this.sqlGenerator.getFieldTraceGet(bizObjectId);
        List sqlMap = this.commonMapper.getSqlMapList(sql);
        return sqlMap;
    }

    public List<AddParticipantDTO> getAddParticipant(String instanceId, String activityCode) {
        ArrayList<AddParticipantDTO> addParticipantDTOS = new ArrayList<AddParticipantDTO>();
        List<StAddParticipant> addParticipantByInstanceIdAndTaskCode = this.getAddParticipantByInstanceIdAndTaskCode(instanceId, activityCode);
        for (StAddParticipant stAddParticipant : addParticipantByInstanceIdAndTaskCode) {
            AddParticipantDTO addParticipantDTO = new AddParticipantDTO();
            addParticipantDTO.setId(stAddParticipant.getId());
            addParticipantDTO.setInstanceId(stAddParticipant.getInstanceId());
            addParticipantDTO.setActivityCode(stAddParticipant.getActivityCode());
            StUser user = this.organizeService.GetUserByCode(stAddParticipant.getUserCode());
            if (user == null) continue;
            addParticipantDTO.setUser(user);
            addParticipantDTOS.add(addParticipantDTO);
        }
        return addParticipantDTOS;
    }

    public List<StAddParticipant> getAddParticipantByInstanceIdAndTaskCode(String instanceId, String activityCode) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)lambdaQueryWrapper.eq(StAddParticipant::getInstanceId, (Object)instanceId)).eq(StAddParticipant::getActivityCode, (Object)activityCode);
        return this.addParticipantMapper.selectList((Wrapper)lambdaQueryWrapper);
    }

    public StResult addParticipant(List<StAddParticipant> addParticipants) {
        if (addParticipants == null || addParticipants.size() == 0) {
            return StResult.success();
        }
        List<StAddParticipant> addParticipantByInstanceIdAndTaskCode = this.getAddParticipantByInstanceIdAndTaskCode(addParticipants.get(0).getInstanceId(), addParticipants.get(0).getActivityCode());
        if (addParticipantByInstanceIdAndTaskCode.size() > 0) {
            this.addParticipantMapper.deleteBatchIds((Collection)addParticipantByInstanceIdAndTaskCode.stream().map(StAddParticipant::getId).collect(Collectors.toList()));
        }
        for (StAddParticipant addParticipant : addParticipants) {
            this.addParticipantMapper.insert((Object)addParticipant);
        }
        return StResult.success();
    }

    public void updateSql(String updateSqlStr) {
        this.commonMapper.updateSql(updateSqlStr);
    }
}

