/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.sa.flow.engine.service;

import com.cloud.sa.flow.commom.aspect.CacheProgram;
import com.cloud.sa.flow.commom.common.redis.StRedisCache;
import com.cloud.sa.flow.commom.common.utils.StString;
import com.cloud.sa.flow.commom.domain.common.RedisKeys;
import com.cloud.sa.flow.commom.domain.entity.StInstance;
import com.cloud.sa.flow.commom.domain.entity.StStep;
import com.cloud.sa.flow.commom.domain.entity.StTaskitem;
import com.cloud.sa.flow.commom.domain.mapper.StCommentMapper;
import com.cloud.sa.flow.commom.domain.virentity.ActivityNode;
import com.cloud.sa.flow.commom.domain.virentity.ActivityNodeBase;
import com.cloud.sa.flow.commom.domain.virentity.ParamAdJustActivate;
import com.cloud.sa.flow.commom.domain.virentity.StUser;
import com.cloud.sa.flow.commom.domain.virentity.ViewListPassed;
import com.cloud.sa.flow.commom.domain.virenum.ActionType;
import com.cloud.sa.flow.commom.domain.virenum.InstanceState;
import com.cloud.sa.flow.commom.domain.virenum.NodeType;
import com.cloud.sa.flow.commom.domain.virenum.TaskitemState;
import com.cloud.sa.flow.commom.service.StOrganizeService;
import com.cloud.sa.flow.commom.service.flow.StInstanceService;
import com.cloud.sa.flow.commom.service.flow.StStepService;
import com.cloud.sa.flow.commom.service.flow.StTaskItemService;
import com.cloud.sa.flow.engine.engine.coreface.CoreBpmFlowAnalysisInterface;
import com.cloud.sa.flow.engine.engine.utils.EngineUtils;
import com.cloud.sa.flow.engine.service.StFlowService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class StOperationService {
    @Autowired
    StRedisCache rd;
    @Autowired
    StInstanceService instanceService;
    @Autowired
    StTaskItemService taskItemService;
    @Autowired
    StStepService stepService;
    @Autowired
    CoreBpmFlowAnalysisInterface coreBpmFlowAnalysis;
    @Autowired
    StOrganizeService organizeService;
    @Autowired
    EngineUtils engineUtils;
    @Autowired
    StOperationService operationService;
    @Autowired
    StCommentMapper commentMapper;
    @Autowired
    StFlowService flowService;

    @Transactional
    public void activateInstance(String instanceId) {
        StInstance instance = this.instanceService.getStInstance(instanceId);
        instance.setState(InstanceState.RUNNING.getCode());
        instance.setUpdateTime(LocalDateTime.now());
        this.instanceService.updateStInstance(instance);
    }

    @CacheProgram(action=ActionType.FINISH)
    public void finishInstance(String instanceId) {
        this.coreBpmFlowAnalysis.overTargetTask(instanceId, true);
    }

    @Transactional
    @CacheProgram(action=ActionType.CANCEL)
    public void cancelInstance(String instanceId) {
        StInstance instance = this.instanceService.getStInstance(instanceId);
        instance.setState(InstanceState.CANCEL.getCode());
        instance.setUpdateTime(LocalDateTime.now());
        this.instanceService.updateStInstance(instance);
        this.coreBpmFlowAnalysis.overTargetTask(instanceId, false);
    }

    @Transactional
    @CacheProgram(action=ActionType.ADJUST)
    public void adjustActivate(ParamAdJustActivate param) {
        this.turnoverActivate(param, false);
    }

    @Transactional
    @CacheProgram(action=ActionType.REJECT_SPECIFY)
    public void rejectToSpecifyActivate(ParamAdJustActivate param) {
        this.coreBpmFlowAnalysis.overTargetTask(param.getInstanceId(), false);
        this.turnoverActivate(param, true);
        StInstance instance = this.flowService.getStInstance(param.getInstanceId());
        StTaskitem taskItem = this.taskItemService.getStTaskitem(param.getCurTaskId());
        StStep step = this.stepService.getStStep(taskItem.getInstanceid(), taskItem.getStepid());
        this.flowService.tableFieldProcessForRejection(instance, taskItem, step, param.getComment());
    }

    public List<ParamAdJustActivate> getLastApprovalNodes(String instanceId) {
        List lastApprovalInformation = this.taskItemService.getLastApprovalInformation(instanceId);
        ArrayList<ParamAdJustActivate> paramAdJustActivates = new ArrayList<ParamAdJustActivate>();
        ParamAdJustActivate startAdJustActivate = new ParamAdJustActivate();
        startAdJustActivate.setActivityCode("Task2");
        startAdJustActivate.setActivityName("\u53d1\u8d77\u6d41\u7a0b\u8282\u70b9");
        paramAdJustActivates.add(startAdJustActivate);
        for (ViewListPassed viewListPassed : lastApprovalInformation) {
            if (!TaskitemState.APPROVED.getCode().equals(viewListPassed.getState()) || paramAdJustActivates.stream().filter(f -> viewListPassed.getNodeid().equals(f.getNodeId())).count() != 0L) continue;
            ParamAdJustActivate paramAdJustActivate = new ParamAdJustActivate();
            paramAdJustActivates.add(paramAdJustActivate);
            paramAdJustActivate.setInstanceId(instanceId);
            paramAdJustActivate.setNodeId(viewListPassed.getNodeid());
            paramAdJustActivate.setActivityName(viewListPassed.getNodeName());
            paramAdJustActivate.setActivityCode(viewListPassed.getActivityCode());
        }
        return paramAdJustActivates;
    }

    public void turnoverActivate(ParamAdJustActivate param, boolean isReject) {
        if (param.getParticipants() != null) {
            List realP = param.getParticipants().stream().filter(f -> StString.isNotEmpty((String)f)).collect(Collectors.toList());
            param.setParticipants(realP);
        } else {
            param.setParticipants(new ArrayList());
        }
        StInstance instance = this.instanceService.getStInstance(param.getInstanceId());
        String nodeRedisKey = RedisKeys.getTempNodeEntity((String)instance.getFlowCode(), (Integer)instance.getFlowVersion(), (String[])new String[]{"adjustActivate", "nodeRedisKey"});
        ActivityNode activityNode = (ActivityNode)this.rd.getCacheMapValue(nodeRedisKey, param.getNodeId());
        if (activityNode.getCode().equals("Task2") && param.getParticipants().size() == 0) {
            ArrayList<String> originator = new ArrayList<String>();
            originator.add(instance.getOriginator());
            param.setParticipants(originator);
        }
        if (activityNode.getCode().equals("Task3")) {
            this.operationService.finishInstance(instance.getObjectid());
        }
        if (activityNode.getNodeType().equals(NodeType.CIRCULATE.getCode()) || isReject) {
            List<String> participants = this.engineUtils.anaP(instance, activityNode);
            param.setParticipants(participants);
        }
        if (activityNode.getNodeType().equals(NodeType.WRITE.getCode()) || activityNode.getNodeType().equals(NodeType.AUDIT.getCode()) || activityNode.getNodeType().equals(NodeType.CIRCULATE.getCode())) {
            this.taskItemService.updateTaskItemForAdjust(instance.getObjectid(), activityNode.getCode());
            this.stepService.updateStepForAdjust(instance.getObjectid(), activityNode.getCode());
        }
        this.coreBpmFlowAnalysis.adjustStepCurrent(activityNode, instance, param.getParticipants());
    }

    public List<ActivityNodeBase> getNodeList(String flowCode, Integer flowVersion) {
        String NodeRedisKey = RedisKeys.getTempNodeEntity((String)flowCode, (Integer)flowVersion, (String[])new String[]{"getNodeList\uff0c\u8c03\u6574\u6d3b\u52a8\uff0c\u9009\u62e9node"});
        Map cacheMap = this.rd.getCacheMap(NodeRedisKey);
        List<Object> list = new ArrayList();
        ActivityNodeBase endActivityNode = null;
        for (ActivityNode node : cacheMap.values()) {
            if (NodeType.WRITE.getCode().equals(node.getNodeType()) || NodeType.AUDIT.getCode().equals(node.getNodeType()) || NodeType.CIRCULATE.getCode().equals(node.getNodeType()) || NodeType.EVENT.getCode().equals(node.getNodeType()) || NodeType.CHILDFLOW.getCode().equals(node.getNodeType()) || NodeType.LINKPOINT.getCode().equals(node.getNodeType())) {
                String participants = null;
                if (node.getParticipants() != null && node.getParticipants().size() > 0) {
                    participants = (String)node.getParticipants().get(0);
                }
                list.add(new ActivityNodeBase(node.getId(), node.getName(), node.getCode(), participants, node.getNodeType()));
                continue;
            }
            if (!NodeType.END.getCode().equals(node.getNodeType())) continue;
            endActivityNode = new ActivityNodeBase(node.getId(), node.getName(), node.getCode(), "", node.getNodeType());
        }
        list = list.stream().sorted(Comparator.comparing(ActivityNodeBase::getCode)).collect(Collectors.toList());
        list.add(endActivityNode);
        return list;
    }

    public List<StUser> getUsersMsg(String instanceId, String userCodes, String nodeType) {
        if (StString.isEmpty((String)userCodes)) {
            userCodes = "";
        }
        ArrayList<StUser> collect = new ArrayList<StUser>();
        if (NodeType.WRITE.getCode().equals(nodeType)) {
            StInstance instance = this.instanceService.getStInstance(instanceId);
            String originator = instance.getOriginator();
            StUser stUser = this.organizeService.GetUserByCode(originator);
            if (stUser != null) {
                stUser.setUserId("*" + stUser.getUserId() + "*");
                collect.add(stUser);
            }
        } else if (NodeType.AUDIT.getCode().equals(nodeType)) {
            ArrayList<String> participantsListString = new ArrayList<String>();
            participantsListString.add(userCodes);
            StInstance instance = this.instanceService.getStInstance(instanceId);
            List<String> userCodeList = this.engineUtils.anaPStr(instance, participantsListString);
            userCodeList = userCodeList.stream().distinct().collect(Collectors.toList());
            userCodeList.forEach(userCode -> {
                StUser stUser = this.organizeService.GetUserByCode(userCode);
                if (stUser != null) {
                    stUser.setUserId("*" + stUser.getUserId() + "*");
                    collect.add(stUser);
                }
            });
        }
        return collect;
    }
}

