/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.sa.flow.engine.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.cloud.sa.flow.commom.aspect.CacheProgram;
import com.cloud.sa.flow.commom.common.model.StCodeMsg;
import com.cloud.sa.flow.commom.common.model.StResult;
import com.cloud.sa.flow.commom.common.redis.StRedisCache;
import com.cloud.sa.flow.commom.common.system.RequestContextHolder;
import com.cloud.sa.flow.commom.common.system.StUserInfo;
import com.cloud.sa.flow.commom.common.utils.StConvert;
import com.cloud.sa.flow.commom.common.utils.StSpringUtils;
import com.cloud.sa.flow.commom.common.utils.StString;
import com.cloud.sa.flow.commom.domain.common.RedisKeys;
import com.cloud.sa.flow.commom.domain.entity.StComment;
import com.cloud.sa.flow.commom.domain.entity.StDataTemplate;
import com.cloud.sa.flow.commom.domain.entity.StFlowExceptional;
import com.cloud.sa.flow.commom.domain.entity.StFlowMenu;
import com.cloud.sa.flow.commom.domain.entity.StFlowTemplate;
import com.cloud.sa.flow.commom.domain.entity.StFormTemplate;
import com.cloud.sa.flow.commom.domain.entity.StInstance;
import com.cloud.sa.flow.commom.domain.entity.StInstanceBase;
import com.cloud.sa.flow.commom.domain.entity.StScript;
import com.cloud.sa.flow.commom.domain.entity.StStep;
import com.cloud.sa.flow.commom.domain.entity.StTaskAgent;
import com.cloud.sa.flow.commom.domain.entity.StTaskitem;
import com.cloud.sa.flow.commom.domain.entity.setting.StEventAdditive;
import com.cloud.sa.flow.commom.domain.mapper.StCommentMapper;
import com.cloud.sa.flow.commom.domain.mapper.StCommonMapper;
import com.cloud.sa.flow.commom.domain.mapper.StDataTemplateMapper;
import com.cloud.sa.flow.commom.domain.mapper.StEventAdditiveMapper;
import com.cloud.sa.flow.commom.domain.mapper.StFlowExceptionalMapper;
import com.cloud.sa.flow.commom.domain.mapper.StFlowMenuMapper;
import com.cloud.sa.flow.commom.domain.mapper.StFlowTemplateMapper;
import com.cloud.sa.flow.commom.domain.mapper.StFormTemplateMapper;
import com.cloud.sa.flow.commom.domain.mapper.StTaskAgentMapper;
import com.cloud.sa.flow.commom.domain.virentity.ActivityNode;
import com.cloud.sa.flow.commom.domain.virentity.Column;
import com.cloud.sa.flow.commom.domain.virentity.FlowEnteredParam;
import com.cloud.sa.flow.commom.domain.virentity.StUser;
import com.cloud.sa.flow.commom.domain.virentity.TaskItemDisplay;
import com.cloud.sa.flow.commom.domain.virentity.ViewFormTop;
import com.cloud.sa.flow.commom.domain.virentity.ViewList;
import com.cloud.sa.flow.commom.domain.virentity.ViewListParticipant;
import com.cloud.sa.flow.commom.domain.virentity.ViewListPassed;
import com.cloud.sa.flow.commom.domain.virenum.ActionType;
import com.cloud.sa.flow.commom.domain.virenum.DataType;
import com.cloud.sa.flow.commom.domain.virenum.InstanceState;
import com.cloud.sa.flow.commom.domain.virenum.NodeType;
import com.cloud.sa.flow.commom.domain.virenum.StepApproval;
import com.cloud.sa.flow.commom.domain.virenum.StepState;
import com.cloud.sa.flow.commom.domain.virenum.TaskitemState;
import com.cloud.sa.flow.commom.service.StMenuService;
import com.cloud.sa.flow.commom.service.StOrganizeService;
import com.cloud.sa.flow.commom.service.data.StDataService;
import com.cloud.sa.flow.commom.service.flow.StInstanceService;
import com.cloud.sa.flow.commom.service.flow.StStepService;
import com.cloud.sa.flow.commom.service.flow.StTaskItemService;
import com.cloud.sa.flow.commom.service.genSql.SqlGeneratorService;
import com.cloud.sa.flow.commom.service.setting.StAdmitService;
import com.cloud.sa.flow.commom.service.setting.StSettingService;
import com.cloud.sa.flow.engine.core.builders.StTaskitemBuilder;
import com.cloud.sa.flow.engine.engine.coreface.CoreBpmFlowAnalysisInterface;
import com.cloud.sa.flow.engine.engine.utils.CheckUtils;
import com.cloud.sa.flow.engine.engine.utils.EngineUtils;
import com.cloud.sa.flow.engine.engine.utils.LogsUtils;
import com.cloud.sa.flow.engine.mop.flow.ExportData;
import com.cloud.sa.flow.engine.service.form.StFormService;
import com.cloud.sa.flow.engine.subs.Exceptions.SaveDataException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class StFlowService {
    @Autowired
    StFlowService flowService;
    @Autowired
    StRedisCache rd;
    @Autowired
    CoreBpmFlowAnalysisInterface coreBpmFlowAnalysis;
    @Autowired
    EngineUtils engineUtils;
    @Autowired
    LogsUtils logsUtils;
    @Autowired
    StMenuService menuService;
    @Autowired
    StFlowTemplateMapper flowTemplateMapper;
    @Autowired
    StInstanceService instanceService;
    @Autowired
    StStepService stepService;
    @Autowired
    StTaskItemService taskItemService;
    @Autowired
    StCommentMapper commentMapper;
    @Autowired
    CheckUtils checkUtils;
    @Autowired
    StFormService formService;
    @Autowired
    StFlowExceptionalMapper flowExceptionalMapper;
    @Autowired
    StDataService dataService;
    @Autowired
    StOrganizeService organizeService;
    @Autowired
    SqlGeneratorService sqlGenerator;
    @Autowired
    StTaskAgentMapper taskAgentMapper;
    @Autowired
    StSettingService settingService;
    @Autowired
    StAdmitService admitService;
    @Autowired
    StCommonMapper commonMapper;
    @Value(value="${flow.baseIconUrl}")
    private String baseIconUrl;
    private ThreadPoolTaskExecutor executor = (ThreadPoolTaskExecutor)StSpringUtils.getBean((String)"StThreadPoolTaskExecutor");
    @Autowired
    StDataTemplateMapper stDataTemplateMapper;
    @Autowired
    StFormTemplateMapper stFormTemplateMapper;
    @Autowired
    StEventAdditiveMapper stEventAdditiveMapper;
    @Autowired
    StFlowMenuMapper stFlowMenuMapper;

    public EngineUtils getEngineTools() {
        return this.engineUtils;
    }

    public StFormService getFormService() {
        return this.formService;
    }

    public StDataService getDataService() {
        return this.dataService;
    }

    public StOrganizeService getOrganizeService() {
        return this.organizeService;
    }

    @Transactional
    @CacheProgram(action=ActionType.SUBMIT)
    public String Submit(FlowEnteredParam flowEnteredParam) {
        String errorMessage = "";
        StTaskitem taskItem = this.getStTaskitem(flowEnteredParam.getTaskid());
        errorMessage = this.checkUtils.IsCanSubmit(flowEnteredParam, taskItem);
        if (StString.isNotEmpty((String)errorMessage)) {
            return errorMessage;
        }
        RequestContextHolder.setTaskBeingManipulatedId((String)taskItem.getObjectid());
        StInstance instance = this.getStInstance(taskItem.getInstanceid());
        StComment stComment = new StComment(taskItem.getBizObjectid(), taskItem.getInstanceid(), taskItem.getObjectid(), StUserInfo.getUserCode(), flowEnteredParam.getComment(), Integer.valueOf(1));
        this.commentMapper.istStComment(stComment);
        if (taskItem.getStepid() == 1 && instance.getInstanceName() != null && instance.getInstanceName().contains("{") && instance.getInstanceName().contains("}")) {
            StFlowMenu flowMenu = this.menuService.getStFlowMenuByFlowCode(instance.getFlowCode());
            instance.setInstanceName(this.engineUtils.GetSequenceName(instance, flowMenu, null));
        }
        instance.setUpdateBy(StUserInfo.getUserCode());
        instance.setLastActiveTime(LocalDateTime.now());
        if (instance.getStartTime() == null) {
            instance.setStartTime(LocalDateTime.now());
        }
        StStep step = this.stepService.getStStep(taskItem.getInstanceid(), taskItem.getStepid());
        List curStepTi = this.taskItemService.getCurStepStTaskitem(instance.getObjectid(), taskItem.getStepid());
        taskItem.setState(TaskitemState.APPROVED.getCode());
        taskItem.setFinisher(StUserInfo.getUserCode());
        taskItem.setFinishTime(LocalDateTime.now());
        taskItem.setUpdateBy(StUserInfo.getUserCode());
        taskItem.setUpdateTime(LocalDateTime.now());
        this.taskItemService.updateStTaskitem(taskItem);
        List unPassTi = curStepTi.stream().filter(item -> item.getState().equals(0) || item.getState().equals(1)).collect(Collectors.toList());
        if (unPassTi.stream().count() == 1L) {
            step.setState(StepState.LEAVE.getCode());
            step.setApproval(StepApproval.PASS.getCode());
            step.setFinishTime(LocalDateTime.now());
            step.setUpdateBy(StUserInfo.getUserCode());
            step.setUpdateTime(LocalDateTime.now());
            this.stepService.updateStStep(step);
            instance.setState(InstanceState.RUNNING.getCode());
            this.coreBpmFlowAnalysis.analyzeThePathAndStartTheSteps(step.getNodeid(), instance);
        }
        this.instanceService.updateStInstance(instance);
        return errorMessage;
    }

    @Transactional
    @CacheProgram(action=ActionType.RETRIEVE)
    public StResult retrieveFlow(String instanceId, String taskItemId) {
        List generatedTasks;
        ArrayList<String> deleteTasIds = new ArrayList<String>();
        HashSet<Integer> deleteStepIds = new HashSet<Integer>();
        String theReasonCannotBeRetrieved = "";
        StTaskitem taskitem = this.taskItemService.getStTaskitem(taskItemId);
        if (!StUserInfo.getUserCode().equals(taskitem.getParticipant())) {
            theReasonCannotBeRetrieved = "\u53d6\u56de\u4eba\u4e0e\u63d0\u4ea4\u4eba\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u53d6\u56de";
        }
        if (!TaskitemState.APPROVED.getCode().equals(taskitem.getState())) {
            theReasonCannotBeRetrieved = "\u4efb\u52a1\u72b6\u6001\u4e0d\u662f\u5df2\u63d0\u4ea4\uff0c\u65e0\u6cd5\u53d6\u56de";
        }
        if ((generatedTasks = this.taskItemService.getTaskitemBySourceTaskId(taskItemId)).size() == 0) {
            theReasonCannotBeRetrieved = "\u4e0d\u5b58\u5728\u540e\u7eed\u5ba1\u6279\uff0c\u65e0\u6cd5\u53d6\u56de\u3002";
        }
        for (StTaskitem generatedTask : generatedTasks) {
            if (TaskitemState.CREATE.getCode().equals(generatedTask.getState()) || TaskitemState.VIEWED.getCode().equals(generatedTask.getState())) {
                deleteTasIds.add(generatedTask.getObjectid());
                deleteStepIds.add(generatedTask.getStepid());
                continue;
            }
            theReasonCannotBeRetrieved = "\u540e\u7eed\u8282\u70b9\u5df2\u88ab\u5904\u7406\uff0c\u65e0\u6cd5\u53d6\u56de\u3002";
            break;
        }
        if (theReasonCannotBeRetrieved.equals("") && deleteTasIds.size() > 0) {
            this.taskItemService.deleteTaskById(String.join((CharSequence)"','", deleteTasIds));
            this.stepService.deleteByStepid(instanceId, deleteStepIds.stream().map(String::valueOf).collect(Collectors.joining(",")));
            taskitem.setFinisher(null);
            taskitem.setState(Integer.valueOf(1));
            taskitem.setFinishTime(null);
            taskitem.setUpdateBy(StUserInfo.getUserCode());
            taskitem.setUpdateTime(LocalDateTime.now());
            this.taskItemService.updateStTaskitem(taskitem);
            StStep stStep = this.stepService.getStStep(instanceId, taskitem.getStepid());
            stStep.setState(Integer.valueOf(0));
            stStep.setApproval(Integer.valueOf(0));
            stStep.setFinishTime(null);
            this.stepService.updateStStep(stStep);
            this.logsUtils.addLogs(instanceId, taskitem, "\u53d6\u56de\u6d41\u7a0b");
            return StResult.success();
        }
        return StResult.error((StCodeMsg)StCodeMsg.NOT_FIND_DATA, (String)theReasonCannotBeRetrieved);
    }

    public void InitPersistAll(String flowCode, String bizObjectID) {
        this.formService.IstFormDataCache(flowCode, bizObjectID);
        this.formService.getStFormTemplate(flowCode, "");
        this.dataService.IstDataTemplateCache(flowCode);
    }

    public StFlowTemplate getStFlowTemplate(String flowCode, Integer flowVersion) {
        StFlowTemplate stFlowTemplate = this.flowTemplateMapper.getStFlowTemplate(flowCode, flowVersion);
        if (stFlowTemplate == null) {
            stFlowTemplate = new StFlowTemplate();
            stFlowTemplate.setFlowCode(flowCode);
            stFlowTemplate.setPublished(null);
            stFlowTemplate.setVersion(flowVersion);
            stFlowTemplate.setContent("{\n  \"cells\": [\n    {\n      \"position\": { \"x\": 560, \"y\": 290 },\n      \"size\": { \"width\": 180, \"height\": 47 },\n      \"attrs\": {\n        \"body\": { \"class\": \"rotating-node\" },\n        \"image\": {\n          \"xlink:href\": \"" + this.baseIconUrl + "/node_start.svg\"\n        },\n        \"title\": { \"refX\": \"50%\", \"textWrap\": { \"text\": \"\u5f00\u59cb\", \"width\": -55 } }\n      },\n      \"visible\": true,\n      \"shape\": \"flow-chart-image-rect\",\n      \"ports\": {\n        \"groups\": {\n          \"top\": {\n            \"position\": \"top\",\n            \"attrs\": {\n              \"circle\": {\n                \"r\": 3,\n                \"magnet\": true,\n                \"stroke\": \"#5F95FF\",\n                \"strokeWidth\": 1,\n                \"fill\": \"#fff\",\n                \"style\": { \"visibility\": \"hidden\" }\n              }\n            }\n          },\n          \"right\": {\n            \"position\": \"right\",\n            \"attrs\": {\n              \"circle\": {\n                \"r\": 3,\n                \"magnet\": true,\n                \"stroke\": \"#5F95FF\",\n                \"strokeWidth\": 1,\n                \"fill\": \"#fff\",\n                \"style\": { \"visibility\": \"hidden\" }\n              }\n            }\n          },\n          \"bottom\": {\n            \"position\": \"bottom\",\n            \"attrs\": {\n              \"circle\": {\n                \"r\": 3,\n                \"magnet\": true,\n                \"stroke\": \"#5F95FF\",\n                \"strokeWidth\": 1,\n                \"fill\": \"#fff\",\n                \"style\": { \"visibility\": \"hidden\" }\n              }\n            }\n          },\n          \"left\": {\n            \"position\": \"left\",\n            \"attrs\": {\n              \"circle\": {\n                \"r\": 3,\n                \"magnet\": true,\n                \"stroke\": \"#5F95FF\",\n                \"strokeWidth\": 1,\n                \"fill\": \"#fff\",\n                \"style\": { \"visibility\": \"hidden\" }\n              }\n            }\n          }\n        },\n        \"items\": [\n          { \"group\": \"top\", \"id\": \"" + StString.getUUID() + "\" },\n          { \"group\": \"right\", \"id\": \"" + StString.getUUID() + "\" },\n          { \"group\": \"bottom\", \"id\": \"" + StString.getUUID() + "\" },\n          { \"group\": \"left\", \"id\": \"" + StString.getUUID() + "\" }\n        ]\n      },\n      \"id\": \"" + StString.getUUID() + "\",\n      \"data\": {\n        \"code\": \"Task1\",\n        \"targetEdges\": [],\n        \"sourceEdges\": [],\n        \"nodeType\": \"0\"\n      },\n      \"zIndex\": 1\n    },\n    {\n      \"position\": { \"x\": 560, \"y\": 425 },\n      \"size\": { \"width\": 180, \"height\": 47 },\n      \"attrs\": {\n        \"image\": {\n          \"xlink:href\": \"" + this.baseIconUrl + "/node_fillin.svg\"\n        },\n        \"title\": { \"refX\": \"50%\", \"textWrap\": { \"text\": \"\u586b\u5199\" , \"width\": -55} }\n      },\n      \"visible\": true,\n      \"shape\": \"flow-chart-image-rect\",\n      \"ports\": {\n        \"groups\": {\n          \"top\": {\n            \"position\": \"top\",\n            \"attrs\": {\n              \"circle\": {\n                \"r\": 3,\n                \"magnet\": true,\n                \"stroke\": \"#5F95FF\",\n                \"strokeWidth\": 1,\n                \"fill\": \"#fff\",\n                \"style\": { \"visibility\": \"hidden\" }\n              }\n            }\n          },\n          \"right\": {\n            \"position\": \"right\",\n            \"attrs\": {\n              \"circle\": {\n                \"r\": 3,\n                \"magnet\": true,\n                \"stroke\": \"#5F95FF\",\n                \"strokeWidth\": 1,\n                \"fill\": \"#fff\",\n                \"style\": { \"visibility\": \"hidden\" }\n              }\n            }\n          },\n          \"bottom\": {\n            \"position\": \"bottom\",\n            \"attrs\": {\n              \"circle\": {\n                \"r\": 3,\n                \"magnet\": true,\n                \"stroke\": \"#5F95FF\",\n                \"strokeWidth\": 1,\n                \"fill\": \"#fff\",\n                \"style\": { \"visibility\": \"hidden\" }\n              }\n            }\n          },\n          \"left\": {\n            \"position\": \"left\",\n            \"attrs\": {\n              \"circle\": {\n                \"r\": 3,\n                \"magnet\": true,\n                \"stroke\": \"#5F95FF\",\n                \"strokeWidth\": 1,\n                \"fill\": \"#fff\",\n                \"style\": { \"visibility\": \"hidden\" }\n              }\n            }\n          }\n        },\n        \"items\": [\n          { \"group\": \"top\", \"id\": \"" + StString.getUUID() + "\" },\n          { \"group\": \"right\", \"id\": \"" + StString.getUUID() + "\" },\n          { \"group\": \"bottom\", \"id\": \"" + StString.getUUID() + "\" },\n          { \"group\": \"left\", \"id\": \"" + StString.getUUID() + "\" }\n        ]\n      },\n      \"id\": \"" + StString.getUUID() + "\",\n      \"data\": {\n        \"code\": \"Task2\",\n        \"targetEdges\": [],\n        \"sourceEdges\": [],\n        \"nodeType\": \"1\",\n        \"participants\": [],\n        \"dataPowerData\": []\n      },\n      \"zIndex\": 2\n    },\n    {\n      \"position\": { \"x\": 560, \"y\": 724 },\n      \"size\": { \"width\": 180, \"height\": 47 },\n      \"attrs\": {\n        \"image\": {\n          \"xlink:href\": \"" + this.baseIconUrl + "/node_end.svg\"\n        },\n        \"title\": { \"refX\": \"50%\", \"textWrap\": { \"text\": \"\u7ed3\u675f\" , \"width\": -55} }\n      },\n      \"visible\": true,\n      \"shape\": \"flow-chart-image-rect\",\n      \"ports\": {\n        \"groups\": {\n          \"top\": {\n            \"position\": \"top\",\n            \"attrs\": {\n              \"circle\": {\n                \"r\": 3,\n                \"magnet\": true,\n                \"stroke\": \"#5F95FF\",\n                \"strokeWidth\": 1,\n                \"fill\": \"#fff\",\n                \"style\": { \"visibility\": \"hidden\" }\n              }\n            }\n          },\n          \"right\": {\n            \"position\": \"right\",\n            \"attrs\": {\n              \"circle\": {\n                \"r\": 3,\n                \"magnet\": true,\n                \"stroke\": \"#5F95FF\",\n                \"strokeWidth\": 1,\n                \"fill\": \"#fff\",\n                \"style\": { \"visibility\": \"hidden\" }\n              }\n            }\n          },\n          \"bottom\": {\n            \"position\": \"bottom\",\n            \"attrs\": {\n              \"circle\": {\n                \"r\": 3,\n                \"magnet\": true,\n                \"stroke\": \"#5F95FF\",\n                \"strokeWidth\": 1,\n                \"fill\": \"#fff\",\n                \"style\": { \"visibility\": \"hidden\" }\n              }\n            }\n          },\n          \"left\": {\n            \"position\": \"left\",\n            \"attrs\": {\n              \"circle\": {\n                \"r\": 3,\n                \"magnet\": true,\n                \"stroke\": \"#5F95FF\",\n                \"strokeWidth\": 1,\n                \"fill\": \"#fff\",\n                \"style\": { \"visibility\": \"hidden\" }\n              }\n            }\n          }\n        },\n        \"items\": [\n          { \"group\": \"top\", \"id\": \"" + StString.getUUID() + "\" },\n          { \"group\": \"right\", \"id\": \"" + StString.getUUID() + "\" },\n          { \"group\": \"bottom\", \"id\": \"" + StString.getUUID() + "\" },\n          { \"group\": \"left\", \"id\": \"" + StString.getUUID() + "\" }\n        ]\n      },\n      \"id\": \"" + StString.getUUID() + "\",\n      \"data\": {\n        \"code\": \"Task3\",\n        \"targetEdges\": [],\n        \"sourceEdges\": [],\n        \"nodeType\": \"9\"\n      },\n      \"zIndex\": 3\n    }\n  ]\n}\n");
        }
        return stFlowTemplate;
    }

    public void addStFlowMenu(JSONObject params) throws Exception {
        StFlowMenu stFlowMenu = new StFlowMenu();
        String menuName = params.getString("menuName");
        String menuCode = params.getString("menuCode");
        String pFjm = params.getString("pFjm");
        String menuType = params.getString("menuType");
        int pId = params.getIntValue("pId");
        if (StString.isEmpty((String)menuName)) {
            throw new Exception("menuName\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StString.isEmpty((String)menuName)) {
            throw new Exception("menuCode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (pFjm.equals("")) {
            int maxFjm = this.menuService.getMaxFjm(4, "");
            DecimalFormat decimalFormat = new DecimalFormat("0000");
            stFlowMenu.setFjm(decimalFormat.format(maxFjm + 1));
            stFlowMenu.setParentId("0");
        } else {
            int maxFjm = this.menuService.getMaxFjm(pFjm.length() + 4, pFjm);
            DecimalFormat decimalFormat = new DecimalFormat("0000");
            stFlowMenu.setFjm(pFjm + decimalFormat.format(maxFjm + 1));
            stFlowMenu.setParentId(Integer.toString(pId));
        }
        stFlowMenu.setMenuType(menuType);
        stFlowMenu.setFlowName(menuName);
        stFlowMenu.setFlowCode(menuCode);
        stFlowMenu.setCreateBy(StUserInfo.getUserCode());
        stFlowMenu.setUpdateBy(StUserInfo.getUserCode());
        this.menuService.istStFlowMenu(stFlowMenu);
    }

    @CacheProgram(action=ActionType.PUBLISH_FLOW)
    public void istStFlowTemplate(String saveOrPublish, StFlowTemplate stFlowTemplate) {
        String content = stFlowTemplate.getContent();
        JSONObject jsonObject = JSONObject.parseObject((String)content);
        JSONArray cells = jsonObject.getJSONArray("cells");
        List lines = cells.stream().filter(f -> NodeType.LINE.getCode().equals(((JSONObject)f).getJSONObject("data").getString("nodeType"))).collect(Collectors.toList());
        for (Object cell : cells) {
            JSONObject cellObj = (JSONObject)cell;
            String nodeType = cellObj.getJSONObject("data").getString("nodeType");
            if (NodeType.LINE.getCode().equals(nodeType)) continue;
            String nodeId = cellObj.getString("id");
            ArrayList<String> targetEdges = new ArrayList<String>();
            ArrayList<String> sourceEdges = new ArrayList<String>();
            for (Object line : lines) {
                String targetCell;
                JSONObject lineObj = (JSONObject)line;
                String lineId = lineObj.getString("id");
                String sourceCell = lineObj.getJSONObject("source").getString("cell");
                if (sourceCell.equals(nodeId)) {
                    targetEdges.add(lineId);
                }
                if (!(targetCell = lineObj.getJSONObject("target").getString("cell")).equals(nodeId)) continue;
                sourceEdges.add(lineId);
            }
            JSONArray targetEdgesArray = cellObj.getJSONObject("data").getJSONArray("targetEdges");
            targetEdgesArray.clear();
            targetEdgesArray.addAll(targetEdges);
            JSONArray sourceEdgesArray = cellObj.getJSONObject("data").getJSONArray("sourceEdges");
            sourceEdgesArray.clear();
            sourceEdgesArray.addAll(sourceEdges);
        }
        stFlowTemplate.setContent(jsonObject.toJSONString());
        stFlowTemplate.setUpdateBy(StUserInfo.getUserCode());
        String flowCode = stFlowTemplate.getFlowCode();
        Map unPublish = this.flowTemplateMapper.getUnPublishID(flowCode);
        StFlowTemplate mostNew = this.flowTemplateMapper.getStFlowTemplate(flowCode, null);
        if (saveOrPublish.equals("0")) {
            stFlowTemplate.setPublished("0");
            if (unPublish == null) {
                if (stFlowTemplate.getVersion() == null) {
                    stFlowTemplate.setVersion(Integer.valueOf(1));
                }
                stFlowTemplate.setVersion(Integer.valueOf(stFlowTemplate.getVersion() + 1));
                if (mostNew != null) {
                    stFlowTemplate.setVersion(Integer.valueOf(mostNew.getVersion() + 1));
                } else {
                    stFlowTemplate.setVersion(Integer.valueOf(1));
                }
                stFlowTemplate.setCreateBy(StUserInfo.getUserCode());
                this.flowTemplateMapper.istStFlowTemplate(stFlowTemplate);
            } else {
                stFlowTemplate.setVersion(StConvert.toInt(unPublish.get("version")));
                stFlowTemplate.setId(StConvert.toInt(unPublish.get("id")));
                this.flowTemplateMapper.updateStFlowTemplate(stFlowTemplate);
            }
        } else {
            stFlowTemplate.setPublished("1");
            if (unPublish == null) {
                if (stFlowTemplate.getVersion() == null) {
                    stFlowTemplate.setVersion(Integer.valueOf(1));
                }
                stFlowTemplate.setVersion(Integer.valueOf(stFlowTemplate.getVersion() + 1));
                if (mostNew != null) {
                    stFlowTemplate.setVersion(Integer.valueOf(mostNew.getVersion() + 1));
                }
                stFlowTemplate.setCreateBy(StUserInfo.getUserCode());
                this.flowTemplateMapper.istStFlowTemplate(stFlowTemplate);
            } else {
                stFlowTemplate.setVersion(StConvert.toInt(unPublish.get("version")));
                stFlowTemplate.setId(StConvert.toInt(unPublish.get("id")));
                this.flowTemplateMapper.updateStFlowTemplate(stFlowTemplate);
            }
        }
    }

    @Transactional
    @CacheProgram(action=ActionType.SAVE)
    public StTaskitem Save(FlowEnteredParam flowEnteredParam, boolean targetSave) {
        StFlowMenu flowMenu;
        String bizObjectid = flowEnteredParam.getBizObjectid();
        StInstance instance = null;
        if (flowEnteredParam.getCodeModify().booleanValue()) {
            instance = this.getStInstanceByBizobjectid(bizObjectid);
            flowEnteredParam.setFlowVersion(instance.getFlowVersion());
            flowEnteredParam.setFlowCode(instance.getFlowCode());
        }
        String flowCode = flowEnteredParam.getFlowCode();
        Integer flowVersion = flowEnteredParam.getFlowVersion();
        try {
            instance = this.saveTableData(flowEnteredParam);
        }
        catch (Exception e) {
            throw new SaveDataException(e.getMessage());
        }
        if (flowEnteredParam.getCodeModify().booleanValue()) {
            return null;
        }
        String taskid = flowEnteredParam.getTaskid();
        if (instance == null) {
            flowMenu = this.menuService.getStFlowMenuByFlowCode(flowCode);
            instance = new StInstance();
            String instanceid = StString.getUUID();
            instance.setObjectid(instanceid);
            String sequenceNo = this.engineUtils.GetSequenceNo(flowCode, flowMenu);
            instance.setSequenceNo(sequenceNo);
            instance.setState(InstanceState.SAVED.getCode());
            instance.setOriginator(StUserInfo.getUserCode());
            instance.setFlowCode(flowCode);
            instance.setBizObjectid(bizObjectid);
            instance.setFlowVersion(flowVersion);
            instance.setCreateBy(StUserInfo.getUserCode());
            instance.setStartTime(LocalDateTime.now());
            instance.setCurStepid(Integer.valueOf(1));
            instance.setInstanceName(this.engineUtils.GetSequenceName(instance, flowMenu, flowEnteredParam));
            this.instanceService.istStInstance(instance);
            taskid = this.coreBpmFlowAnalysis.InitWriteNode(instance, 0, "");
        } else if (instance.getInstanceName() != null && instance.getInstanceName().contains("{") && instance.getInstanceName().contains("}")) {
            flowMenu = this.menuService.getStFlowMenuByFlowCode(instance.getFlowCode());
            instance.setInstanceName(this.engineUtils.GetSequenceName(instance, flowMenu, flowEnteredParam));
        }
        StTaskitem taskitem = this.taskItemService.getStTaskitem(taskid);
        return taskitem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StTaskitem autoSave(String flowCode, JSONObject tableData, String userCode) {
        try {
            StTaskitem stTaskitem;
            StUser user;
            if (StString.isNotEmpty((String)userCode) && (user = this.organizeService.getDeptManagerByUserCode(userCode)) != null) {
                StUserInfo.threadLocalValueUserCode.set(user.getUserCode());
                StUserInfo.threadLocalValueUserName.set(user.getUserName());
            }
            Integer flowVersion = this.flowTemplateMapper.getLastFlowVersion(flowCode);
            String bizObjectid = StString.getUUID();
            FlowEnteredParam flowEnteredParam = new FlowEnteredParam();
            flowEnteredParam.setFlowCode(flowCode);
            flowEnteredParam.setBizObjectid(bizObjectid);
            flowEnteredParam.setFlowVersion(flowVersion);
            flowEnteredParam.setTableData(JSONObject.toJSONString((Object)tableData));
            StTaskitem stTaskitem2 = stTaskitem = this.flowService.intermediarySave(flowEnteredParam);
            return stTaskitem2;
        }
        finally {
            StUserInfo.threadLocalValueUserCode.remove();
            StUserInfo.threadLocalValueUserName.remove();
        }
    }

    @CacheProgram(action=ActionType.AUTO_SAVE)
    public StTaskitem intermediarySave(FlowEnteredParam flowEnteredParam) {
        return this.flowService.Save(flowEnteredParam, true);
    }

    public StInstance saveTableData(FlowEnteredParam flowEnteredParam) {
        ArrayList childTableCode = new ArrayList();
        String childSql = "";
        JSONObject jsonObject = JSONObject.parseObject((String)flowEnteredParam.getTableData());
        String templateFieldKey = RedisKeys.getTemplateFieldData((String)flowEnteredParam.getFlowCode(), (String[])new String[0]);
        Map cacheMap = this.rd.getCacheMap(templateFieldKey);
        for (Map.Entry<String, Column> entry2 : cacheMap.entrySet()) {
            JSONArray jsonArray;
            if (!((Column)entry2.getValue()).getType().equals(DataType.CHILDREN.name())) continue;
            childTableCode.add(entry2.getKey());
            Object childObject = jsonObject.get(entry2.getKey());
            if (!(childObject instanceof JSONArray) || (jsonArray = (JSONArray)childObject) == null) continue;
            String tableName = "m_" + (String)entry2.getKey();
            List childList = this.commonMapper.getSqlStringList(this.sqlGenerator.getAllChildTable(tableName, flowEnteredParam.getBizObjectid()));
            Integer maxIndex = this.commonMapper.getSqlIntegerValue(this.sqlGenerator.getMaxSortIndex(tableName, flowEnteredParam.getBizObjectid()));
            ArrayList<JSONObject> insertChildData = new ArrayList<JSONObject>();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject childrenData = (JSONObject)jsonArray.get(i);
                if (!childrenData.containsKey((Object)"key")) {
                    childrenData.put("key", (Object)StString.getUUID());
                }
                String flow_id = childrenData.getString("key");
                if (childrenData.size() == 1) {
                    childList.remove(flow_id);
                    continue;
                }
                Stream<String> stringStream = childList.stream().filter(child -> child.equals(flow_id));
                if (stringStream.count() == 0L) {
                    childrenData.put("flow_parent_id", (Object)flowEnteredParam.getBizObjectid());
                    maxIndex = maxIndex + 1;
                    childrenData.put("sort_index", (Object)maxIndex);
                    insertChildData.add(childrenData);
                } else {
                    childrenData.remove((Object)"key");
                    childSql = this.sqlGenerator.getUpdateSql(tableName, childrenData, flow_id);
                    this.commonMapper.updateSql(childSql);
                }
                childList.remove(flow_id);
            }
            this.insertChildData(tableName, entry2, insertChildData);
            if (childList.size() <= 0) continue;
            childList.forEach(child -> this.commonMapper.deleteSql(this.sqlGenerator.getDeleteSql(tableName, child)));
        }
        StInstance stInstanceExist = this.instanceService.getStInstanceByBizobjectId(flowEnteredParam.getBizObjectid());
        String mainSql = "";
        JSONObject mainJsonObject = JSONObject.parseObject((String)flowEnteredParam.getTableData());
        childTableCode.forEach(entry -> mainJsonObject.remove(entry));
        mainSql = stInstanceExist != null ? this.sqlGenerator.getUpdateSql(flowEnteredParam.getTableName(), mainJsonObject, flowEnteredParam.getBizObjectid()) : this.sqlGenerator.getInsertSql(flowEnteredParam.getTableName(), mainJsonObject, flowEnteredParam.getBizObjectid());
        this.formService.updateSql(mainSql);
        return stInstanceExist;
    }

    public void insertChildData(String tableName, Map.Entry<String, Column> entry, List<JSONObject> insertChildData) {
        String userCode = StUserInfo.getUserCode();
        List<List<JSONObject>> lists = StFlowService.splitListIntoGroups(insertChildData);
        ArrayList completableFutures = new ArrayList();
        lists.forEach(list -> {
            CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(() -> {
                String childSql = this.sqlGenerator.getBatchInsertSql(tableName, userCode, ((Column)entry.getValue()).getChildren(), list);
                if (!StString.isEmpty((String)childSql) && childSql.length() > 10) {
                    this.commonMapper.insertSql(childSql);
                }
            }, (Executor)this.executor);
            completableFutures.add(completableFuture);
        });
        try {
            CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0])).get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException("\u5b50\u8868\u63d2\u5165\u5f02\u5e38\u2014\u2014CompletableFuture", cause);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("\u4e2d\u65ad\u2014\u2014interrupted", e);
        }
    }

    public static List<List<JSONObject>> splitListIntoGroups(List<JSONObject> originalList) {
        int groupSize = 100;
        ArrayList<List<JSONObject>> groupedLists = new ArrayList<List<JSONObject>>();
        for (int i = 0; i < originalList.size(); i += groupSize) {
            ArrayList<JSONObject> group = new ArrayList<JSONObject>();
            for (int j = i; j < Math.min(i + groupSize, originalList.size()); ++j) {
                group.add(originalList.get(j));
            }
            groupedLists.add(group);
        }
        return groupedLists;
    }

    public void updateStInstance(StInstance instance) {
        this.instanceService.updateStInstance(instance);
    }

    @Transactional
    @CacheProgram(action=ActionType.REJECT)
    public String RejectToStart(FlowEnteredParam flowEnteredParam) {
        StTaskitem taskItem = this.getStTaskitem(flowEnteredParam.getTaskid());
        if (!(taskItem.getState().equals(TaskitemState.CREATE.getCode()) || taskItem.getState().equals(TaskitemState.VIEWED.getCode()))) {
            return null;
        }
        if (taskItem == null) {
            throw new Exception("\u672a\u83b7\u53d6\u5230\u5f53\u524d\u4efb\u52a1\u3002");
        }
        String errorMsg = this.checkUtils.IsCanReject(taskItem);
        if (!errorMsg.equals("")) {
            throw new Exception(errorMsg);
        }
        StInstance instance = this.getStInstance(taskItem.getInstanceid());
        StStep step = this.stepService.getStStep(taskItem.getInstanceid(), taskItem.getStepid());
        this.tableFieldProcessForRejection(instance, taskItem, step, flowEnteredParam.getComment());
        List curStepTaskItem = this.taskItemService.getCurStepStTaskitem(instance.getObjectid(), taskItem.getStepid());
        List unDealTaskItem = curStepTaskItem.stream().filter(taskitem -> taskitem.getState().equals(TaskitemState.CREATE.getCode()) || taskitem.getState().equals(TaskitemState.VIEWED.getCode())).collect(Collectors.toList());
        for (StTaskitem stTaskitem : unDealTaskItem) {
            stTaskitem.setState(TaskitemState.CANCEL.getCode());
            this.taskItemService.updateStTaskitem(stTaskitem);
        }
        this.coreBpmFlowAnalysis.overTargetTask(instance.getObjectid(), false);
        Integer maxStepId = this.stepService.getMaxStepId(instance.getObjectid());
        flowEnteredParam.setTaskid(this.coreBpmFlowAnalysis.InitWriteNode(instance, maxStepId, taskItem.getOriginator()));
        return flowEnteredParam.getTaskid();
    }

    public void tableFieldProcessForRejection(StInstance instance, StTaskitem taskItem, StStep step, String comment) {
        StComment stComment = new StComment(taskItem.getBizObjectid(), taskItem.getInstanceid(), taskItem.getObjectid(), StUserInfo.getUserCode(), comment, Integer.valueOf(-1));
        this.commentMapper.istStComment(stComment);
        instance.setUpdateBy(StUserInfo.getUserCode());
        instance.setLastActiveTime(LocalDateTime.now());
        instance.setState(InstanceState.REJECT.getCode());
        this.instanceService.updateStInstance(instance);
        taskItem.setState(TaskitemState.REJECT.getCode());
        taskItem.setFinisher(StUserInfo.getUserCode());
        taskItem.setFinishTime(LocalDateTime.now());
        taskItem.setUpdateBy(StUserInfo.getUserCode());
        taskItem.setUpdateTime(LocalDateTime.now());
        this.taskItemService.updateStTaskitem(taskItem);
        step.setState(StepState.LEAVE.getCode());
        step.setApproval(StepApproval.REJECT.getCode());
        step.setFinishTime(LocalDateTime.now());
        step.setUpdateBy(StUserInfo.getUserCode());
        step.setUpdateTime(LocalDateTime.now());
        this.stepService.updateStStep(step);
    }

    @Transactional
    public String handleTurnOne(FlowEnteredParam flowEnteredParam) {
        StTaskitem taskItem = this.getStTaskitem(flowEnteredParam.getTaskid());
        this.logsUtils.addLogs(null, taskItem, "\u8f6c\u53d1\u7ed9" + flowEnteredParam.getTargetUserCode());
        taskItem.setParticipant(flowEnteredParam.getTargetUserCode());
        taskItem.setState(TaskitemState.CREATE.getCode());
        taskItem.setUpdateBy(StUserInfo.getUserCode());
        taskItem.setUpdateTime(LocalDateTime.now());
        taskItem.setForwarder(StUserInfo.getUserCode());
        this.taskItemService.updateStTaskitem(taskItem);
        return "success";
    }

    @Transactional
    public String handleAddOne(FlowEnteredParam flowEnteredParam) {
        StTaskitem taskItem = this.getStTaskitem(flowEnteredParam.getTaskid());
        this.logsUtils.addLogs(null, taskItem, "\u52a0\u7b7e" + flowEnteredParam.getTargetUserCode());
        taskItem.setObjectid(StString.getUUID());
        taskItem.setParticipant(flowEnteredParam.getTargetUserCode());
        taskItem.setFinisher("");
        taskItem.setState(TaskitemState.CREATE.getCode());
        taskItem.setReceiveTime(LocalDateTime.now());
        taskItem.setStartTime(LocalDateTime.now());
        taskItem.setForwarder(StUserInfo.getUserCode());
        taskItem.setItemType(NodeType.AUDIT.getCode());
        this.istStTaskitem(taskItem);
        return "success";
    }

    @Transactional
    public String handleCirculated(FlowEnteredParam flowEnteredParam) {
        StTaskitem taskItem = this.getStTaskitem(flowEnteredParam.getTaskid());
        this.logsUtils.addLogs(null, taskItem, "\u4f20\u9605\u7ed9" + flowEnteredParam.getTargetUserCode());
        taskItem.setObjectid(StString.getUUID());
        taskItem.setParticipant(flowEnteredParam.getTargetUserCode());
        taskItem.setFinisher("");
        taskItem.setState(TaskitemState.CREATE.getCode());
        taskItem.setReceiveTime(LocalDateTime.now());
        taskItem.setStartTime(LocalDateTime.now());
        taskItem.setForwarder(StUserInfo.getUserCode());
        taskItem.setItemType(NodeType.CIRCULATE.getCode());
        this.istStTaskitem(taskItem);
        return "success";
    }

    public JSONObject ViewProcess(String instanceid) {
        return this.coreBpmFlowAnalysis.SimulateFlowTemplate(instanceid);
    }

    public List<ViewList> ViewProcessList(String instanceid) {
        try {
            String viewListKey = RedisKeys.getViewList((String)instanceid, (String[])new String[0]);
            this.rd.deleteObject(viewListKey);
            this.coreBpmFlowAnalysis.SimulateFlowTemplate(instanceid);
            List<ViewList> cacheList = this.rd.getCacheList(viewListKey);
            StInstance stInstance = this.getStInstance(instanceid);
            Integer curStepid = stInstance.getCurStepid();
            if (curStepid != null) {
                for (ViewList viewList : cacheList) {
                    if (viewList.getStep() == null || curStepid.compareTo(viewList.getStep()) != 0) continue;
                    String taskCode = this.getInstanceCurNodeCode(instanceid);
                    viewList.setTaskCode(taskCode);
                    viewList.setCurrentApprovalNode(true);
                }
            }
            List lastApprovalInformation = this.taskItemService.getLastApprovalInformation(instanceid);
            Map<Integer, List<ViewListPassed>> groupedByStepId = lastApprovalInformation.stream().collect(Collectors.groupingBy(ViewListPassed::getStepid));
            for (Map.Entry<Integer, List<ViewListPassed>> entry : groupedByStepId.entrySet()) {
                Integer stepId = entry.getKey();
                List<ViewListPassed> list = entry.getValue();
                ViewList viewList = new ViewList();
                cacheList.add(viewList);
                viewList.setNodeName(list.get(0).getNodeName());
                viewList.setStep(stepId);
                if (curStepid.compareTo(viewList.getStep()) == 0) {
                    viewList.setCurrentApprovalNode(true);
                }
                viewList.setFinish(true);
                viewList.setSystemTime(Long.valueOf(System.nanoTime()));
                ArrayList<ViewListParticipant> participants = new ArrayList<ViewListParticipant>();
                viewList.setParticipants(participants);
                for (ViewListPassed viewListPassed : list) {
                    ViewListParticipant viewListParticipant = new ViewListParticipant();
                    StUser stUser = (StUser)this.rd.getCacheMapValue(RedisKeys.getUserByCode((String[])new String[0]), viewListPassed.getParticipant());
                    if (stUser == null) continue;
                    participants.add(viewListParticipant);
                    viewListParticipant.setParticipant(stUser);
                    if (TaskitemState.APPROVED.getCode().equals(viewListPassed.getState())) {
                        viewListParticipant.setFinish(true);
                        continue;
                    }
                    viewListParticipant.setFinish(false);
                }
            }
            cacheList = cacheList.stream().filter(f -> f.getStep() != null).sorted(Comparator.comparing(ViewList::getStep)).collect(Collectors.toList());
            for (ViewList viewList : cacheList) {
                if (viewList.getParticipants() == null) continue;
                viewList.setParticipants(viewList.getParticipants().stream().sorted(Comparator.comparingInt(s -> StConvert.toInt((Object)s.getParticipant().getSortId(), (Integer)9999))).collect(Collectors.toList()));
            }
            this.rd.deleteObject(viewListKey);
            return cacheList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<ViewList>();
        }
    }

    public String getInstanceCurNodeCode(String instanceid) {
        return this.stepService.getInstanceCurNodeCode(instanceid);
    }

    public List<StStep> getStepByInstanceid(String instanceid) {
        return this.stepService.getStepByInstanceid(instanceid);
    }

    public List<StTaskitem> getCurStepStTaskitem(String instanceid, Integer stepid) {
        return this.taskItemService.getCurStepStTaskitem(instanceid, stepid);
    }

    public String getGetSequenceNo(String flowCode) {
        return this.instanceService.getGetSequenceNo(flowCode);
    }

    public StInstance getStInstance(String objectid) {
        StInstance instance = this.instanceService.getStInstance(objectid);
        return instance;
    }

    public StInstance getStInstanceByBizobjectid(String bizobjectid) {
        StInstance instance = this.instanceService.getStInstanceByBizobjectId(bizobjectid);
        return instance;
    }

    public StInstanceBase getInsMainByTaskItemId(String taskItemId) {
        StTaskitem taskitem = this.taskItemService.getStTaskitem(taskItemId);
        StInstance instance = this.getStInstance(taskitem.getInstanceid());
        return new StInstanceBase(taskitem.getInstanceid(), taskitem.getBizObjectid(), taskitem.getFlowVersion(), taskitem.getFlowCode(), instance.getState());
    }

    public StTaskitem getStTaskitem(String objectid) {
        StTaskitem taskitem = this.taskItemService.getStTaskitem(objectid);
        return taskitem;
    }

    public void istStTaskitem(StTaskitem stTaskitem) {
        if (!"Task2".equals(stTaskitem.getActivityCode()) && NodeType.AUDIT.getCode().equals(stTaskitem.getItemType())) {
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)lambdaQueryWrapper.eq(StTaskAgent::getUserCode, (Object)stTaskitem.getParticipant())).ge(StTaskAgent::getAgentEndTime, (Object)LocalDateTime.now())).le(StTaskAgent::getAgentBeginTime, (Object)LocalDateTime.now())).orderByDesc(StTaskAgent::getCreateTime);
            List stTaskAgents = this.taskAgentMapper.selectList((Wrapper)lambdaQueryWrapper);
            if (stTaskAgents != null && stTaskAgents.size() > 0) {
                StTaskAgent stTaskAgent = (StTaskAgent)stTaskAgents.get(0);
                boolean needSetAgent = false;
                if (StString.isEmpty((String)stTaskAgent.getFlowCodeInclude())) {
                    needSetAgent = true;
                } else {
                    List flowCodes = JSON.parseArray((String)stTaskAgent.getFlowCodeInclude(), String.class);
                    needSetAgent = flowCodes.contains(stTaskitem.getFlowCode());
                }
                if (needSetAgent) {
                    stTaskitem.setParticipant(stTaskAgent.getAgentUserCode());
                    stTaskitem.setDelegent(stTaskAgent.getUserCode());
                }
            }
        }
        this.taskItemService.istStTaskitem(stTaskitem);
    }

    public void istStStep(StStep stStep) {
        this.stepService.istStStep(stStep);
    }

    public ViewFormTop getStViewFormTop(String instanceid) {
        StInstance instance = this.instanceService.getStInstance(instanceid);
        ViewFormTop viewFormTop = new ViewFormTop();
        viewFormTop.setInstanceName(instance.getInstanceName());
        viewFormTop.setSequenceNo(instance.getSequenceNo());
        StUser stUser = this.organizeService.GetUserByCode(instance.getOriginator());
        if (stUser != null) {
            viewFormTop.setOriginator(stUser.getUserName());
        }
        StFlowMenu flowMenu = this.menuService.getStFlowMenuByFlowCode(instance.getFlowCode());
        viewFormTop.setFlowModel(flowMenu.getFlowName() + "(\u7248\u672c\uff1a" + instance.getFlowVersion() + ")");
        if (instance.getExceptional() != null && instance.getExceptional() == 1) {
            viewFormTop.setState("\u6d41\u7a0b\u53d1\u751f\u5f02\u5e38");
        } else {
            viewFormTop.setState(InstanceState.getInfoByCode((Integer)instance.getState()));
        }
        viewFormTop.setStartTime(instance.getStartTime());
        viewFormTop.setFinishTime(instance.getFinishTime());
        List taskitemList = this.taskItemService.getTaskItemByInstanceId(instanceid);
        Map<Integer, List<StTaskitem>> groupedTasks = taskitemList.stream().filter(task -> TaskitemState.CREATE.getCode().equals(task.getState()) || TaskitemState.VIEWED.getCode().equals(task.getState())).collect(Collectors.groupingBy(task -> task.getStepid()));
        JSONArray tasks = new JSONArray();
        groupedTasks.forEach((Key2, value) -> {
            JSONObject jsonObject = new JSONObject();
            tasks.add((Object)jsonObject);
            List<String> participantCodes = value.stream().map(StTaskitem::getParticipant).collect(Collectors.toList());
            ArrayList participants = new ArrayList();
            participantCodes.forEach(p -> {
                StUser user = this.organizeService.GetUserByCode(p);
                if (user != null) {
                    participants.add(user.getUserName());
                }
            });
            jsonObject.put("activityName", (Object)((StTaskitem)value.get(0)).getActivityName());
            jsonObject.put("participants", participants);
        });
        viewFormTop.setTaskList(tasks);
        return viewFormTop;
    }

    public JSONObject getStTaskItemList(String instanceid) {
        JSONObject jsonObject = new JSONObject();
        StInstance stInstance = this.instanceService.getStInstance(instanceid);
        List list = this.taskItemService.getStTaskitemListByInstanceid(instanceid);
        for (TaskItemDisplay taskItemDisplay : list) {
            StUser stUser;
            taskItemDisplay.setStateDisplay(TaskitemState.getInfoByCode((Integer)taskItemDisplay.getState()));
            if (taskItemDisplay.getFinishTime() != null && taskItemDisplay.getReceiveTime() != null) {
                Duration duration = Duration.between(taskItemDisplay.getReceiveTime(), taskItemDisplay.getFinishTime());
                long hours = duration.toHours();
                long minutes = duration.toMinutes() - hours * 60L;
                long seconds = duration.getSeconds() - (minutes * 60L + hours * 3600L);
                if (hours > 0L) {
                    taskItemDisplay.setUseTime(String.format("%d\u5c0f\u65f6 %02d\u5206\u949f %02d\u79d2%n", hours, minutes, seconds));
                } else if (minutes > 0L) {
                    taskItemDisplay.setUseTime(String.format("%02d\u5206\u949f %02d\u79d2%n", minutes, seconds));
                } else if (seconds > 0L) {
                    taskItemDisplay.setUseTime(String.format("%02d\u79d2%n", seconds));
                } else {
                    taskItemDisplay.setUseTime("-");
                }
            } else {
                taskItemDisplay.setUseTime("-");
            }
            if (StString.isNotEmpty((String)taskItemDisplay.getDelegent()) && (stUser = this.organizeService.GetUserByCode(taskItemDisplay.getDelegent())) != null && StString.isNotEmpty((String)taskItemDisplay.getParticipant())) {
                taskItemDisplay.setParticipant(taskItemDisplay.getParticipant() + "(\u59d4\u6258\u4eba\uff1a" + stUser.getUserName() + ")");
            }
            if (!StString.isNotEmpty((String)taskItemDisplay.getForwarder()) || (stUser = this.organizeService.GetUserByCode(taskItemDisplay.getForwarder())) == null || !StString.isNotEmpty((String)taskItemDisplay.getParticipant())) continue;
            taskItemDisplay.setParticipant(taskItemDisplay.getParticipant() + "(" + stUser.getUserName() + ")");
        }
        jsonObject.put("instance", (Object)stInstance);
        jsonObject.put("taskList", (Object)list);
        return jsonObject;
    }

    public List<String> getParticipantPassed(String instanceid) {
        return this.taskItemService.getParticipantPassed(instanceid);
    }

    public void IstStTaskItem(Integer autoPass, String part, StInstance instance, ActivityNode an, Integer ... stepIdAndStateId) {
        StTaskitem taskItem = StTaskitemBuilder.newBuilder().withOriginator(instance.getOriginator()).withParticipant(part).withFlowCode(instance.getFlowCode()).withFlowVersion(instance.getFlowVersion()).withActivityCode(an.getCode()).withActivityName(an.getName()).withInstanceid(instance.getObjectid()).withBizObjectid(instance.getBizObjectid()).withStepid(stepIdAndStateId[0]).withItemType(an.getNodeType()).build();
        taskItem.setAutoPass(autoPass);
        if (stepIdAndStateId.length == 2) {
            taskItem.setState(stepIdAndStateId[1]);
            if (TaskitemState.APPROVED.getCode().equals(stepIdAndStateId[1])) {
                taskItem.setFinishTime(taskItem.getStartTime());
                taskItem.setFinisher("admin");
            }
        }
        taskItem.setSourceTaskId(RequestContextHolder.getTaskBeingManipulatedId());
        this.istStTaskitem(taskItem);
    }

    public List<Map> getFlowTemplateHistory(String flowCode) {
        List historyPublished = this.flowTemplateMapper.getHistoryPublished(flowCode);
        if (historyPublished.size() > 0) {
            Map map = (Map)historyPublished.get(0);
            map.put("version", map.get("version").toString() + "(\u5f53\u524d)");
        }
        return historyPublished;
    }

    @CacheProgram(action=ActionType.EXCEPTION)
    public void updateFlowException(Long id, String instanceId) {
        StFlowExceptional flowExceptional;
        if (id != 0L && (flowExceptional = (StFlowExceptional)this.flowExceptionalMapper.selectById((Serializable)id)) != null) {
            flowExceptional.setState("1");
            flowExceptional.setUpdateBy(StUserInfo.getUserCode());
            flowExceptional.setUpdateTime(LocalDateTime.now());
            this.flowExceptionalMapper.updateById((Object)flowExceptional);
        }
        StInstance instance = this.getStInstance(instanceId);
        instance.setExceptional(Integer.valueOf(0));
        this.updateStInstance(instance);
    }

    public String getExportData(String flowCode) {
        ExportData exportData = new ExportData();
        StDataTemplate stDataTemplate = this.stDataTemplateMapper.getStDataTemplate(flowCode);
        exportData.setDataTemplate(stDataTemplate);
        StFlowTemplate stFlowTemplate = this.flowTemplateMapper.getStFlowTemplate(flowCode, this.flowTemplateMapper.getLastFlowVersion(flowCode));
        exportData.setFlowTemplate(stFlowTemplate);
        StFormTemplate stFormTemplatePc = this.stFormTemplateMapper.getStFormTemplate(flowCode, "");
        StFormTemplate stFormTemplateMobile = this.stFormTemplateMapper.getStFormTemplate(flowCode, "isMobile");
        exportData.setFormTemplatePc(stFormTemplatePc);
        exportData.setFormTemplateMobile(stFormTemplateMobile);
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(StEventAdditive::getFlowCode, (Object)flowCode);
        List stEventAdditives = this.stEventAdditiveMapper.selectList((Wrapper)lambdaQueryWrapper);
        exportData.setEventAdditives(stEventAdditives);
        StFlowMenu stFlowMenuByFlowCode = this.stFlowMenuMapper.getStFlowMenuByFlowCode(flowCode);
        exportData.setFlowCode(flowCode);
        exportData.setFlowName(stFlowMenuByFlowCode.getFlowName());
        exportData.setExportTime(LocalDateTime.now());
        exportData.setFlowMenu(stFlowMenuByFlowCode);
        List scriptByFlowCode = this.stFormTemplateMapper.getScriptByFlowCode(flowCode);
        exportData.setScripts(scriptByFlowCode);
        return JSON.toJSONString((Object)exportData);
    }

    @Transactional
    public StResult importData(MultipartFile file) {
        StringBuilder contentBuilder = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(file.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                contentBuilder.append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return StResult.error((StCodeMsg)StCodeMsg.SERVER_EXCEPTION, (String)e.getMessage());
        }
        StringBuilder result = new StringBuilder();
        try {
            ExportData exportData = (ExportData)JSON.parseObject((String)contentBuilder.toString(), ExportData.class);
            String flowCode = exportData.getFlowCode();
            StFlowMenu importFlowMenu = exportData.getFlowMenu();
            StFlowMenu existFlowMenu = this.stFlowMenuMapper.getStFlowMenuByFlowCode(flowCode);
            if (existFlowMenu == null) {
                this.stFlowMenuMapper.istStFlowMenu(importFlowMenu);
                result.append("1\u3001\u662f\u65b0\u6d41\u7a0b\uff0c\u63d2\u5165\u6d41\u7a0b\u83dc\u5355\u6210\u529f\n");
            }
            this.stFlowMenuMapper.updateStFlowMenuByFlowCode(importFlowMenu);
            result.append("1\u3001\u66f4\u65b0\u6d41\u7a0b\u83dc\u5355\u4fe1\u606f\u6210\u529f\n");
            Integer existMobile = this.stFormTemplateMapper.existStFormTemplate(flowCode, "mobile");
            Integer existPc = this.stFormTemplateMapper.existStFormTemplate(flowCode, "");
            StFormTemplate stFormTemplatePc = exportData.getFormTemplatePc();
            StFormTemplate stFormTemplateMobile = exportData.getFormTemplateMobile();
            if (existPc != 0) {
                if (stFormTemplatePc != null) {
                    this.stFormTemplateMapper.updateStFormTemplate(stFormTemplatePc);
                    result.append("2\u3001\u66f4\u65b0\u6d41\u7a0b\u8868\u5355PC\u6210\u529f\n");
                } else {
                    result.append("2\u3001\u66f4\u65b0\u6d41\u7a0b\u8868\u5355PC\u5931\u8d25,\u5bfc\u5165\u6570\u636e\u4e2d\u4e0d\u5b58\u5728\u76f8\u5173\u4fe1\u606f\n");
                }
            } else if (stFormTemplatePc != null) {
                this.stFormTemplateMapper.istStFormTemplate(stFormTemplatePc);
                result.append("2\u3001\u63d2\u5165\u6d41\u7a0b\u8868\u5355PC\u6210\u529f\n");
            } else {
                result.append("2\u3001\u66f4\u65b0\u6d41\u7a0b\u8868\u5355PC\u5931\u8d25,\u5bfc\u5165\u6570\u636e\u4e2d\u4e0d\u5b58\u5728\u76f8\u5173\u4fe1\u606f\n");
            }
            if (existMobile != 0) {
                if (stFormTemplateMobile != null) {
                    this.stFormTemplateMapper.updateStFormTemplate(stFormTemplateMobile);
                    result.append("3\u3001\u66f4\u65b0\u6d41\u7a0b\u8868\u5355\u79fb\u52a8\u7aef\u6210\u529f\n");
                } else {
                    result.append("3\u3001\u66f4\u65b0\u6d41\u7a0b\u8868\u5355\u79fb\u52a8\u7aef\u5931\u8d25,\u5bfc\u5165\u6570\u636e\u4e2d\u4e0d\u5b58\u5728\u76f8\u5173\u4fe1\u606f\n");
                }
            } else if (stFormTemplateMobile != null) {
                this.stFormTemplateMapper.istStFormTemplate(stFormTemplateMobile);
                result.append("2\u3001\u63d2\u5165\u6d41\u7a0b\u8868\u5355\u79fb\u52a8\u7aef\u6210\u529f\n");
            } else {
                result.append("3\u3001\u66f4\u65b0\u6d41\u7a0b\u8868\u5355\u79fb\u52a8\u7aef\u5931\u8d25,\u5bfc\u5165\u6570\u636e\u4e2d\u4e0d\u5b58\u5728\u76f8\u5173\u4fe1\u606f\n");
            }
            List<StEventAdditive> stEventAdditives = exportData.getEventAdditives();
            for (StEventAdditive stEventAdditive : stEventAdditives) {
                this.stEventAdditiveMapper.deleteById((Serializable)stEventAdditive.getId());
                this.stEventAdditiveMapper.insert((Object)stEventAdditive);
            }
            result.append("4\u3001\u5220\u9664\u5e76\u65b0\u589e\u4e1a\u52a1\u52a8\u4f5c\u3010" + stEventAdditives.size() + "\u6761\u3011\n");
            List<StScript> scripts = exportData.getScripts();
            for (StScript script : scripts) {
                this.stFormTemplateMapper.deleteAndInsertScript(script);
            }
            result.append("5\u3001\u5220\u9664\u5e76\u65b0\u589e\u811a\u672c\u3010" + scripts.size() + "\u6761\u3011\n");
            StFlowTemplate stFlowTemplate = exportData.getFlowTemplate();
            Integer lastFlowVersion = this.flowTemplateMapper.getLastFlowVersion(flowCode);
            if (lastFlowVersion == null || lastFlowVersion.compareTo(stFlowTemplate.getVersion()) < 0) {
                this.flowTemplateMapper.istStFlowTemplate(stFlowTemplate);
                this.admitService.istInitOneAdmit(flowCode);
                result.append("6\u3001\u63d2\u5165\u6d41\u7a0b\u6a21\u578b\u6210\u529f\u3010\u5f53\u524d\u7248\u672c\uff1a" + lastFlowVersion + "\u3011\u3010\u65b0\u7248\u672c\uff1a" + stFlowTemplate.getVersion() + "\u3011\n");
            } else {
                result.append("6\u3001\u66f4\u65b0\u6d41\u7a0b\u6a21\u578b\u5931\u8d25\uff01\u3010\u5f53\u524d\u7248\u672c\uff1a" + (lastFlowVersion == null ? "\u65e0" : lastFlowVersion.toString()) + "\u3011\u3010\u5bfc\u5165\u7248\u672c\uff1a" + stFlowTemplate.getVersion() + "\u3011\n");
                result.append("\uff08\u7531\u4e8e\u5bfc\u5165\u7684\u6d41\u7a0b\u6a21\u578b\u5c0f\u4e8e\u5f53\u524d\u7248\u672c\uff0c\u5bfc\u81f4\u5931\u8d25\uff09\n");
            }
            StDataTemplate importDataTemplate = exportData.getDataTemplate();
            StDataTemplate curDataTemplate = this.stDataTemplateMapper.getStDataTemplate(flowCode);
            if (curDataTemplate == null) {
                curDataTemplate = (StDataTemplate)JSONObject.parseObject((String)JSON.toJSONString((Object)importDataTemplate), StDataTemplate.class);
                curDataTemplate.setContent("[]");
                curDataTemplate.setColumns(new ArrayList());
                this.commonMapper.executeSql(this.sqlGenerator.createTableStatement(curDataTemplate.getTableName(), new ArrayList()));
                this.stDataTemplateMapper.istStDataTemplate(importDataTemplate);
                result.append("7\u3001\u6ca1\u6709\u6570\u636e\u6a21\u578b\uff0c\u521b\u5efa\u6570\u636e\u6a21\u578b\u4e3b\u4f53\u6210\u529f\n");
            } else {
                importDataTemplate.setUpdateBy(StUserInfo.getUserCode());
                this.stDataTemplateMapper.updateStDataTemplate(importDataTemplate);
            }
            List curDatas = JSON.parseArray((String)curDataTemplate.getContent(), Column.class);
            List importDatas = JSON.parseArray((String)importDataTemplate.getContent(), Column.class);
            importDatas = importDatas.stream().filter(f -> "1".equals(f.getPublish())).collect(Collectors.toList());
            HashMap absenceColumns = new HashMap();
            for (Column importData : importDatas) {
                Column targetDataTemplate;
                if (DataType.CHILDREN.name().equals(importData.getType())) {
                    String childTableName = "m_" + importData.getCode();
                    String exist = this.commonMapper.executeSqlString(this.sqlGenerator.checkWhetherTableExists(childTableName));
                    if (exist != null && exist.equals("1")) {
                        List childImportData = importData.getChildren();
                        for (Column childImportDatum : childImportData) {
                            Column childTargetDataTemplate;
                            Column childColum;
                            if (!"1".equals(childImportDatum.getPublish()) || (childColum = (Column)curDatas.stream().filter(f -> f.getCode().equals(importData.getCode())).findFirst().orElse(null)) == null || childColum.getChildren() == null || childColum.getChildren().size() <= 0 || (childTargetDataTemplate = (Column)childColum.getChildren().stream().filter(f -> !f.getType().equals(DataType.CHILDREN.name()) && "1".equals(f.getPublish()) && childImportDatum.getCode().equals(f.getCode())).findFirst().orElse(null)) != null) continue;
                            if (absenceColumns.containsKey(childTableName)) {
                                ((List)absenceColumns.get(childTableName)).add(childImportDatum);
                                continue;
                            }
                            ArrayList<Column> columns = new ArrayList<Column>();
                            columns.add(childImportDatum);
                            absenceColumns.put(childTableName, columns);
                        }
                        continue;
                    }
                    this.commonMapper.executeSql(this.sqlGenerator.createTableStatement(childTableName, importData.getChildren()));
                    continue;
                }
                if (!"1".equals(importData.getPublish()) || (targetDataTemplate = (Column)curDatas.stream().filter(f -> !f.getType().equals(DataType.CHILDREN.name()) && "1".equals(f.getPublish()) && importData.getCode().equals(f.getCode())).findFirst().orElse(null)) != null) continue;
                if (absenceColumns.containsKey(importDataTemplate.getTableName())) {
                    ((List)absenceColumns.get(importDataTemplate.getTableName())).add(importData);
                    continue;
                }
                ArrayList<Column> columns = new ArrayList<Column>();
                columns.add(importData);
                absenceColumns.put(importDataTemplate.getTableName(), columns);
            }
            for (String tableName : absenceColumns.keySet()) {
                this.commonMapper.executeSql(this.sqlGenerator.generateAddColumnSQL(tableName, (List)absenceColumns.get(tableName)));
            }
            result.append("7\u3001\u66f4\u65b0\u6570\u636e\u6a21\u578b\u6210\u529f\n");
            this.rd.deleteKeysWithPrefix("st*" + flowCode);
            result.append("8\u3001\u7f13\u5b58\u4fe1\u606f\u66f4\u65b0\u6210\u529f\n");
            return StResult.success((Object)result.toString());
        }
        catch (Exception e) {
            return StResult.error((StCodeMsg)StCodeMsg.SERVER_EXCEPTION, (String)(result.toString() + e.getMessage()));
        }
    }
}

