/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.sa.flow.engine.engine.workflow.strategies;

import com.alibaba.fastjson.JSONObject;
import com.cloud.sa.flow.commom.common.redis.StRedisCache;
import com.cloud.sa.flow.commom.domain.common.RedisKeys;
import com.cloud.sa.flow.commom.domain.entity.StInstance;
import com.cloud.sa.flow.commom.domain.entity.StInstanceBase;
import com.cloud.sa.flow.commom.domain.entity.StStep;
import com.cloud.sa.flow.commom.domain.entity.StTaskitem;
import com.cloud.sa.flow.commom.domain.virentity.ActivityNode;
import com.cloud.sa.flow.commom.domain.virenum.StepState;
import com.cloud.sa.flow.commom.service.flow.StTaskItemService;
import com.cloud.sa.flow.engine.engine.action.strategies.ViewFlowAction;
import com.cloud.sa.flow.engine.engine.coreface.CoreBpmFlowAnalysisInterface;
import com.cloud.sa.flow.engine.engine.workflow.NodeStrategy;
import com.cloud.sa.flow.engine.service.StFlowService;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServiceTaskNodeStrategy
extends NodeStrategy {
    @Autowired
    CoreBpmFlowAnalysisInterface coreBpmFlowAnalysis;
    @Autowired
    StRedisCache rd;
    @Autowired
    ViewFlowAction action;
    @Autowired
    StTaskItemService taskItemService;
    @Autowired
    StFlowService flowService;

    @Override
    public void cacheColor(JSONObject joData, StStep step, StInstance stInstance, String nodeId) {
        this.cacheNodeTemplateValue(joData, step, stInstance, nodeId, false);
    }

    @Override
    public void cacheStep(List<String> participants, StInstance instance, ActivityNode activityNode, Integer stepIdNum, AtomicInteger stepState, boolean adjust) {
        if (activityNode != null && activityNode.getChildFlowData() != null && activityNode.getChildFlowData().getFlowCode() != null) {
            this.autoFlow(participants, instance, activityNode, stepIdNum);
            if (activityNode.getChildFlowData().getAsync().booleanValue()) {
                stepState.set(StepState.LEAVE.getCode());
                this.coreBpmFlowAnalysis.analyzeThePathAndStartTheSteps(activityNode.getId(), instance);
            } else {
                stepState.set(StepState.STAY.getCode());
            }
        }
    }

    @Override
    public void cache(ActivityNode an, StInstanceBase instance, Integer estStep) {
        this.rd.setCacheMapValue(RedisKeys.getEstStep((String)instance.getObjectid(), (String[])new String[0]), an.getId(), (Object)estStep.toString());
        this.action.futureMaybeInThis(an.getId(), instance, estStep);
    }

    private void autoFlow(List<String> participants, StInstance instance, ActivityNode activityNode, Integer stepIdNum) {
        for (String part : participants) {
            StTaskitem stTaskitem = this.flowService.autoSave(activityNode.getChildFlowData().getFlowCode(), new JSONObject(), part);
            StInstance stInstance = this.flowService.getStInstance(stTaskitem.getInstanceid());
            stInstance.setParentInstanceid(instance.getObjectid());
            stInstance.setParentActivityCode(activityNode.getCode());
            stInstance.setParentStepId(stepIdNum);
            this.flowService.updateStInstance(stInstance);
            if (!activityNode.getChildFlowData().getAutoSubmit().booleanValue()) continue;
        }
    }
}

