/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.sa.flow.engine.engine.workflow.strategies;

import com.alibaba.fastjson.JSONObject;
import com.cloud.sa.flow.commom.common.redis.StRedisCache;
import com.cloud.sa.flow.commom.common.utils.StString;
import com.cloud.sa.flow.commom.domain.common.RedisKeys;
import com.cloud.sa.flow.commom.domain.entity.StFlowTemplate;
import com.cloud.sa.flow.commom.domain.entity.StInstance;
import com.cloud.sa.flow.commom.domain.entity.StInstanceBase;
import com.cloud.sa.flow.commom.domain.entity.StStep;
import com.cloud.sa.flow.commom.domain.virentity.ActivityNode;
import com.cloud.sa.flow.commom.domain.virentity.FlowTemplateMainContent;
import com.cloud.sa.flow.commom.domain.virentity.ViewList;
import com.cloud.sa.flow.commom.domain.virenum.InstanceState;
import com.cloud.sa.flow.commom.domain.virenum.NodeColorType;
import com.cloud.sa.flow.commom.domain.virenum.StepState;
import com.cloud.sa.flow.commom.service.flow.StStepService;
import com.cloud.sa.flow.commom.service.flow.StTaskItemService;
import com.cloud.sa.flow.engine.engine.action.strategies.ViewFlowAction;
import com.cloud.sa.flow.engine.engine.coreface.CoreBpmFlowAnalysisInterface;
import com.cloud.sa.flow.engine.engine.workflow.NodeStrategy;
import com.cloud.sa.flow.engine.service.StFlowService;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EndNodeStrategy
extends NodeStrategy {
    @Autowired
    CoreBpmFlowAnalysisInterface coreBpmFlowAnalysis;
    @Autowired
    StRedisCache rd;
    @Autowired
    ViewFlowAction action;
    @Autowired
    StTaskItemService taskItemService;
    @Autowired
    StFlowService flowService;
    @Autowired
    StStepService stepService;

    @Override
    public void cacheColor(JSONObject joData, StStep step, StInstance stInstance, String nodeId) {
        if (stInstance.getState().equals(InstanceState.FINISHED.getCode())) {
            joData.put("steped", (Object)NodeColorType.FINISH.getCode());
        } else if (stInstance.getState().equals(InstanceState.CANCEL.getCode())) {
            joData.put("steped", (Object)NodeColorType.MISS.getCode());
        } else {
            joData.put("steped", (Object)NodeColorType.FUTURE.getCode());
        }
        String viewListKey = RedisKeys.getViewList((String)stInstance.getObjectid(), (String[])new String[0]);
        ViewList viewList = new ViewList();
        viewList.setNodeName("\u7ed3\u675f");
        viewList.setSystemTime(Long.valueOf(System.nanoTime()));
        viewList.setStep(Integer.valueOf(99999999));
        this.rd.setCacheList(viewListKey, Collections.singletonList(viewList));
    }

    @Override
    public void cacheStep(List<String> participants, StInstance instance, ActivityNode activityNode, Integer stepIdNum, AtomicInteger stepState, boolean adjust) {
        FlowTemplateMainContent mainContent;
        String endEvent;
        JSONObject jsonObject;
        StFlowTemplate flowTemplate;
        this.coreBpmFlowAnalysis.overTargetTask(instance.getObjectid(), true);
        instance.setState(InstanceState.FINISHED.getCode());
        instance.setFinishTime(LocalDateTime.now());
        this.flowService.updateStInstance(instance);
        String parentInstanceid = instance.getParentInstanceid();
        if (StString.isNotEmpty((String)parentInstanceid)) {
            StInstance parentInstance = this.flowService.getStInstance(parentInstanceid);
            StStep parentStep = this.stepService.getStepByInstanceIdAndStepId(parentInstanceid, instance.getParentStepId());
            ActivityNode an = (ActivityNode)this.rd.getCacheMapValue(RedisKeys.getTempNodeEntity((String)parentInstance.getFlowCode(), (Integer)parentInstance.getFlowVersion(), (String[])new String[0]), parentStep.getNodeid());
            if (an.getChildFlowData() != null && !an.getChildFlowData().getAsync().booleanValue()) {
                parentStep.setState(StepState.LEAVE.getCode());
                parentStep.setFinishTime(LocalDateTime.now());
                this.stepService.updateStStep(parentStep);
                this.coreBpmFlowAnalysis.analyzeThePathAndStartTheSteps(parentStep.getNodeid(), parentInstance);
            }
        }
        if ((flowTemplate = this.flowService.getStFlowTemplate(instance.getFlowCode(), instance.getFlowVersion())).getMainContent() != null && (jsonObject = JSONObject.parseObject((String)flowTemplate.getMainContent())) != null && StString.isNotEmpty((String)(endEvent = (mainContent = (FlowTemplateMainContent)jsonObject.toJavaObject(FlowTemplateMainContent.class)).getEndEvent()))) {
            String instanceJson = this.coreBpmFlowAnalysis.eventParam(instance);
            this.coreBpmFlowAnalysis.triggerEvent(instance, instanceJson, Integer.parseInt(endEvent), "endAction");
        }
    }

    @Override
    public void cache(ActivityNode an, StInstanceBase instance, Integer estStep) {
        this.rd.setCacheMapValue(RedisKeys.getEstStep((String)instance.getObjectid(), (String[])new String[0]), an.getId(), (Object)estStep.toString());
    }
}

