/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.sa.flow.engine.engine.workflow.strategies;

import cn.dev33.satoken.stp.StpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.cloud.sa.flow.commom.common.Request.StHttpRequest;
import com.cloud.sa.flow.commom.common.redis.StRedisCache;
import com.cloud.sa.flow.commom.common.utils.StString;
import com.cloud.sa.flow.commom.domain.common.RedisKeys;
import com.cloud.sa.flow.commom.domain.entity.StInstance;
import com.cloud.sa.flow.commom.domain.entity.StInstanceBase;
import com.cloud.sa.flow.commom.domain.entity.StStep;
import com.cloud.sa.flow.commom.domain.entity.StTaskitem;
import com.cloud.sa.flow.commom.domain.virentity.ActivityNode;
import com.cloud.sa.flow.commom.domain.virentity.FlowEnteredParam;
import com.cloud.sa.flow.commom.domain.virenum.StepState;
import com.cloud.sa.flow.commom.service.flow.StTaskItemService;
import com.cloud.sa.flow.commom.service.setting.StSettingService;
import com.cloud.sa.flow.engine.engine.action.strategies.ViewFlowAction;
import com.cloud.sa.flow.engine.engine.coreface.CoreBpmFlowAnalysisInterface;
import com.cloud.sa.flow.engine.engine.workflow.NodeStrategy;
import com.cloud.sa.flow.engine.service.StFlowService;
import com.cloud.sa.flow.engine.service.form.StFormService;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ChildFlowNodeStrategy
extends NodeStrategy {
    @Autowired
    CoreBpmFlowAnalysisInterface coreBpmFlowAnalysis;
    @Autowired
    StRedisCache rd;
    @Autowired
    ViewFlowAction action;
    @Autowired
    StTaskItemService taskItemService;
    @Autowired
    StFlowService flowService;
    @Autowired
    StFormService formService;
    @Autowired
    StSettingService settingService;
    @Value(value="${server.port}")
    private String port;

    @Override
    public void cacheColor(JSONObject joData, StStep step, StInstance stInstance, String nodeId) {
        this.cacheNodeTemplateValue(joData, step, stInstance, nodeId, false);
    }

    @Override
    public void cacheStep(List<String> participants, StInstance instance, ActivityNode activityNode, Integer stepIdNum, AtomicInteger stepState, boolean adjust) {
        if (activityNode != null && activityNode.getChildFlowData() != null && activityNode.getChildFlowData().getFlowCode() != null) {
            this.autoFlow(participants, instance, activityNode, stepIdNum);
            if (activityNode.getChildFlowData().getAsync().booleanValue()) {
                stepState.set(StepState.LEAVE.getCode());
                this.coreBpmFlowAnalysis.analyzeThePathAndStartTheSteps(activityNode.getId(), instance);
            } else {
                stepState.set(StepState.STAY.getCode());
            }
        }
    }

    @Override
    public void cache(ActivityNode an, StInstanceBase instance, Integer estStep) {
        this.rd.setCacheMapValue(RedisKeys.getEstStep((String)instance.getObjectid(), (String[])new String[0]), an.getId(), (Object)estStep.toString());
        this.action.futureMaybeInThis(an.getId(), instance, estStep);
    }

    private void autoFlow(List<String> participants, StInstance instance, ActivityNode activityNode, Integer stepIdNum) {
        JSONObject allFormTableData = this.formService.getAllFormTableData(instance.getFlowCode(), instance.getBizObjectid(), null);
        for (String part : participants) {
            JSONObject mainData = new JSONObject();
            JSONArray mapping = activityNode.getChildFlowData().getMapping();
            for (Object o : mapping) {
                String mainField = ((JSONObject)o).getString("mainField");
                String childField = ((JSONObject)o).getString("childField");
                if (!allFormTableData.containsKey((Object)mainField)) continue;
                mainData.put(childField, allFormTableData.get((Object)mainField));
            }
            StTaskitem childTaskitem = this.flowService.autoSave(activityNode.getChildFlowData().getFlowCode(), mainData, part);
            StInstance childInstance = this.flowService.getStInstance(childTaskitem.getInstanceid());
            childInstance.setParentInstanceid(instance.getObjectid());
            childInstance.setParentActivityCode(activityNode.getCode());
            childInstance.setParentStepId(stepIdNum);
            this.flowService.updateStInstance(childInstance);
            if (!activityNode.getChildFlowData().getAutoSubmit().booleanValue()) continue;
            try {
                FlowEnteredParam flowEnteredParam = new FlowEnteredParam();
                flowEnteredParam.setFlowCode(childInstance.getFlowCode());
                flowEnteredParam.setFlowVersion(childInstance.getFlowVersion());
                flowEnteredParam.setBizObjectid(childInstance.getBizObjectid());
                flowEnteredParam.setTaskid(childTaskitem.getObjectid());
                String token = StpUtil.getTokenValue();
                Thread thread = new Thread(() -> {
                    try {
                        Thread.sleep(10000L);
                        StHttpRequest.postHttpClient((String)(StString.getLocalHost((String)this.port) + "/bpm/core/instance/autosubmit"), (String)JSON.toJSONString((Object)flowEnteredParam), (String)token);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
                thread.start();
            }
            catch (Exception e) {
                this.settingService.FlowCommonExceptionRecord(e, childTaskitem.getObjectid(), "\u5b50\u6d41\u7a0b\u81ea\u52a8\u63d0\u4ea4");
            }
        }
    }
}

