/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.sa.flow.engine.engine.workflow.strategies;

import com.alibaba.fastjson.JSONObject;
import com.cloud.sa.flow.commom.common.redis.StRedisCache;
import com.cloud.sa.flow.commom.domain.common.RedisKeys;
import com.cloud.sa.flow.commom.domain.entity.StInstance;
import com.cloud.sa.flow.commom.domain.entity.StInstanceBase;
import com.cloud.sa.flow.commom.domain.entity.StStep;
import com.cloud.sa.flow.commom.domain.virentity.ActivityNode;
import com.cloud.sa.flow.commom.domain.virenum.ActivityPartnerState;
import com.cloud.sa.flow.commom.domain.virenum.StepState;
import com.cloud.sa.flow.commom.domain.virenum.TaskitemState;
import com.cloud.sa.flow.engine.engine.action.strategies.ViewFlowAction;
import com.cloud.sa.flow.engine.engine.coreface.CoreBpmFlowAnalysisInterface;
import com.cloud.sa.flow.engine.engine.workflow.NodeStrategy;
import com.cloud.sa.flow.engine.service.StFlowService;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AuditNodeStrategy
extends NodeStrategy {
    @Autowired
    CoreBpmFlowAnalysisInterface coreBpmFlowAnalysis;
    @Autowired
    StFlowService flowService;
    @Autowired
    StRedisCache rd;
    @Autowired
    ViewFlowAction action;

    @Override
    public void cacheColor(JSONObject joData, StStep step, StInstance stInstance, String nodeId) {
        this.cacheNodeTemplateValue(joData, step, stInstance, nodeId, true);
    }

    @Override
    public void cacheStep(List<String> participants, StInstance instance, ActivityNode activityNode, Integer stepIdNum, AtomicInteger stepState, boolean adjust) {
        stepState.set(StepState.STAY.getCode());
        boolean goToNextStep = this.processingAuditActivities(participants, instance, activityNode, stepIdNum, adjust);
        if (goToNextStep) {
            stepState.set(StepState.LEAVE.getCode());
            this.coreBpmFlowAnalysis.analyzeThePathAndStartTheSteps(activityNode.getId(), instance);
        }
    }

    @Override
    public void cache(ActivityNode an, StInstanceBase instance, Integer estStep) {
        List<String> participants = this.flowService.getEngineTools().anaP(this.flowService.getStInstance(instance.getObjectid()), an);
        LinkedList<String> parts = new LinkedList<String>();
        for (String str : participants) {
            parts.add(this.flowService.getOrganizeService().GetUserByCode(str).getUserName());
        }
        this.rd.setCacheMapValue(RedisKeys.getEstStep((String)instance.getObjectid(), (String[])new String[0]), an.getId(), (Object)estStep.toString());
        this.rd.setCacheMapValue(RedisKeys.getEstParticipants((String)instance.getObjectid(), (String[])new String[0]), an.getId(), participants);
        this.action.futureMaybeInThis(an.getId(), instance, estStep);
    }

    public boolean processingAuditActivities(List<String> participants, StInstance instance, ActivityNode activityNode, Integer curStepid, boolean adjust) {
        boolean goToNextStep = false;
        String noUser = activityNode.getPartnerNoUser();
        participants = participants.stream().distinct().collect(Collectors.toList());
        if (!adjust && participants.size() == 0) {
            if (ActivityPartnerState.NO_HANDLE.getCode().equals(noUser)) {
                this.flowService.IstStTaskItem(0, "admin", instance, activityNode, curStepid);
                return false;
            }
            if (ActivityPartnerState.PASS.getCode().equals(noUser)) {
                goToNextStep = true;
                return goToNextStep;
            }
        }
        List<String> participantPassed = this.flowService.getParticipantPassed(instance.getObjectid());
        String initiator = activityNode.getPartnerInitiator();
        String action = activityNode.getPartnerAction();
        int passNum = 0;
        for (String part : participants) {
            TaskitemState taskitemState = TaskitemState.CREATE;
            Integer autoPass = 0;
            if (part.equals(instance.getOriginator())) {
                if (!adjust && !ActivityPartnerState.NO_HANDLE.getCode().equals(initiator) && ActivityPartnerState.PASS.getCode().equals(initiator)) {
                    ++passNum;
                    taskitemState = TaskitemState.APPROVED;
                    autoPass = 1;
                }
            } else if (participantPassed != null && participantPassed.contains(part) && !adjust && !ActivityPartnerState.NO_HANDLE.getCode().equals(action) && ActivityPartnerState.PASS.getCode().equals(action)) {
                ++passNum;
                taskitemState = TaskitemState.APPROVED;
                autoPass = 1;
            }
            this.flowService.IstStTaskItem(autoPass, part, instance, activityNode, curStepid, taskitemState.getCode());
        }
        if (passNum == participants.size()) {
            goToNextStep = true;
        }
        return goToNextStep;
    }
}

