/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.sa.flow.engine.engine.workflow;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.cloud.sa.flow.commom.common.redis.StRedisCache;
import com.cloud.sa.flow.commom.domain.common.RedisKeys;
import com.cloud.sa.flow.commom.domain.entity.StInstance;
import com.cloud.sa.flow.commom.domain.entity.StInstanceBase;
import com.cloud.sa.flow.commom.domain.entity.StStep;
import com.cloud.sa.flow.commom.domain.virentity.ActivityNode;
import com.cloud.sa.flow.commom.domain.virentity.StUser;
import com.cloud.sa.flow.commom.domain.virentity.ViewList;
import com.cloud.sa.flow.commom.domain.virentity.ViewListParticipant;
import com.cloud.sa.flow.commom.domain.virenum.NodeColorType;
import com.cloud.sa.flow.commom.domain.virenum.NodeType;
import com.cloud.sa.flow.engine.core.INodeStrategy;
import com.cloud.sa.flow.engine.service.StFlowService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public abstract class NodeStrategy
implements INodeStrategy {
    @Autowired
    StRedisCache rd;
    @Autowired
    StFlowService service;

    @Override
    public abstract void cacheColor(JSONObject var1, StStep var2, StInstance var3, String var4);

    @Override
    public abstract void cacheStep(List<String> var1, StInstance var2, ActivityNode var3, Integer var4, AtomicInteger var5, boolean var6);

    @Override
    public abstract void cache(ActivityNode var1, StInstanceBase var2, Integer var3);

    @Override
    public void cacheNodeTemplateValue(JSONObject joData, StStep step, StInstance stInstance, String nodeId, boolean isHaveParticipant) {
        String stepId;
        ActivityNode node = (ActivityNode)this.rd.getCacheMapValue(RedisKeys.getTempNodeEntity((String)stInstance.getFlowCode(), (Integer)stInstance.getFlowVersion(), (String[])new String[0]), nodeId);
        String viewListKey = RedisKeys.getViewList((String)stInstance.getObjectid(), (String[])new String[0]);
        ViewList viewList = new ViewList();
        if (step != null) {
            this.setColorRule(joData, step.getState());
            if (NodeType.WRITE.getCode().equals(node.getNodeType())) {
                viewList.setNodeName("\u586b\u5199");
                StUser stUser = (StUser)this.rd.getCacheMapValue(RedisKeys.getUserByCode((String[])new String[0]), stInstance.getOriginator());
                ViewListParticipant viewListParticipant = new ViewListParticipant();
                viewListParticipant.setParticipant(stUser);
                viewListParticipant.setFinish(step.getApproval() == 1);
                viewList.setParticipants(Collections.singletonList(viewListParticipant));
                viewList.setSystemTime(Long.valueOf(System.nanoTime()));
                viewList.setStep(Integer.valueOf(1));
                viewList.setFinish(true);
                this.rd.setCacheList(viewListKey, Collections.singletonList(viewList));
            }
        }
        if ((stepId = (String)this.rd.getCacheMapValue(RedisKeys.getEstStep((String)stInstance.getObjectid(), (String[])new String[0]), nodeId)) != null) {
            List participants;
            this.setColorRule(joData, NodeColorType.FUTURE.getCode());
            ArrayList<ViewListParticipant> viewListParticipants = new ArrayList<ViewListParticipant>();
            if (viewList != null) {
                viewList.setNodeName(node.getName());
                viewList.setSystemTime(Long.valueOf(System.nanoTime()));
                viewList.setStep(Integer.valueOf(Integer.parseInt(stepId)));
                viewList.setTaskCode(node.getCode());
                viewList.setFinish(false);
                viewList.setParticipants(viewListParticipants);
            }
            if (isHaveParticipant && (participants = (List)this.rd.getCacheMapValue(RedisKeys.getEstParticipants((String)stInstance.getObjectid(), (String[])new String[0]), nodeId)) != null) {
                JSONArray jaParticipantName = new JSONArray();
                joData.put("escParticipant", (Object)jaParticipantName);
                for (String participantId : participants) {
                    StUser stUser = (StUser)this.rd.getCacheMapValue(RedisKeys.getUserByCode((String[])new String[0]), participantId);
                    jaParticipantName.add((Object)stUser.getUserName());
                    ViewListParticipant viewListParticipant = new ViewListParticipant();
                    viewListParticipant.setParticipant(stUser);
                    viewListParticipant.setFinish(false);
                    viewListParticipants.add(viewListParticipant);
                }
            }
        }
        if (NodeType.AUDIT.getCode().equals(node.getNodeType())) {
            this.rd.setCacheList(viewListKey, Collections.singletonList(viewList));
        }
    }

    private void setColorRule(JSONObject joData, Integer state) {
        Object o = joData.get((Object)"steped");
        if (o == null) {
            joData.put("steped", (Object)state);
        } else if (NodeColorType.EXCEPTION.getCode().equals(state)) {
            joData.put("steped", (Object)state);
        } else {
            Integer curState = (Integer)o;
            if (!NodeColorType.CURRENT.getCode().equals(curState) && !NodeColorType.EXCEPTION.getCode().equals(curState)) {
                joData.put("steped", (Object)state);
            }
        }
    }
}

