/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.sa.flow.engine.engine.action.strategies;

import com.alibaba.fastjson.JSONObject;
import com.cloud.sa.flow.commom.common.redis.StRedisCache;
import com.cloud.sa.flow.commom.common.system.StUserInfo;
import com.cloud.sa.flow.commom.common.utils.StString;
import com.cloud.sa.flow.commom.domain.common.RedisKeys;
import com.cloud.sa.flow.commom.domain.entity.StInstance;
import com.cloud.sa.flow.commom.domain.entity.StInstanceBase;
import com.cloud.sa.flow.commom.domain.mapper.StCommonMapper;
import com.cloud.sa.flow.commom.domain.virentity.Column;
import com.cloud.sa.flow.commom.domain.virentity.FlowEnteredParam;
import com.cloud.sa.flow.commom.service.genSql.SqlGeneratorService;
import com.cloud.sa.flow.engine.engine.action.ActionStrategy;
import com.cloud.sa.flow.engine.engine.utils.LogsUtils;
import com.cloud.sa.flow.engine.mop.flow.NodeLogic;
import com.cloud.sa.flow.engine.service.StFlowService;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SaveAction
extends ActionStrategy {
    @Autowired
    StFlowService service;
    @Autowired
    LogsUtils logsUtils;
    @Autowired
    StRedisCache rd;
    @Autowired
    SqlGeneratorService sqlGenerator;
    @Autowired
    StCommonMapper commonMapper;

    @Override
    public void applyBefore(Object[] args) {
        FlowEnteredParam flowEnteredParam = (FlowEnteredParam)args[0];
        StInstanceBase stInstanceBase = new StInstanceBase(null, flowEnteredParam.getBizObjectid(), flowEnteredParam.getFlowVersion(), flowEnteredParam.getFlowCode(), Integer.valueOf(0));
        this.initTemplateFlow(stInstanceBase);
        NodeLogic.initFlowData(stInstanceBase.getBizObjectid());
        this.service.InitPersistAll(stInstanceBase.getFlowCode(), stInstanceBase.getBizObjectid());
    }

    @Override
    public void applyAfter(Object[] args) {
        FlowEnteredParam flowEnteredParam = (FlowEnteredParam)args[0];
        boolean targetSave = (Boolean)args[1];
        StInstanceBase stInstanceBase = new StInstanceBase(null, flowEnteredParam.getBizObjectid(), flowEnteredParam.getFlowVersion(), flowEnteredParam.getFlowCode(), Integer.valueOf(0));
        this.saveTrace(flowEnteredParam);
        this.service.getFormService().resetFormDataCache(flowEnteredParam.getFlowCode(), stInstanceBase.getBizObjectid());
        NodeLogic.clearFlowData(stInstanceBase.getBizObjectid());
        if (targetSave) {
            String logFlag = "";
            logFlag = flowEnteredParam.getCodeModify() != false ? "\u63a5\u53e3\u4fdd\u5b58" : "\u4fdd\u5b58";
            if (!StString.isEmpty((String)flowEnteredParam.getTaskid())) {
                this.logsUtils.addLogs(null, this.service.getStTaskitem(flowEnteredParam.getTaskid()), logFlag);
            } else {
                StInstance instance = this.service.getStInstanceByBizobjectid(flowEnteredParam.getBizObjectid());
                if (instance != null) {
                    this.logsUtils.addLogs(instance.getObjectid(), null, logFlag);
                }
            }
        }
    }

    private void saveTrace(FlowEnteredParam flowEnteredParam) {
        String formDataKey = RedisKeys.getMainFormData((String)flowEnteredParam.getBizObjectid(), (String[])new String[0]);
        String templateFieldKey = RedisKeys.getTemplateFieldData((String)flowEnteredParam.getFlowCode(), (String[])new String[0]);
        JSONObject mainJsonObject = JSONObject.parseObject((String)flowEnteredParam.getTableData());
        Map cacheMap = this.rd.getCacheMap(templateFieldKey);
        for (Map.Entry entry : cacheMap.entrySet()) {
            if (((Column)entry.getValue()).getTrace() == null || !((Column)entry.getValue()).getTrace().equals(true) || !mainJsonObject.containsKey((Object)((Column)entry.getValue()).getCode())) continue;
            Object oldValue = this.rd.getCacheMapValue(formDataKey, (String)entry.getKey());
            String sql = this.sqlGenerator.getFieldTraceInsert(flowEnteredParam.getBizObjectid(), StString.toString((Object)oldValue), mainJsonObject.getString(((Column)entry.getValue()).getCode()), ((Column)entry.getValue()).getCode(), StUserInfo.getUserCode());
            this.commonMapper.insertSql(sql);
        }
    }

    @Override
    public void applyThrowing(Object[] args) {
        FlowEnteredParam flowEnteredParam = (FlowEnteredParam)args[0];
        StInstanceBase stInstanceBase = new StInstanceBase(null, flowEnteredParam.getBizObjectid(), flowEnteredParam.getFlowVersion(), flowEnteredParam.getFlowCode(), Integer.valueOf(0));
        this.service.getFormService().resetFormDataCache(flowEnteredParam.getFlowCode(), stInstanceBase.getBizObjectid());
        NodeLogic.clearFlowData(stInstanceBase.getBizObjectid());
    }
}

