/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.sa.flow.engine.core.builders;

import com.cloud.sa.flow.commom.common.system.StUserInfo;
import com.cloud.sa.flow.commom.common.utils.StString;
import com.cloud.sa.flow.commom.domain.entity.StTaskitem;
import com.cloud.sa.flow.commom.domain.virenum.TaskitemState;
import java.time.LocalDateTime;

public class StTaskitemBuilder {
    private StTaskitem taskitem = new StTaskitem();

    public StTaskitemBuilder withOriginator(String originator) {
        this.taskitem.setOriginator(originator);
        return this;
    }

    public StTaskitemBuilder withParticipant(String participant) {
        this.taskitem.setParticipant(participant);
        return this;
    }

    public StTaskitemBuilder withFinisher(String finisher) {
        this.taskitem.setFinisher(finisher);
        return this;
    }

    public StTaskitemBuilder withState(Integer state) {
        this.taskitem.setState(state);
        return this;
    }

    public StTaskitemBuilder withFlowCode(String flowCode) {
        this.taskitem.setFlowCode(flowCode);
        return this;
    }

    public StTaskitemBuilder withFlowVersion(Integer flowVersion) {
        this.taskitem.setFlowVersion(flowVersion);
        return this;
    }

    public StTaskitemBuilder withActivityCode(String activityCode) {
        this.taskitem.setActivityCode(activityCode);
        return this;
    }

    public StTaskitemBuilder withActivityName(String activityName) {
        this.taskitem.setActivityName(activityName);
        return this;
    }

    public StTaskitemBuilder withInstanceid(String instanceid) {
        this.taskitem.setInstanceid(instanceid);
        return this;
    }

    public StTaskitemBuilder withBizObjectid(String bizObjectid) {
        this.taskitem.setBizObjectid(bizObjectid);
        return this;
    }

    public StTaskitemBuilder withStepid(Integer stepid) {
        this.taskitem.setStepid(stepid);
        return this;
    }

    public StTaskitemBuilder withFormCode(String formCode) {
        this.taskitem.setFormCode(formCode);
        return this;
    }

    public StTaskitemBuilder withReceiveTime(LocalDateTime receiveTime) {
        this.taskitem.setReceiveTime(receiveTime);
        return this;
    }

    public StTaskitemBuilder withStartTime(LocalDateTime startTime) {
        this.taskitem.setStartTime(startTime);
        return this;
    }

    public StTaskitemBuilder withFinishTime(LocalDateTime finishTime) {
        this.taskitem.setFinishTime(finishTime);
        return this;
    }

    public StTaskitemBuilder withDelegent(String delegent) {
        this.taskitem.setDelegent(delegent);
        return this;
    }

    public StTaskitemBuilder withForwarder(String forwarder) {
        this.taskitem.setForwarder(forwarder);
        return this;
    }

    public StTaskitemBuilder withItemType(String itemType) {
        this.taskitem.setItemType(itemType);
        return this;
    }

    public StTaskitemBuilder withObjectid(String objectid) {
        this.taskitem.setObjectid(objectid);
        return this;
    }

    public StTaskitemBuilder withCreateBy(String createBy) {
        this.taskitem.setCreateBy(createBy);
        return this;
    }

    public StTaskitemBuilder withCreateTime(LocalDateTime createTime) {
        this.taskitem.setCreateTime(createTime);
        return this;
    }

    public StTaskitemBuilder withUpdateBy(String updateBy) {
        this.taskitem.setUpdateBy(updateBy);
        return this;
    }

    public StTaskitemBuilder withUpdateTime(LocalDateTime updateTime) {
        this.taskitem.setUpdateTime(updateTime);
        return this;
    }

    public StTaskitem build() {
        if (StString.isEmpty((String)this.taskitem.getObjectid())) {
            this.taskitem.setObjectid(StString.getUUID());
        }
        if (this.taskitem.getCreateTime() == null) {
            this.taskitem.setCreateTime(LocalDateTime.now());
        }
        if (this.taskitem.getStartTime() == null) {
            this.taskitem.setStartTime(LocalDateTime.now());
        }
        if (this.taskitem.getReceiveTime() == null) {
            this.taskitem.setReceiveTime(LocalDateTime.now());
        }
        if (StString.isEmpty((String)this.taskitem.getOriginator())) {
            this.taskitem.setOriginator(StUserInfo.getUserCode());
        }
        if (StString.isEmpty((String)this.taskitem.getCreateBy())) {
            this.taskitem.setCreateBy(StUserInfo.getUserCode());
        }
        if (this.taskitem.getState() == null) {
            this.taskitem.setState(TaskitemState.CREATE.getCode());
        }
        return this.taskitem;
    }

    public static StTaskitemBuilder newBuilder() {
        return new StTaskitemBuilder();
    }
}

